/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms;

import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceConfigurationException;
import bitronix.tm.resource.ResourceObjectFactory;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAPool;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.jms.DualSessionWrapper;
import bitronix.tm.resource.jms.JmsConnectionHandle;
import bitronix.tm.resource.jms.JmsPooledConnection;
import bitronix.tm.resource.jms.PoolingConnectionFactoryMBean;
import bitronix.tm.utils.ManagementRegistrar;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolingConnectionFactory
extends ResourceBean
implements ConnectionFactory,
XAResourceProducer<DualSessionWrapper, JmsPooledConnection>,
PoolingConnectionFactoryMBean {
    private static final Logger log = LoggerFactory.getLogger(PoolingConnectionFactory.class);
    private volatile transient XAPool<DualSessionWrapper, JmsPooledConnection> pool;
    private volatile transient XAConnectionFactory xaConnectionFactory;
    private volatile transient JmsPooledConnection recoveryPooledConnection;
    private volatile transient RecoveryXAResourceHolder recoveryXAResourceHolder;
    private final transient List<JmsPooledConnection> xaStatefulHolders = new CopyOnWriteArrayList<JmsPooledConnection>();
    private volatile boolean cacheProducersConsumers = true;
    private volatile boolean testConnections = false;
    private volatile String user;
    private volatile String password;
    private volatile JmsConnectionHandle recoveryConnectionHandle;
    private volatile String jmxName;

    @Override
    public synchronized void init() {
        try {
            if (this.pool != null) {
                return;
            }
            this.buildXAPool();
            this.jmxName = "bitronix.tm:type=JMS,UniqueName=" + ManagementRegistrar.makeValidName(this.getUniqueName());
            ManagementRegistrar.register(this.jmxName, this);
        }
        catch (Exception ex) {
            throw new ResourceConfigurationException("cannot create JMS connection factory named " + this.getUniqueName(), ex);
        }
    }

    public boolean getCacheProducersConsumers() {
        return this.cacheProducersConsumers;
    }

    public void setCacheProducersConsumers(boolean cacheProducersConsumers) {
        this.cacheProducersConsumers = cacheProducersConsumers;
    }

    public boolean getTestConnections() {
        return this.testConnections;
    }

    public void setTestConnections(boolean testConnections) {
        this.testConnections = testConnections;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public XAConnectionFactory getXaConnectionFactory() {
        return this.xaConnectionFactory;
    }

    public void setXaConnectionFactory(XAConnectionFactory xaConnectionFactory) {
        this.xaConnectionFactory = xaConnectionFactory;
    }

    private void buildXAPool() throws Exception {
        if (this.pool != null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("building JMS XA pool for " + this.getUniqueName() + " with " + this.getMinPoolSize() + " connection(s)");
        }
        this.pool = new XAPool<DualSessionWrapper, JmsPooledConnection>(this, this, this.xaConnectionFactory);
        boolean builtXaFactory = false;
        if (this.xaConnectionFactory == null) {
            this.xaConnectionFactory = (XAConnectionFactory)this.pool.getXAFactory();
            builtXaFactory = true;
        }
        try {
            ResourceRegistrar.register(this);
        }
        catch (RecoveryException ex) {
            if (builtXaFactory) {
                this.xaConnectionFactory = null;
            }
            this.pool = null;
            throw ex;
        }
    }

    public Connection createConnection() throws JMSException {
        if (this.isDisabled()) {
            throw new JMSException("JMS connection pool '" + this.getUniqueName() + "' is disabled, cannot get a connection from it");
        }
        try {
            this.init();
            return (Connection)this.pool.getConnectionHandle();
        }
        catch (Exception ex) {
            throw (JMSException)new JMSException("unable to get a connection from pool of " + this).initCause((Throwable)ex);
        }
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug("JMS connections are pooled, username and password ignored");
        }
        return this.createConnection();
    }

    void unregister(JmsPooledConnection jmsPooledConnection) {
        this.xaStatefulHolders.remove(jmsPooledConnection);
    }

    public String toString() {
        return "a PoolingConnectionFactory with " + this.pool;
    }

    @Override
    public XAResourceHolderState startRecovery() throws RecoveryException {
        this.init();
        if (this.recoveryPooledConnection != null) {
            throw new RecoveryException("recovery already in progress on " + this);
        }
        try {
            this.recoveryConnectionHandle = (JmsConnectionHandle)this.pool.getConnectionHandle(false);
            this.recoveryPooledConnection = this.recoveryConnectionHandle.getPooledConnection();
            this.recoveryXAResourceHolder = this.recoveryPooledConnection.createRecoveryXAResourceHolder();
            return new XAResourceHolderState(this.recoveryXAResourceHolder, this.recoveryPooledConnection.getPoolingConnectionFactory());
        }
        catch (Exception ex) {
            throw new RecoveryException("error starting recovery", ex);
        }
    }

    @Override
    public void endRecovery() throws RecoveryException {
        block11: {
            if (this.recoveryPooledConnection == null) {
                return;
            }
            try {
                if (this.recoveryConnectionHandle != null) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("recovery connection handle is being closed: " + this.recoveryConnectionHandle);
                        }
                        this.recoveryConnectionHandle.close();
                    }
                    catch (Exception ex) {
                        throw new RecoveryException("error ending recovery", ex);
                    }
                }
                if (this.recoveryXAResourceHolder == null) break block11;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("recovery xa resource is being closed: " + this.recoveryXAResourceHolder);
                    }
                    this.recoveryXAResourceHolder.close();
                }
                catch (Exception ex) {
                    throw new RecoveryException("error ending recovery", ex);
                }
            }
            finally {
                this.recoveryConnectionHandle = null;
                this.recoveryXAResourceHolder = null;
                this.recoveryPooledConnection = null;
            }
        }
    }

    @Override
    public void setFailed(boolean failed) {
        this.pool.setFailed(failed);
    }

    @Override
    public boolean isFailed() {
        return this.pool.isFailed();
    }

    @Override
    public void close() {
        if (this.pool == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("closing " + this.pool);
        }
        this.pool.close();
        this.pool = null;
        ManagementRegistrar.unregister(this.jmxName);
        this.jmxName = null;
        ResourceRegistrar.unregister(this);
    }

    @Override
    public JmsPooledConnection createPooledConnection(Object xaFactory, ResourceBean bean) throws Exception {
        XAConnection xaConnection;
        if (!(xaFactory instanceof XAConnectionFactory)) {
            throw new IllegalArgumentException("class '" + xaFactory.getClass().getName() + "' does not implement " + XAConnectionFactory.class.getName());
        }
        XAConnectionFactory xaConnectionFactory = (XAConnectionFactory)xaFactory;
        if (this.user == null || this.password == null) {
            if (log.isDebugEnabled()) {
                log.debug("creating new JMS XAConnection with no credentials");
            }
            xaConnection = xaConnectionFactory.createXAConnection();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("creating new JMS XAConnection with user <" + this.user + "> and password <" + this.password + ">");
            }
            xaConnection = xaConnectionFactory.createXAConnection(this.user, this.password);
        }
        JmsPooledConnection jmsPooledConnection = new JmsPooledConnection(this, xaConnection);
        this.xaStatefulHolders.add(jmsPooledConnection);
        return jmsPooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DualSessionWrapper findXAResourceHolder(XAResource xaResource) {
        List<JmsPooledConnection> list = this.xaStatefulHolders;
        synchronized (list) {
            for (JmsPooledConnection jmsPooledConnection : this.xaStatefulHolders) {
                DualSessionWrapper xaResourceHolder = jmsPooledConnection.getXAResourceHolderForXaResource(xaResource);
                if (xaResourceHolder == null) continue;
                return xaResourceHolder;
            }
            return null;
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug("creating new JNDI reference of " + this);
        }
        return new Reference(PoolingConnectionFactory.class.getName(), new StringRefAddr("uniqueName", this.getUniqueName()), ResourceObjectFactory.class.getName(), null);
    }

    @Override
    public long getInPoolSize() {
        return this.pool.inPoolSize();
    }

    @Override
    public long getTotalPoolSize() {
        return this.pool.totalPoolSize();
    }

    @Override
    public void reset() throws Exception {
        this.pool.reset();
    }
}

