/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms.lrc;

import bitronix.tm.resource.jms.lrc.LrcXAConnection;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.PropertyUtils;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;

public class LrcXAConnectionFactory
implements XAConnectionFactory {
    private volatile String connectionFactoryClassName;
    private volatile Map<String, Object> properties = new HashMap<String, Object>();

    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public void setConnectionFactoryClassName(String connectionFactoryClassName) {
        this.connectionFactoryClassName = connectionFactoryClassName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public XAConnection createXAConnection() throws JMSException {
        try {
            Class clazz = ClassLoaderUtils.loadClass(this.connectionFactoryClassName);
            ConnectionFactory nonXaConnectionFactory = (ConnectionFactory)clazz.newInstance();
            PropertyUtils.setProperties(nonXaConnectionFactory, this.properties);
            return new LrcXAConnection(nonXaConnectionFactory.createConnection());
        }
        catch (Exception ex) {
            throw (JMSException)new JMSException("unable to connect to non-XA resource " + this.connectionFactoryClassName).initCause((Throwable)ex);
        }
    }

    public XAConnection createXAConnection(String user, String password) throws JMSException {
        try {
            Class clazz = ClassLoaderUtils.loadClass(this.connectionFactoryClassName);
            ConnectionFactory nonXaConnectionFactory = (ConnectionFactory)clazz.newInstance();
            PropertyUtils.setProperties(nonXaConnectionFactory, this.properties);
            return new LrcXAConnection(nonXaConnectionFactory.createConnection(user, password));
        }
        catch (Exception ex) {
            throw (JMSException)new JMSException("unable to connect to non-XA resource " + this.connectionFactoryClassName).initCause((Throwable)ex);
        }
    }

    public String toString() {
        return "a JMS LrcXAConnectionFactory on " + this.connectionFactoryClassName + " with properties " + this.properties;
    }
}

