/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderUtils.class);

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        for (Class<?> intf : Arrays.asList(clazz.getInterfaces())) {
            if (intf.getInterfaces().length > 0) {
                interfaces.addAll(ClassLoaderUtils.getAllInterfaces(intf));
            }
            interfaces.add(intf);
        }
        if (clazz.getSuperclass() != null) {
            interfaces.addAll(ClassLoaderUtils.getAllInterfaces(clazz.getSuperclass()));
        }
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        return interfaces;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return new CascadingClassLoader(cl);
        }
        return ClassLoaderUtils.class.getClassLoader();
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        block3: {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                try {
                    return new CascadingClassLoader(cl).loadClass(className);
                }
                catch (ClassNotFoundException ex) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("context classloader could not find class '" + className + "', trying Class.forName() instead");
                }
            }
        }
        return Class.forName(className);
    }

    public static InputStream getResourceAsStream(String resourceName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl.getResourceAsStream(resourceName);
        }
        return ClassLoaderUtils.class.getClassLoader().getResourceAsStream(resourceName);
    }

    private static class CascadingClassLoader
    extends ClassLoader {
        private final ClassLoader contextLoader;

        CascadingClassLoader(ClassLoader contextLoader) {
            this.contextLoader = contextLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return this.contextLoader.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                return CascadingClassLoader.class.getClassLoader().loadClass(name);
            }
        }
    }
}

