/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.adapter.jdbc.JdbcRel;
import org.apache.calcite.adapter.jdbc.JdbcToEnumerableConverterRule;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

public class JdbcRules {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    static final RelFactories.ProjectFactory PROJECT_FACTORY = (input, hints, projects, fieldNames, variablesSet) -> {
        Preconditions.checkArgument((boolean)variablesSet.isEmpty(), (Object)"JdbcProject does not allow variables");
        RelOptCluster cluster = input.getCluster();
        RelDataType rowType = RexUtil.createStructType(cluster.getTypeFactory(), projects, fieldNames, SqlValidatorUtil.F_SUGGESTER);
        return new JdbcProject(cluster, input.getTraitSet(), input, projects, rowType);
    };
    static final RelFactories.FilterFactory FILTER_FACTORY = (input, condition, variablesSet) -> {
        Preconditions.checkArgument((boolean)variablesSet.isEmpty(), (Object)"JdbcFilter does not allow variables");
        return new JdbcFilter(input.getCluster(), input.getTraitSet(), input, condition);
    };
    static final RelFactories.JoinFactory JOIN_FACTORY = (left, right, hints, condition, variablesSet, joinType, semiJoinDone) -> {
        RelOptCluster cluster = left.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Objects.requireNonNull(left.getConvention(), "left.getConvention()"));
        try {
            return new JdbcJoin(cluster, traitSet, left, right, condition, variablesSet, joinType);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    };
    static final RelFactories.CorrelateFactory CORRELATE_FACTORY = (left, right, hints, correlationId, requiredColumns, joinType) -> {
        throw new UnsupportedOperationException("JdbcCorrelate");
    };
    public static final RelFactories.SortFactory SORT_FACTORY = (input, collation, offset, fetch) -> {
        throw new UnsupportedOperationException("JdbcSort");
    };
    public static final RelFactories.ExchangeFactory EXCHANGE_FACTORY = (input, distribution) -> {
        throw new UnsupportedOperationException("JdbcExchange");
    };
    public static final RelFactories.SortExchangeFactory SORT_EXCHANGE_FACTORY = (input, distribution, collation) -> {
        throw new UnsupportedOperationException("JdbcSortExchange");
    };
    public static final RelFactories.AggregateFactory AGGREGATE_FACTORY = (input, hints, groupSet, groupSets, aggCalls) -> {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Objects.requireNonNull(input.getConvention(), "input.getConvention()"));
        try {
            return new JdbcAggregate(cluster, traitSet, input, groupSet, (List<ImmutableBitSet>)groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    };
    public static final RelFactories.MatchFactory MATCH_FACTORY = (input, pattern, rowType, strictStart, strictEnd, patternDefinitions, measures, after, subsets, allRows, partitionKeys, orderKeys, interval) -> {
        throw new UnsupportedOperationException("JdbcMatch");
    };
    public static final RelFactories.SetOpFactory SET_OP_FACTORY = (kind, inputs, all) -> {
        RelNode input = (RelNode)inputs.get(0);
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Objects.requireNonNull(input.getConvention(), "input.getConvention()"));
        switch (kind) {
            case UNION: {
                return new JdbcUnion(cluster, traitSet, inputs, all);
            }
            case INTERSECT: {
                return new JdbcIntersect(cluster, traitSet, inputs, all);
            }
            case EXCEPT: {
                return new JdbcMinus(cluster, traitSet, inputs, all);
            }
        }
        throw new AssertionError((Object)("unknown: " + (Object)((Object)kind)));
    };
    public static final RelFactories.ValuesFactory VALUES_FACTORY = (cluster, rowType, tuples) -> {
        throw new UnsupportedOperationException();
    };
    public static final RelFactories.TableScanFactory TABLE_SCAN_FACTORY = (toRelContext, table) -> {
        throw new UnsupportedOperationException();
    };
    public static final RelFactories.SnapshotFactory SNAPSHOT_FACTORY = (input, period) -> {
        throw new UnsupportedOperationException();
    };
    public static final RelBuilderFactory JDBC_BUILDER = RelBuilder.proto(Contexts.of(PROJECT_FACTORY, FILTER_FACTORY, JOIN_FACTORY, SORT_FACTORY, EXCHANGE_FACTORY, SORT_EXCHANGE_FACTORY, AGGREGATE_FACTORY, MATCH_FACTORY, SET_OP_FACTORY, VALUES_FACTORY, TABLE_SCAN_FACTORY, SNAPSHOT_FACTORY));

    private JdbcRules() {
    }

    public static List<RelOptRule> rules(JdbcConvention out) {
        ImmutableList.Builder b = ImmutableList.builder();
        JdbcRules.foreachRule(out, arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
        return b.build();
    }

    public static List<RelOptRule> rules(JdbcConvention out, RelBuilderFactory relBuilderFactory) {
        ImmutableList.Builder b = ImmutableList.builder();
        JdbcRules.foreachRule(out, r -> b.add((Object)r.config.withRelBuilderFactory(relBuilderFactory).toRule()));
        return b.build();
    }

    private static void foreachRule(JdbcConvention out, Consumer<RelRule<?>> consumer) {
        consumer.accept(JdbcToEnumerableConverterRule.create(out));
        consumer.accept(JdbcJoinRule.create(out));
        consumer.accept(JdbcProjectRule.create(out));
        consumer.accept(JdbcFilterRule.create(out));
        consumer.accept(JdbcAggregateRule.create(out));
        consumer.accept(JdbcSortRule.create(out));
        consumer.accept(JdbcUnionRule.create(out));
        consumer.accept(JdbcIntersectRule.create(out));
        consumer.accept(JdbcMinusRule.create(out));
        consumer.accept(JdbcTableModificationRule.create(out));
        consumer.accept(JdbcValuesRule.create(out));
    }

    private static boolean canImplement(AggregateCall aggregateCall, SqlDialect sqlDialect) {
        return sqlDialect.supportsAggregateFunction(aggregateCall.getAggregation().getKind()) && aggregateCall.distinctKeys == null;
    }

    private static class CheckingUserDefinedFunctionVisitor
    extends RexVisitorImpl<Void> {
        private boolean containsUsedDefinedFunction = false;

        CheckingUserDefinedFunctionVisitor() {
            super(true);
        }

        public boolean containsUserDefinedFunction() {
            return this.containsUsedDefinedFunction;
        }

        @Override
        public Void visitCall(RexCall call) {
            SqlOperator operator = call.getOperator();
            if (operator instanceof SqlFunction && ((SqlFunction)operator).getFunctionType().isUserDefined()) {
                this.containsUsedDefinedFunction |= true;
            }
            return (Void)super.visitCall(call);
        }
    }

    public static class JdbcValues
    extends Values
    implements JdbcRel {
        JdbcValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new JdbcValues(this.getCluster(), this.getRowType(), (ImmutableList<ImmutableList<RexLiteral>>)this.tuples, traitSet);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcValuesRule
    extends JdbcConverterRule {
        public static JdbcValuesRule create(JdbcConvention out) {
            return ConverterRule.Config.INSTANCE.withConversion(Values.class, Convention.NONE, out, "JdbcValuesRule").withRuleFactory(JdbcValuesRule::new).toRule(JdbcValuesRule.class);
        }

        protected JdbcValuesRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            Values values = (Values)rel;
            return new JdbcValues(values.getCluster(), values.getRowType(), values.getTuples(), values.getTraitSet().replace(this.out));
        }
    }

    public static class JdbcTableModify
    extends TableModify
    implements JdbcRel {
        public JdbcTableModify(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode input, TableModify.Operation operation, @Nullable List<String> updateColumnList, @Nullable List<RexNode> sourceExpressionList, boolean flattened) {
            super(cluster, traitSet, table, catalogReader, input, operation, updateColumnList, sourceExpressionList, flattened);
            assert (input.getConvention() instanceof JdbcConvention);
            assert (this.getConvention() instanceof JdbcConvention);
            ModifiableTable modifiableTable = table.unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                throw new AssertionError();
            }
            Expression expression = table.getExpression(Queryable.class);
            if (expression == null) {
                throw new AssertionError();
            }
        }

        @Override
        public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            RelOptCost cost = super.computeSelfCost(planner, mq);
            if (cost == null) {
                return null;
            }
            return cost.multiplyBy(0.1);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new JdbcTableModify(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), JdbcTableModify.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened());
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcTableModificationRule
    extends JdbcConverterRule {
        public static JdbcTableModificationRule create(JdbcConvention out) {
            return ConverterRule.Config.INSTANCE.withConversion(TableModify.class, Convention.NONE, out, "JdbcTableModificationRule").withRuleFactory(JdbcTableModificationRule::new).toRule(JdbcTableModificationRule.class);
        }

        protected JdbcTableModificationRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            TableModify modify = (TableModify)rel;
            ModifiableTable modifiableTable = modify.getTable().unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                return null;
            }
            RelTraitSet traitSet = modify.getTraitSet().replace(this.out);
            return new JdbcTableModify(modify.getCluster(), traitSet, modify.getTable(), modify.getCatalogReader(), JdbcTableModificationRule.convert(modify.getInput(), traitSet), modify.getOperation(), modify.getUpdateColumnList(), modify.getSourceExpressionList(), modify.isFlattened());
        }
    }

    public static class JdbcMinus
    extends Minus
    implements JdbcRel {
        public JdbcMinus(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public JdbcMinus copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcMinus(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcMinusRule
    extends JdbcConverterRule {
        public static JdbcMinusRule create(JdbcConvention out) {
            return ConverterRule.Config.INSTANCE.withConversion(Minus.class, Convention.NONE, out, "JdbcMinusRule").withRuleFactory(JdbcMinusRule::new).toRule(JdbcMinusRule.class);
        }

        protected JdbcMinusRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            Minus minus = (Minus)rel;
            if (minus.all) {
                return null;
            }
            RelTraitSet traitSet = rel.getTraitSet().replace(this.out);
            return new JdbcMinus(rel.getCluster(), traitSet, JdbcMinusRule.convertList(minus.getInputs(), this.out), false);
        }
    }

    public static class JdbcIntersect
    extends Intersect
    implements JdbcRel {
        public JdbcIntersect(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public JdbcIntersect copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcIntersect(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcIntersectRule
    extends JdbcConverterRule {
        public static JdbcIntersectRule create(JdbcConvention out) {
            return ConverterRule.Config.INSTANCE.withConversion(Intersect.class, Convention.NONE, out, "JdbcIntersectRule").withRuleFactory(JdbcIntersectRule::new).toRule(JdbcIntersectRule.class);
        }

        protected JdbcIntersectRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            Intersect intersect = (Intersect)rel;
            if (intersect.all) {
                return null;
            }
            RelTraitSet traitSet = intersect.getTraitSet().replace(this.out);
            return new JdbcIntersect(rel.getCluster(), traitSet, JdbcIntersectRule.convertList(intersect.getInputs(), this.out), false);
        }
    }

    public static class JdbcUnion
    extends Union
    implements JdbcRel {
        public JdbcUnion(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public JdbcUnion copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcUnion(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            RelOptCost cost = super.computeSelfCost(planner, mq);
            if (cost == null) {
                return null;
            }
            return cost.multiplyBy(0.1);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcUnionRule
    extends JdbcConverterRule {
        public static JdbcUnionRule create(JdbcConvention out) {
            return ConverterRule.Config.INSTANCE.withConversion(Union.class, Convention.NONE, out, "JdbcUnionRule").withRuleFactory(JdbcUnionRule::new).toRule(JdbcUnionRule.class);
        }

        protected JdbcUnionRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            Union union = (Union)rel;
            RelTraitSet traitSet = union.getTraitSet().replace(this.out);
            return new JdbcUnion(rel.getCluster(), traitSet, JdbcUnionRule.convertList(union.getInputs(), this.out), union.all);
        }
    }

    public static class JdbcSort
    extends Sort
    implements JdbcRel {
        public JdbcSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
            super(cluster, traitSet, input, collation, offset, fetch);
            assert (this.getConvention() instanceof JdbcConvention);
            assert (this.getConvention() == input.getConvention());
        }

        @Override
        public JdbcSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, @Nullable RexNode offset, @Nullable RexNode fetch) {
            return new JdbcSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
        }

        @Override
        public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            RelOptCost cost = super.computeSelfCost(planner, mq);
            if (cost == null) {
                return null;
            }
            return cost.multiplyBy(0.9);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcSortRule
    extends JdbcConverterRule {
        public static JdbcSortRule create(JdbcConvention out) {
            return ConverterRule.Config.INSTANCE.withConversion(Sort.class, Convention.NONE, out, "JdbcSortRule").withRuleFactory(JdbcSortRule::new).toRule(JdbcSortRule.class);
        }

        protected JdbcSortRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            return this.convert((Sort)rel, true);
        }

        public RelNode convert(Sort sort, boolean convertInputTraits) {
            RelNode input;
            RelTraitSet traitSet = sort.getTraitSet().replace(this.out);
            if (convertInputTraits) {
                RelTraitSet inputTraitSet = sort.getInput().getTraitSet().replace(this.out);
                input = JdbcSortRule.convert(sort.getInput(), inputTraitSet);
            } else {
                input = sort.getInput();
            }
            return new JdbcSort(sort.getCluster(), traitSet, input, sort.getCollation(), sort.offset, sort.fetch);
        }
    }

    public static class JdbcAggregate
    extends Aggregate
    implements JdbcRel {
        public JdbcAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
            super(cluster, traitSet, (List<RelHint>)ImmutableList.of(), input, groupSet, groupSets, aggCalls);
            assert (this.getConvention() instanceof JdbcConvention);
            assert (this.groupSets.size() == 1) : "Grouping sets not supported";
            SqlDialect dialect = ((JdbcConvention)this.getConvention()).dialect;
            for (AggregateCall aggCall : aggCalls) {
                if (!JdbcRules.canImplement(aggCall, dialect)) {
                    throw new InvalidRelException("cannot implement aggregate function " + aggCall);
                }
                if (!aggCall.hasFilter() || dialect.supportsAggregateFunctionFilter()) continue;
                throw new InvalidRelException("dialect does not support aggregate functions FILTER clauses");
            }
        }

        @Deprecated
        public JdbcAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
            this(cluster, traitSet, input, groupSet, groupSets, aggCalls);
            JdbcAggregate.checkIndicator(indicator);
        }

        @Override
        public JdbcAggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            try {
                return new JdbcAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcAggregateRule
    extends JdbcConverterRule {
        public static JdbcAggregateRule create(JdbcConvention out) {
            return ConverterRule.Config.INSTANCE.withConversion(Aggregate.class, Convention.NONE, out, "JdbcAggregateRule").withRuleFactory(JdbcAggregateRule::new).toRule(JdbcAggregateRule.class);
        }

        protected JdbcAggregateRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            Aggregate agg = (Aggregate)rel;
            if (agg.getGroupSets().size() != 1) {
                return null;
            }
            RelTraitSet traitSet = agg.getTraitSet().replace(this.out);
            try {
                return new JdbcAggregate(rel.getCluster(), traitSet, JdbcAggregateRule.convert(agg.getInput(), this.out), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                LOGGER.debug(e.toString());
                return null;
            }
        }
    }

    public static class JdbcFilter
    extends Filter
    implements JdbcRel {
        public JdbcFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode condition) {
            super(cluster, traitSet, input, condition);
            assert (this.getConvention() instanceof JdbcConvention);
        }

        @Override
        public JdbcFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
            return new JdbcFilter(this.getCluster(), traitSet, input, condition);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcFilterRule
    extends JdbcConverterRule {
        public static JdbcFilterRule create(JdbcConvention out) {
            return ConverterRule.Config.INSTANCE.withConversion(Filter.class, r -> !JdbcFilterRule.userDefinedFunctionInFilter(r), Convention.NONE, out, "JdbcFilterRule").withRuleFactory(JdbcFilterRule::new).toRule(JdbcFilterRule.class);
        }

        protected JdbcFilterRule(ConverterRule.Config config) {
            super(config);
        }

        private static boolean userDefinedFunctionInFilter(Filter filter) {
            CheckingUserDefinedFunctionVisitor visitor = new CheckingUserDefinedFunctionVisitor();
            filter.getCondition().accept(visitor);
            return visitor.containsUserDefinedFunction();
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            Filter filter = (Filter)rel;
            return new JdbcFilter(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcFilterRule.convert(filter.getInput(), filter.getInput().getTraitSet().replace(this.out)), filter.getCondition());
        }
    }

    public static class JdbcProject
    extends Project
    implements JdbcRel {
        public JdbcProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
            super(cluster, traitSet, (List<RelHint>)ImmutableList.of(), input, projects, rowType, (Set<CorrelationId>)ImmutableSet.of());
            assert (this.getConvention() instanceof JdbcConvention);
        }

        @Deprecated
        public JdbcProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType, int flags) {
            this(cluster, traitSet, input, projects, rowType);
            Util.discard(flags);
        }

        @Override
        public JdbcProject copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
            return new JdbcProject(this.getCluster(), traitSet, input, projects, rowType);
        }

        @Override
        public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            RelOptCost cost = super.computeSelfCost(planner, mq);
            if (cost == null) {
                return null;
            }
            return cost.multiplyBy(0.8);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcProjectRule
    extends JdbcConverterRule {
        public static JdbcProjectRule create(JdbcConvention out) {
            return ConverterRule.Config.INSTANCE.withConversion(Project.class, project -> (out.dialect.supportsWindowFunctions() || !project.containsOver()) && !JdbcProjectRule.userDefinedFunctionInProject(project), Convention.NONE, out, "JdbcProjectRule").withRuleFactory(JdbcProjectRule::new).toRule(JdbcProjectRule.class);
        }

        protected JdbcProjectRule(ConverterRule.Config config) {
            super(config);
        }

        private static boolean userDefinedFunctionInProject(Project project) {
            CheckingUserDefinedFunctionVisitor visitor = new CheckingUserDefinedFunctionVisitor();
            for (RexNode node : project.getProjects()) {
                node.accept(visitor);
                if (!visitor.containsUserDefinedFunction()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            return project.getVariablesSet().isEmpty();
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            Project project = (Project)rel;
            return new JdbcProject(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcProjectRule.convert(project.getInput(), project.getInput().getTraitSet().replace(this.out)), project.getProjects(), project.getRowType());
        }
    }

    @Deprecated
    public static class JdbcCalc
    extends SingleRel
    implements JdbcRel {
        private final RexProgram program;

        public JdbcCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program) {
            super(cluster, traitSet, input);
            assert (this.getConvention() instanceof JdbcConvention);
            this.program = program;
            this.rowType = program.getOutputRowType();
        }

        @Deprecated
        public JdbcCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program, int flags) {
            this(cluster, traitSet, input, program);
            Util.discard(flags);
        }

        @Override
        public RelWriter explainTerms(RelWriter pw) {
            return this.program.explainCalc(super.explainTerms(pw));
        }

        @Override
        public double estimateRowCount(RelMetadataQuery mq) {
            return RelMdUtil.estimateFilteredRows(this.getInput(), this.program, mq);
        }

        @Override
        public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            double dRows = mq.getRowCount(this);
            double dCpu = mq.getRowCount(this.getInput()) * (double)this.program.getExprCount();
            double dIo = 0.0;
            return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new JdbcCalc(this.getCluster(), traitSet, JdbcCalc.sole(inputs), this.program);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcJoin
    extends Join
    implements JdbcRel {
        public JdbcJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) throws InvalidRelException {
            super(cluster, traitSet, (List<RelHint>)ImmutableList.of(), left, right, condition, variablesSet, joinType);
        }

        @Deprecated
        protected JdbcJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
            this(cluster, traitSet, left, right, condition, (Set<CorrelationId>)CorrelationId.setOf(variablesStopped), joinType);
        }

        @Override
        public JdbcJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
            try {
                return new JdbcJoin(this.getCluster(), traitSet, left, right, condition, (Set<CorrelationId>)this.variablesSet, joinType);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            double rowCount = mq.getRowCount(this);
            return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
        }

        @Override
        public double estimateRowCount(RelMetadataQuery mq) {
            double leftRowCount = this.left.estimateRowCount(mq);
            double rightRowCount = this.right.estimateRowCount(mq);
            return Math.max(leftRowCount, rightRowCount);
        }

        @Override
        public SqlImplementor.Result implement(JdbcImplementor implementor) {
            return implementor.implement(this);
        }
    }

    public static class JdbcJoinRule
    extends JdbcConverterRule {
        public static JdbcJoinRule create(JdbcConvention out) {
            return ConverterRule.Config.INSTANCE.withConversion(Join.class, Convention.NONE, out, "JdbcJoinRule").withRuleFactory(JdbcJoinRule::new).toRule(JdbcJoinRule.class);
        }

        protected JdbcJoinRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            Join join = (Join)rel;
            switch (join.getJoinType()) {
                case SEMI: 
                case ANTI: {
                    return null;
                }
            }
            return this.convert(join, true);
        }

        public @Nullable RelNode convert(Join join, boolean convertInputTraits) {
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : join.getInputs()) {
                if (convertInputTraits && input.getConvention() != this.getOutTrait()) {
                    input = JdbcJoinRule.convert(input, input.getTraitSet().replace(this.out));
                }
                newInputs.add(input);
            }
            if (convertInputTraits && !JdbcJoinRule.canJoinOnCondition(join.getCondition())) {
                return null;
            }
            try {
                return new JdbcJoin(join.getCluster(), join.getTraitSet().replace(this.out), (RelNode)newInputs.get(0), (RelNode)newInputs.get(1), join.getCondition(), join.getVariablesSet(), join.getJoinType());
            }
            catch (InvalidRelException e) {
                LOGGER.debug(e.toString());
                return null;
            }
        }

        private static boolean canJoinOnCondition(RexNode node) {
            switch (node.getKind()) {
                case LITERAL: {
                    return true;
                }
                case AND: 
                case OR: {
                    List<RexNode> operands = ((RexCall)node).getOperands();
                    for (RexNode operand : operands) {
                        if (JdbcJoinRule.canJoinOnCondition(operand)) continue;
                        return false;
                    }
                    return true;
                }
                case EQUALS: 
                case IS_NOT_DISTINCT_FROM: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    List<RexNode> operands = ((RexCall)node).getOperands();
                    if (!(operands.get(0) instanceof RexInputRef) || !(operands.get(1) instanceof RexInputRef)) break;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            JoinRelType joinType = join.getJoinType();
            return ((JdbcConvention)this.getOutConvention()).dialect.supportsJoinType(joinType);
        }
    }

    static abstract class JdbcConverterRule
    extends ConverterRule {
        protected JdbcConverterRule(ConverterRule.Config config) {
            super(config);
        }
    }
}

