/*
 * Decompiled with CFR 0.152.
 */
package ome.services.projection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import ome.annotations.RolesAllowed;
import ome.api.IPixels;
import ome.api.IProjection;
import ome.api.ServiceInterface;
import ome.conditions.ResourceError;
import ome.conditions.ValidationException;
import ome.io.nio.DimensionsOutOfBoundsException;
import ome.io.nio.PixelBuffer;
import ome.io.nio.PixelsService;
import ome.logic.AbstractLevel2Service;
import ome.model.IObject;
import ome.model.core.Channel;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.model.enums.PixelsType;
import ome.model.stats.StatsInfo;
import ome.util.PixelData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class ProjectionBean
extends AbstractLevel2Service
implements IProjection {
    private static Logger log = LoggerFactory.getLogger(ProjectionBean.class);
    protected transient IPixels iPixels;
    protected transient PixelsService pixelsService;

    public Class<? extends ServiceInterface> getServiceInterface() {
        return IProjection.class;
    }

    public void setIPixels(IPixels iPixels) {
        this.getBeanHelper().throwIfAlreadySet(this.iPixels, iPixels);
        this.iPixels = iPixels;
    }

    public void setPixelsService(PixelsService pixelsService) {
        this.getBeanHelper().throwIfAlreadySet(this.pixelsService, pixelsService);
        this.pixelsService = pixelsService;
    }

    @RolesAllowed(value={"user"})
    public byte[] projectStack(long pixelsId, PixelsType pixelsType, int algorithm, int timepoint, int channelIndex, int stepping, int start, int end) {
        ProjectionContext ctx = new ProjectionContext();
        ctx.pixels = (Pixels)this.iQuery.get(Pixels.class, pixelsId);
        PixelBuffer pixelBuffer = this.pixelsService.getPixelBuffer(ctx.pixels, false);
        this.zIntervalBoundsCheck(start, end, ctx.pixels.getSizeZ());
        this.outOfBoundsStepping(stepping);
        this.outOfBoundsCheck(channelIndex, "channel");
        this.outOfBoundsCheck(timepoint, "timepoint");
        Integer v = ctx.pixels.getSizeT();
        if (timepoint >= v) {
            throw new ValidationException("timepoint must be <" + v);
        }
        v = ctx.pixels.getSizeC();
        if (channelIndex >= v) {
            throw new ValidationException("channel index must be <" + v);
        }
        try {
            pixelsType = pixelsType == null ? ctx.pixels.getPixelsType() : (PixelsType)this.iQuery.get(PixelsType.class, pixelsType.getId());
            ctx.planeSizeInPixels = ctx.pixels.getSizeX() * ctx.pixels.getSizeY();
            int planeSize = ctx.planeSizeInPixels * (this.iPixels.getBitDepth(pixelsType) / 8);
            byte[] buf = new byte[planeSize];
            ctx.from = pixelBuffer.getStack(Integer.valueOf(channelIndex), Integer.valueOf(timepoint));
            ctx.to = new PixelData(pixelsType.getValue(), ByteBuffer.wrap(buf));
            switch (algorithm) {
                case 0: {
                    this.projectStackMax(ctx, stepping, start, end, false);
                    break;
                }
                case 1: {
                    this.projectStackMean(ctx, stepping, start, end, false);
                    break;
                }
                case 2: {
                    this.projectStackSum(ctx, stepping, start, end, false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm: " + algorithm);
                }
            }
            byte[] byArray = buf;
            return byArray;
        }
        catch (IOException e) {
            String error = String.format("I/O error retrieving stack C=%d T=%d: %s", channelIndex, timepoint, e.getMessage());
            log.error(error, (Throwable)e);
            throw new ResourceError(error);
        }
        catch (DimensionsOutOfBoundsException e) {
            String error = String.format("C=%d or T=%d out of range for Pixels Id %d: %s", channelIndex, timepoint, ctx.pixels.getId(), e.getMessage());
            log.error(error, (Throwable)e);
            throw new ValidationException(error);
        }
        finally {
            try {
                pixelBuffer.close();
            }
            catch (IOException e) {
                log.error("Buffer did not close successfully.", (Throwable)e);
                throw new ResourceError(e.getMessage() + " Please check server log.");
            }
            if (ctx.from != null) {
                ctx.from.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public long projectPixels(long pixelsId, PixelsType pixelsType, int algorithm, int tStart, int tEnd, List<Integer> channels, int stepping, int zStart, int zEnd, String name) {
        ProjectionContext ctx = new ProjectionContext();
        ctx.pixels = (Pixels)this.iQuery.get(Pixels.class, pixelsId);
        Image image = ctx.pixels.getImage();
        name = name == null ? image.getName() + " Projection" : name;
        this.zIntervalBoundsCheck(zStart, zEnd, ctx.pixels.getSizeZ());
        this.outOfBoundsStepping(stepping);
        Integer sizeT = tEnd - tStart + 1;
        if (tStart > tEnd) {
            sizeT = tStart - tEnd + 1;
        }
        if (sizeT <= 0) {
            sizeT = null;
        }
        long newImageId = this.iPixels.copyAndResizeImage(image.getId().longValue(), null, null, Integer.valueOf(1), sizeT, channels, name, false);
        Image newImage = (Image)this.iQuery.get(Image.class, newImageId);
        Pixels newPixels = newImage.getPixels(0);
        pixelsType = pixelsType == null ? ctx.pixels.getPixelsType() : (PixelsType)this.iQuery.get(PixelsType.class, pixelsType.getId());
        newPixels.setPixelsType(pixelsType);
        PixelBuffer sourceBuffer = this.pixelsService.getPixelBuffer(ctx.pixels, false);
        try {
            PixelBuffer destinationBuffer = this.pixelsService.getPixelBuffer(newPixels, true);
            try {
                ctx.planeSizeInPixels = ctx.pixels.getSizeX() * ctx.pixels.getSizeY();
                int planeSize = ctx.planeSizeInPixels * (this.iPixels.getBitDepth(pixelsType) / 8);
                byte[] buf = new byte[planeSize];
                ctx.to = new PixelData(pixelsType.getValue(), ByteBuffer.wrap(buf));
                int newC = 0;
                for (Integer c : channels) {
                    ctx.minimum = Double.MAX_VALUE;
                    ctx.maximum = Double.MIN_VALUE;
                    for (int t = tStart; t <= tEnd; ++t) {
                        try {
                            ctx.from = sourceBuffer.getStack(c, Integer.valueOf(t));
                            switch (algorithm) {
                                case 0: {
                                    this.projectStackMax(ctx, stepping, zStart, zEnd, true);
                                    break;
                                }
                                case 1: {
                                    this.projectStackMean(ctx, stepping, zStart, zEnd, true);
                                    break;
                                }
                                case 2: {
                                    this.projectStackSum(ctx, stepping, zStart, zEnd, true);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unknown algorithm: " + algorithm);
                                }
                            }
                            destinationBuffer.setPlane(buf, Integer.valueOf(0), Integer.valueOf(newC), Integer.valueOf(t - tStart));
                            continue;
                        }
                        catch (IOException e) {
                            String error = String.format("I/O error retrieving stack C=%d T=%d: %s", c, t, e.getMessage());
                            log.error(error, (Throwable)e);
                            throw new ResourceError(error);
                        }
                        catch (DimensionsOutOfBoundsException e) {
                            String error = String.format("C=%d or T=%d out of range for Pixels Id %d: %s", c, t, ctx.pixels.getId(), e.getMessage());
                            log.error(error, (Throwable)e);
                            throw new ValidationException(error);
                        }
                        finally {
                            if (ctx.from != null) {
                                ctx.from.dispose();
                            }
                        }
                    }
                    Channel channel = newPixels.getChannel(newC);
                    StatsInfo si = new StatsInfo();
                    si.setGlobalMin(Double.valueOf(ctx.minimum));
                    si.setGlobalMax(Double.valueOf(ctx.maximum));
                    channel.setStatsInfo(si);
                    newPixels.setMethodology(IProjection.METHODOLOGY_STRINGS[algorithm]);
                    ++newC;
                }
            }
            finally {
                try {
                    destinationBuffer.close();
                }
                catch (IOException e) {
                    log.error("Buffer did not close successfully: " + destinationBuffer, (Throwable)e);
                    throw new ResourceError(e.getMessage() + " Please check server log.");
                }
            }
        }
        finally {
            try {
                sourceBuffer.close();
            }
            catch (IOException e) {
                log.error("Buffer did not close successfully: " + sourceBuffer, (Throwable)e);
                throw new ResourceError(e.getMessage() + " Please check server log.");
            }
        }
        newImage = (Image)this.iUpdate.saveAndReturnObject((IObject)newImage);
        return newImage.getId();
    }

    private void outOfBoundsCheck(Integer value, String name) {
        if (value != null && value < 0) {
            throw new ValidationException(name + ": " + value + " < 0");
        }
    }

    private void outOfBoundsStepping(Integer value) {
        if (value != null && value <= 0) {
            throw new ValidationException("stepping: " + value + " <= 0");
        }
    }

    private void zIntervalBoundsCheck(int start, int end, Integer maxZ) {
        if (start < 0 || end < 0) {
            throw new ValidationException("Z interval value cannot be negative.");
        }
        if (start >= maxZ || end >= maxZ) {
            throw new ValidationException("Z interval value cannot be >= " + maxZ);
        }
    }

    private void projectStackMax(ProjectionContext ctx, int stepping, int start, int end, boolean doMinMax) {
        double minimum = ctx.minimum;
        double maximum = ctx.maximum;
        for (int i = 0; i < ctx.planeSizeInPixels; ++i) {
            double projectedValue = 0.0;
            for (int z = start; z <= end; z += stepping) {
                int currentPlaneStart = ctx.planeSizeInPixels * z;
                double stackValue = ctx.from.getPixelValue(currentPlaneStart + i);
                if (!(stackValue > projectedValue)) continue;
                projectedValue = stackValue;
            }
            ctx.to.setPixelValue(i, projectedValue);
            if (!doMinMax) continue;
            minimum = projectedValue < minimum ? projectedValue : minimum;
            maximum = projectedValue > maximum ? projectedValue : maximum;
        }
        ctx.minimum = minimum;
        ctx.maximum = maximum;
    }

    private void projectStackMean(ProjectionContext ctx, int stepping, int start, int end, boolean doMinMax) {
        this.projectStackMeanOrSum(ctx, stepping, start, end, true, doMinMax);
    }

    private void projectStackSum(ProjectionContext ctx, int stepping, int start, int end, boolean doMinMax) {
        this.projectStackMeanOrSum(ctx, stepping, start, end, false, doMinMax);
    }

    private void projectStackMeanOrSum(ProjectionContext ctx, int stepping, int start, int end, boolean mean, boolean doMinMax) {
        double planeMaximum = ctx.to.getMaximum();
        double minimum = ctx.minimum;
        double maximum = ctx.maximum;
        for (int i = 0; i < ctx.planeSizeInPixels; ++i) {
            double projectedValue = 0.0;
            int projectedPlaneCount = 0;
            for (int z = start; z < end; z += stepping) {
                int currentPlaneStart = ctx.planeSizeInPixels * z;
                double stackValue = ctx.from.getPixelValue(currentPlaneStart + i);
                projectedValue += stackValue;
                ++projectedPlaneCount;
            }
            if (mean) {
                projectedValue /= (double)projectedPlaneCount;
            }
            if (projectedValue > planeMaximum) {
                projectedValue = planeMaximum;
            }
            ctx.to.setPixelValue(i, projectedValue);
            if (!doMinMax) continue;
            minimum = projectedValue < minimum ? projectedValue : minimum;
            maximum = projectedValue > maximum ? projectedValue : maximum;
        }
        ctx.minimum = minimum;
        ctx.maximum = maximum;
    }

    private static class ProjectionContext {
        public Pixels pixels;
        public int planeSizeInPixels;
        public double minimum = Double.MAX_VALUE;
        public double maximum = Double.MIN_VALUE;
        public PixelData from;
        public PixelData to;

        private ProjectionContext() {
        }
    }
}

