/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.awt.image.BufferedImage;
import omero.ServerError;
import omero.api.RenderingEnginePrx;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.Facility;
import omero.gateway.facility.LoadFacility;
import omero.gateway.model.ImageData;
import omero.romio.PlaneDef;

public class RenderFacility
extends Facility {
    RenderFacility(Gateway gateway) {
        super(gateway);
    }

    public RenderingEnginePrx getRenderingEngine(SecurityContext ctx, long imageId, boolean initDefaultSettings) throws DSOutOfServiceException, DSAccessException, ServerError {
        return this.getRenderingEngine(ctx, imageId, initDefaultSettings, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderingEnginePrx getRenderingEngine(SecurityContext ctx, long imageId, boolean initDefaultSettings, boolean closeRE) throws DSOutOfServiceException, DSAccessException {
        RenderingEnginePrx re = null;
        try {
            long pixelsId = this.gateway.getFacility(LoadFacility.class).getImage(ctx, imageId).getDefaultPixels().getId();
            re = this.gateway.getRenderingService(ctx, pixelsId);
            if (!re.lookupRenderingDef(pixelsId)) {
                if (initDefaultSettings) {
                    re.resetDefaultSettings(true);
                    re.lookupRenderingDef(pixelsId);
                } else {
                    throw new DSOutOfServiceException("Image doesn't have rendering settings.");
                }
            }
            re.load();
            RenderingEnginePrx renderingEnginePrx = re;
            return renderingEnginePrx;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not load RenderingEngine.");
        }
        finally {
            if (closeRE && re != null) {
                try {
                    re.close();
                }
                catch (ServerError serverError) {}
            }
        }
        return null;
    }

    public boolean isRGB(SecurityContext ctx, long imageId) throws DSOutOfServiceException, DSAccessException {
        try {
            ImageData img = this.gateway.getFacility(LoadFacility.class).getImage(ctx, imageId);
            int nChannels = img.getDefaultPixels().getSizeC();
            if (nChannels < 3 || nChannels > 4) {
                return false;
            }
            boolean r = false;
            boolean g = false;
            boolean b = false;
            RenderingEnginePrx re = this.getRenderingEngine(ctx, imageId, true);
            for (int i = 0; i < nChannels; ++i) {
                int[] ch = re.getRGBA(i);
                if (!r && ch[0] == 255 && ch[1] == 0 && ch[2] == 0) {
                    r = true;
                }
                if (!g && ch[1] == 255 && ch[0] == 0 && ch[2] == 0) {
                    g = true;
                }
                if (b || ch[2] != 255 || ch[0] != 0 || ch[1] != 0) continue;
                b = true;
            }
            return r && g && b;
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not check image.");
            return false;
        }
    }

    public int[] renderPlane(SecurityContext ctx, long imageId, int z, int t) throws DSOutOfServiceException, DSAccessException {
        return this.renderPlane(ctx, imageId, z, t, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] renderPlane(SecurityContext ctx, long imageId, int z, int t, boolean closeRE) throws DSOutOfServiceException, DSAccessException {
        RenderingEnginePrx re = null;
        try {
            re = this.getRenderingEngine(ctx, imageId, true, closeRE);
            PlaneDef plane = new PlaneDef(0, 0, 0, z, t, null, -1);
            int[] nArray = re.renderAsPackedInt(plane);
            return nArray;
        }
        catch (Throwable e) {
            this.handleException(this, e, "Could not render plane.");
        }
        finally {
            if (closeRE && re != null) {
                try {
                    re.close();
                }
                catch (ServerError serverError) {}
            }
        }
        return null;
    }

    public BufferedImage renderPlaneAsBufferedImage(SecurityContext ctx, long imageId, int z, int t) throws DSOutOfServiceException, DSAccessException {
        return this.renderPlaneAsBufferedImage(ctx, imageId, z, t, true);
    }

    public BufferedImage renderPlaneAsBufferedImage(SecurityContext ctx, long imageId, int z, int t, boolean closeRE) throws DSOutOfServiceException, DSAccessException {
        try {
            ImageData img = this.gateway.getFacility(LoadFacility.class).getImage(ctx, imageId);
            int[] pixels = this.renderPlane(ctx, imageId, 0, 0, closeRE);
            int w = img.getDefaultPixels().getSizeX();
            int h = img.getDefaultPixels().getSizeY();
            BufferedImage image = new BufferedImage(w, h, 2);
            image.setRGB(0, 0, w, h, pixels, 0, w);
            return image;
        }
        catch (Throwable e) {
            this.handleException(this, e, "Could not render plane.");
            return null;
        }
    }
}

