/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.RString;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.RatingAnnotationData;
import omero.gateway.model.SetMutator;
import omero.gateway.model.TextualAnnotationData;
import omero.model.Annotation;
import omero.model.CommentAnnotation;
import omero.model.Dataset;
import omero.model.DatasetAnnotationLink;
import omero.model.DatasetI;
import omero.model.DatasetImageLink;
import omero.model.IObject;
import omero.model.LongAnnotation;
import omero.model.ProjectDatasetLink;
import omero.rtypes;

public class DatasetData
extends DataObject {
    public static final String NAME = "ome.model.containers.Dataset_name";
    public static final String DESCRIPTION = "ome.model.containers.Dataset_description";
    public static final String IMAGE_LINKS = "ome.model.containers.Dataset_imageLinks";
    public static final String PROJECT_LINKS = "ome.model.containers.Dataset_projectLinks";
    public static final String ANNOTATIONS = "ome.model.containers.Dataset_annotationLinks";
    private Set<ImageData> images;
    private Set<ProjectData> projects;
    private Set<AnnotationData> annotations;
    private Long annotationCount;

    public DatasetData() {
        this.setDirty(true);
        this.setValue((IObject)new DatasetI());
    }

    public DatasetData(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue((IObject)dataset);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asDataset().setName(rtypes.rstring((String)name));
    }

    public String getName() {
        RString n = this.asDataset().getName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been null.");
        }
        return n.getValue();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asDataset().setDescription(rtypes.rstring((String)description));
    }

    public String getDescription() {
        RString d = this.asDataset().getDescription();
        return d == null ? null : d.getValue();
    }

    public Map<Long, Long> getAnnotationsCounts() {
        return this.asDataset().getAnnotationLinksCountPerOwner();
    }

    public Set<ImageData> getImages() {
        if (this.images == null && this.asDataset().sizeOfImageLinks() >= 0) {
            List imageLinks = this.asDataset().copyImageLinks();
            this.images = new HashSet<ImageData>();
            for (DatasetImageLink link : imageLinks) {
                this.images.add(new ImageData(link.getChild()));
            }
        }
        return this.images == null ? null : new HashSet<ImageData>(this.images);
    }

    public Set<ProjectData> getProjects() {
        if (this.projects == null && this.asDataset().sizeOfProjectLinks() >= 0) {
            this.projects = new HashSet<ProjectData>();
            List projectLinks = this.asDataset().copyProjectLinks();
            for (ProjectDatasetLink link : projectLinks) {
                this.projects.add(new ProjectData(link.getParent()));
            }
        }
        return this.projects == null ? null : new HashSet<ProjectData>(this.projects);
    }

    public void setImages(Set<ImageData> newValue) {
        Set<ImageData> currentValue = this.getImages();
        SetMutator<ImageData> m = new SetMutator<ImageData>(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asDataset().unlinkImage(m.nextDeletion().asImage());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asDataset().linkImage(m.nextAddition().asImage());
        }
        this.images = new HashSet<ImageData>(m.result());
    }

    public void setProjects(Set<ProjectData> newValue) {
        Set<ProjectData> currentValue = this.getProjects();
        SetMutator<ProjectData> m = new SetMutator<ProjectData>(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asDataset().unlinkProject(m.nextDeletion().asProject());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asDataset().linkProject(m.nextAddition().asProject());
        }
        this.projects = new HashSet<ProjectData>(m.result());
    }

    public Set<AnnotationData> getAnnotations() {
        int size;
        if (this.annotations == null && (size = this.asDataset().sizeOfAnnotationLinks()) >= 0) {
            this.annotations = new HashSet<AnnotationData>(size);
            List links = this.asDataset().copyAnnotationLinks();
            for (DatasetAnnotationLink link : links) {
                Annotation a = link.getChild();
                if (a instanceof CommentAnnotation) {
                    this.annotations.add(new TextualAnnotationData((CommentAnnotation)a));
                    continue;
                }
                if (!(a instanceof LongAnnotation)) continue;
                this.annotations.add(new RatingAnnotationData((LongAnnotation)a));
            }
        }
        return this.annotations == null ? null : new HashSet<AnnotationData>(this.annotations);
    }

    public void setAnnotations(Set newValue) {
        Set<AnnotationData> currentValue = this.getAnnotations();
        SetMutator<AnnotationData> m = new SetMutator<AnnotationData>(currentValue, newValue);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asDataset().unlinkAnnotation(m.nextDeletion().asAnnotation());
            this.annotationCount = this.annotationCount == null ? null : new Long(this.annotationCount - 1L);
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asDataset().linkAnnotation(m.nextAddition().asAnnotation());
            this.annotationCount = this.annotationCount == null ? null : new Long(this.annotationCount + 1L);
        }
        this.annotations = new HashSet<AnnotationData>(m.result());
    }
}

