/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import ome.model.units.BigResult;
import omero.RBool;
import omero.RDouble;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.model.Correction;
import omero.model.IObject;
import omero.model.Immersion;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.Objective;
import omero.model.enums.UnitsLength;

public class ObjectiveData
extends DataObject {
    public ObjectiveData(Objective objective) {
        if (objective == null) {
            throw new IllegalArgumentException("No objective.");
        }
        this.setValue((IObject)objective);
    }

    public Length getWorkingDistance(UnitsLength unit) throws BigResult {
        Objective obj = (Objective)this.asIObject();
        Length l = obj.getWorkingDistance();
        if (l == null) {
            return null;
        }
        return unit == null ? l : new LengthI(l, unit);
    }

    public String getSerialNumber() {
        Objective obj = (Objective)this.asIObject();
        RString value = obj.getSerialNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getModel() {
        Objective obj = (Objective)this.asIObject();
        RString value = obj.getModel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public Object hasIris() {
        Objective obj = (Objective)this.asIObject();
        RBool value = obj.getIris();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public String getCorrection() {
        Objective obj = (Objective)this.asIObject();
        Correction value = obj.getCorrection();
        if (value == null) {
            return "";
        }
        return value.getValue().getValue();
    }

    public double getCalibratedMagnification() {
        Objective obj = (Objective)this.asIObject();
        RDouble value = obj.getCalibratedMagnification();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getNominalMagnification() {
        Objective obj = (Objective)this.asIObject();
        RDouble value = obj.getNominalMagnification();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getLensNA() {
        Objective obj = (Objective)this.asIObject();
        RDouble value = obj.getLensNA();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public String getImmersion() {
        Objective obj = (Objective)this.asIObject();
        Immersion value = obj.getImmersion();
        if (value == null) {
            return "";
        }
        return value.getValue().getValue();
    }

    public String getManufacturer() {
        Objective obj = (Objective)this.asIObject();
        RString value = obj.getManufacturer();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getLotNumber() {
        Objective obj = (Objective)this.asIObject();
        RString value = obj.getLotNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }
}

