/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import ome.model.units.BigResult;
import omero.RTime;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.model.IObject;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.WellSample;
import omero.model.WellSampleI;
import omero.model.enums.UnitsLength;

public class WellSampleData
extends DataObject {
    private ImageData image;

    public WellSampleData() {
        this.setDirty(true);
        this.setValue((IObject)new WellSampleI());
    }

    public WellSampleData(WellSample wellSample) {
        if (wellSample == null) {
            throw new IllegalArgumentException("Object cannot be null.");
        }
        this.setValue((IObject)wellSample);
    }

    public ImageData getImage() {
        if (this.image == null) {
            this.image = new ImageData(this.asWellSample().getImage());
        }
        return this.image;
    }

    public void setImage(ImageData newValue) {
        if (newValue == null) {
            return;
        }
        this.setDirty(true);
        this.asWellSample().setImage(newValue.asImage());
    }

    public Length getPositionX(UnitsLength unit) throws BigResult {
        Length value = this.asWellSample().getPosX();
        if (value == null) {
            return new LengthI(0.0, UnitsLength.REFERENCEFRAME);
        }
        return unit == null ? value : new LengthI(value, unit);
    }

    public Length getPositionY(UnitsLength unit) throws BigResult {
        Length value = this.asWellSample().getPosY();
        if (value == null) {
            return new LengthI(0.0, UnitsLength.REFERENCEFRAME);
        }
        return unit == null ? value : new LengthI(value, unit);
    }

    public long getStartTime() {
        RTime value = this.asWellSample().getTimepoint();
        if (value == null) {
            return 0L;
        }
        return value.getValue();
    }
}

