/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.redirect;

import Glacier2.CannotCreateSessionException;
import Glacier2.SessionControlPrx;
import Glacier2.SessionPrx;
import Ice.Current;
import java.util.Set;
import ome.api.local.LocalConfig;
import ome.services.blitz.redirect.AbstractRedirector;
import ome.services.blitz.redirect.Redirector;
import ome.services.util.Executor;
import ome.system.ServiceFactory;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

public class ConfigRedirector
extends AbstractRedirector {
    public ConfigRedirector(Executor ex) {
        super(ex);
    }

    @Override
    public SessionPrx getProxyOrNull(Redirector.Context ctx, String userId, SessionControlPrx control, Current current) throws CannotCreateSessionException {
        SessionPrx prx = super.getProxyOrNull(ctx, userId, control, current);
        if (prx != null) {
            return prx;
        }
        String proxyString = null;
        String redirect = this.getRedirect(ctx);
        if (redirect != null) {
            this.log.info("Found redirect: " + redirect);
            if (redirect.equals(ctx.uuid())) {
                this.log.info("Redirect points to this instance; setting null");
                proxyString = null;
            } else {
                proxyString = this.findProxy(ctx, redirect);
                if (proxyString == null || proxyString.length() == 0) {
                    this.log.warn("No proxy found for manager: " + redirect);
                } else {
                    this.log.info("Resolved redirect to: " + proxyString);
                }
            }
        }
        return this.obtainProxy(proxyString, ctx, userId, control, current);
    }

    @Override
    public void chooseNextRedirect(Redirector.Context ctx, Set<String> nodeUuids) {
        String redirect = this.getRedirect(ctx);
        if (!nodeUuids.contains(redirect)) {
            this.initializeRedirect(ctx, null);
        }
        this.initializeRedirect(ctx, ctx.uuid());
        this.log.info("Current redirect: " + this.getRedirect(ctx));
    }

    @Override
    public void handleRingShutdown(Redirector.Context ctx, final String downUuid) {
        this.executor.execute(ctx.principal(), (Executor.Work)new Executor.SimpleWork(this, "removeRedirectIfEquals", new Object[0]){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                LocalConfig config = (LocalConfig)sf.getConfigService();
                return config.setConfigValueIfEquals("omero.cluster.redirect", null, downUuid);
            }
        });
        if (!ctx.uuid().equals(downUuid) && this.initializeRedirect(ctx, ctx.uuid())) {
            this.log.info("Installed self as new redirect: " + ctx.uuid());
        }
    }
}

