/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import ome.util.checksum.ChecksumType;
import omero.model.ChecksumAlgorithm;
import omero.model.ChecksumAlgorithmI;
import omero.rtypes;

public class ChecksumAlgorithmMapper {
    public static Function<ChecksumAlgorithm, String> CHECKSUM_ALGORITHM_NAMER = new Function<ChecksumAlgorithm, String>(){

        @Override
        public String apply(ChecksumAlgorithm checksumAlgorithm) {
            return checksumAlgorithm.getValue().getValue();
        }
    };
    private static final ImmutableMap<String, ChecksumType> checksumAlgorithms = ImmutableMap.builder().put((Object)"Adler-32", (Object)ChecksumType.ADLER32).put((Object)"CRC-32", (Object)ChecksumType.CRC32).put((Object)"MD5-128", (Object)ChecksumType.MD5).put((Object)"Murmur3-32", (Object)ChecksumType.MURMUR32).put((Object)"Murmur3-128", (Object)ChecksumType.MURMUR128).put((Object)"SHA1-160", (Object)ChecksumType.SHA1).put((Object)"File-Size-64", (Object)ChecksumType.FILE_SIZE).build();

    private static ChecksumAlgorithm getChecksumAlgorithmWithValue(String name) {
        ChecksumAlgorithmI algorithm = new ChecksumAlgorithmI();
        algorithm.setValue(rtypes.rstring(name));
        return algorithm;
    }

    public static ChecksumType getChecksumType(ome.model.enums.ChecksumAlgorithm algorithm) {
        return (ChecksumType)checksumAlgorithms.get((Object)algorithm.getValue());
    }

    public static ChecksumType getChecksumType(ChecksumAlgorithm algorithm) {
        return (ChecksumType)checksumAlgorithms.get((Object)algorithm.getValue().getValue());
    }

    public static ChecksumAlgorithm getChecksumAlgorithm(String name) {
        if (!checksumAlgorithms.containsKey((Object)name)) {
            throw new IllegalArgumentException(name + " is not recognized as a value of the enumeration " + ome.model.enums.ChecksumAlgorithm.class.getCanonicalName());
        }
        return ChecksumAlgorithmMapper.getChecksumAlgorithmWithValue(name);
    }

    public static List<ChecksumAlgorithm> getAllChecksumAlgorithms() {
        ArrayList<ChecksumAlgorithm> algorithms = new ArrayList<ChecksumAlgorithm>(checksumAlgorithms.size());
        for (String name : checksumAlgorithms.keySet()) {
            algorithms.add(ChecksumAlgorithmMapper.getChecksumAlgorithmWithValue(name));
        }
        return algorithms;
    }
}

