/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.admin;

import Ice.Communicator;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import ome.api.local.LocalQuery;
import ome.api.local.LocalUpdate;
import ome.model.meta.Session;
import ome.parameters.Parameters;
import ome.security.AdminAction;
import ome.security.SecuritySystem;
import ome.security.basic.CurrentDetails;
import ome.services.sessions.SessionManager;
import ome.system.ServiceFactory;
import omero.RLong;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.OK;
import omero.cmd.Response;
import omero.cmd.UpdateSessionTimeoutRequest;
import omero.rtypes;
import omero.util.ObjectFactoryRegistry;

public class UpdateSessionTimeoutRequestI
extends UpdateSessionTimeoutRequest
implements IRequest {
    protected Helper helper;
    protected LocalQuery query;
    protected LocalUpdate update;
    protected final CurrentDetails current;
    protected final SessionManager manager;
    protected final SecuritySystem security;
    protected boolean updated = false;
    protected final long maxUserTimeToLive;
    protected final long maxUserTimeToIdle;

    public UpdateSessionTimeoutRequestI(CurrentDetails current, SessionManager manager, SecuritySystem security, long maxUserTimeToLive, long maxUserTimeToIdle) {
        this.current = current;
        this.manager = manager;
        this.security = security;
        this.maxUserTimeToLive = maxUserTimeToLive;
        this.maxUserTimeToIdle = maxUserTimeToIdle;
    }

    @Override
    public Map<String, String> getCallContext() {
        return null;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        this.helper.setSteps(1);
        ServiceFactory sf = this.helper.getServiceFactory();
        this.query = (LocalQuery)sf.getQueryService();
        this.update = (LocalUpdate)sf.getUpdateService();
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        return this.updateSession();
    }

    @Override
    public void finish() throws HandleI.Cancel {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (this.helper.isLast(step)) {
            this.manager.reload(this.session);
            this.helper.setResponseIfNull(new OK());
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    protected Session updateSession() {
        Session s = (Session)this.helper.getServiceFactory().getQueryService().findByQuery("select s from Session s where s.uuid = :uuid", new Parameters().addString("uuid", this.session));
        if (s == null) {
            throw this.helper.cancel(new ERR(), null, "no-session", new String[0]);
        }
        boolean isAdmin = this.current.getCurrentEventContext().isCurrentUserAdmin();
        if (!isAdmin && this.maxUserTimeToLive != 0L && this.timeToLive != null && this.timeToLive.getValue() > this.maxUserTimeToLive) {
            this.timeToLive = rtypes.rlong(this.maxUserTimeToLive);
            this.helper.info("Attempt to modify timeToLive beyond maximum", new Object[0]);
        }
        if (!isAdmin && this.timeToIdle != null && this.timeToIdle.getValue() > this.maxUserTimeToIdle) {
            this.timeToIdle = rtypes.rlong(this.maxUserTimeToIdle);
            this.helper.info("Attempt to modify timeToIdle beyond maximum", new Object[0]);
        }
        this.updated |= this.updateField(s, "ome.model.meta.Session_timeToLive", this.timeToLive, isAdmin);
        this.updated |= this.updateField(s, "ome.model.meta.Session_timeToIdle", this.timeToIdle, isAdmin);
        if (this.updated) {
            this.security.runAsAdmin(new AdminAction(){

                public void runAsAdmin() {
                    UpdateSessionTimeoutRequestI.this.update.flush();
                }
            });
            return s;
        }
        throw this.helper.cancel(new ERR(), null, "no-update-performed", "session", this.session);
    }

    protected boolean updateField(Session s, String field, RLong value, boolean isAdmin) {
        if (value == null) {
            return false;
        }
        long target = value.getValue();
        long current = (Long)s.retrieve(field);
        long diff = target - current;
        if (!isAdmin && diff != 0L && target <= 0L) {
            throw this.helper.cancel(new ERR(), null, "non-admin-disabling", "field", field, "target", "" + target, "current", "" + current);
        }
        this.helper.info("Modifying %s from %s to %s for %s", field, current, target, this.session);
        s.putAt(field, (Object)target);
        return true;
    }

    public static class Factory
    extends ObjectFactoryRegistry {
        private final ObjectFactoryRegistry.ObjectFactory factory;

        public Factory(final CurrentDetails current, final SessionManager sessionManager, final SecuritySystem securitySystem, final long maxUserTimeToLive, final long maxUserTimeToIdle) {
            this.factory = new ObjectFactoryRegistry.ObjectFactory(UpdateSessionTimeoutRequest.ice_staticId()){

                @Override
                public Ice.Object create(String name) {
                    return new UpdateSessionTimeoutRequestI(current, sessionManager, securitySystem, maxUserTimeToLive, maxUserTimeToIdle);
                }
            };
        }

        @Override
        public Map<String, ObjectFactoryRegistry.ObjectFactory> createFactories(Communicator ic) {
            return new ImmutableMap.Builder().put((Object)UpdateSessionTimeoutRequest.ice_staticId(), (Object)this.factory).build();
        }
    }
}

