/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.services.graphs.GraphPolicy;
import omero.cmd.graphs.BaseGraphPolicyAdjuster;
import omero.cmd.graphs.ChildOptionI;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildOptionsPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChildOptionsPolicy.class);

    public static GraphPolicy getChildOptionsPolicy(GraphPolicy graphPolicyToAdjust, final Collection<ChildOptionI> childOptions, final Set<GraphPolicy.Ability> requiredPermissions) {
        if (CollectionUtils.isEmpty(childOptions)) {
            return graphPolicyToAdjust;
        }
        return new BaseGraphPolicyAdjuster(graphPolicyToAdjust){
            private final Map<String, String> namespaceCache;
            private final Map<Map.Entry<String, Long>, String> objectNamespaces;
            {
                super(graphPolicy);
                this.namespaceCache = new HashMap<String, String>();
                this.objectNamespaces = new HashMap<Map.Entry<String, Long>, String>();
            }

            @Override
            public void noteDetails(Session session, IObject object, String realClass, long id) {
                if (object instanceof Annotation) {
                    String query = "SELECT ns FROM Annotation WHERE id = :id";
                    String namespace = (String)session.createQuery("SELECT ns FROM Annotation WHERE id = :id").setParameter("id", (Object)id).uniqueResult();
                    if (namespace != null) {
                        String cachedNamespace = this.namespaceCache.get(namespace);
                        if (cachedNamespace == null) {
                            cachedNamespace = namespace;
                            this.namespaceCache.put(namespace, cachedNamespace);
                        }
                        this.objectNamespaces.put(new AbstractMap.SimpleImmutableEntry<String, Long>(realClass, id), cachedNamespace);
                    }
                }
                super.noteDetails(session, object, realClass, id);
            }

            private boolean isTargetNamespace(ChildOptionI childOption, IObject object) {
                if (object instanceof Annotation) {
                    AbstractMap.SimpleImmutableEntry<String, Long> classAndId = new AbstractMap.SimpleImmutableEntry<String, Long>(object.getClass().getName(), object.getId());
                    return childOption.isTargetNamespace(this.objectNamespaces.get(classAndId));
                }
                return true;
            }

            @Override
            protected boolean isAdjustedBeforeReview(GraphPolicy.Details object) {
                if (object.action == GraphPolicy.Action.EXCLUDE && object.orphan == GraphPolicy.Orphan.RELEVANT) {
                    for (ChildOptionI childOption : childOptions) {
                        Boolean isIncludeVerdict = childOption.isIncludeType(object.subject.getClass());
                        if (isIncludeVerdict == Boolean.TRUE && (requiredPermissions == null || Sets.difference((Set)requiredPermissions, (Set)object.permissions).isEmpty()) && this.isTargetNamespace(childOption, object.subject)) {
                            object.orphan = GraphPolicy.Orphan.IS_LAST;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("including all children of its type, so making " + object);
                            }
                            return true;
                        }
                        if (isIncludeVerdict != Boolean.FALSE || !this.isTargetNamespace(childOption, object.subject)) continue;
                        object.orphan = GraphPolicy.Orphan.IS_NOT_LAST;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("excluding all children of its type, so making " + object);
                        }
                        return true;
                    }
                }
                return false;
            }
        };
    }
}

