/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import ome.model.IObject;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphPolicyRulePredicate;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipTailPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipTailPolicy.class);

    public static GraphPolicy getSkipTailPolicy(final GraphPolicy graphPolicy, final Predicate<Class<? extends IObject>> isSkipClass) {
        return new GraphPolicy(){

            public void registerPredicate(GraphPolicyRulePredicate predicate) {
                graphPolicy.registerPredicate(predicate);
            }

            public GraphPolicy getCleanInstance() {
                throw new IllegalStateException("not expecting to provide a clean instance");
            }

            public void setCondition(String name) {
                graphPolicy.setCondition(name);
            }

            public boolean isCondition(String name) {
                return graphPolicy.isCondition(name);
            }

            public void noteDetails(Session session, IObject object, String realClass, long id) {
                graphPolicy.noteDetails(session, object, realClass, id);
            }

            public final Set<GraphPolicy.Details> review(Map<String, Set<GraphPolicy.Details>> linkedFrom, GraphPolicy.Details rootObject, Map<String, Set<GraphPolicy.Details>> linkedTo, Set<String> notNullable, boolean isErrorRules) throws GraphException {
                if (isSkipClass.test(rootObject.subject.getClass())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("halting review at " + rootObject);
                    }
                    return Collections.emptySet();
                }
                Set changes = graphPolicy.review(linkedFrom, rootObject, linkedTo, notNullable, isErrorRules);
                Iterator changesIterator = changes.iterator();
                while (changesIterator.hasNext()) {
                    GraphPolicy.Details change = (GraphPolicy.Details)changesIterator.next();
                    if (change.action != GraphPolicy.Action.INCLUDE || !isSkipClass.test(change.subject.getClass())) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("forestalling policy-based change " + change);
                    }
                    changesIterator.remove();
                }
                return changes;
            }
        };
    }
}

