/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.query.dsl.RangeMatchingContext;
import org.hibernate.search.query.dsl.RangeTerminationExcludable;
import org.hibernate.search.query.dsl.impl.ConnectedMultiFieldsRangeQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.RangeQueryContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedRangeMatchingContext
implements RangeMatchingContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final RangeQueryContext rangeContext;
    private final List<FieldContext> fieldContexts;
    private int firstOfContext = 0;

    public ConnectedRangeMatchingContext(String fieldName, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.rangeContext = new RangeQueryContext();
        this.fieldContexts = new ArrayList<FieldContext>(4);
        this.fieldContexts.add(new FieldContext(fieldName));
    }

    @Override
    public RangeMatchingContext andField(String field) {
        this.fieldContexts.add(new FieldContext(field));
        this.firstOfContext = this.fieldContexts.size() - 1;
        return this;
    }

    @Override
    public <T> RangeMatchingContext.FromRangeContext<T> from(T from) {
        this.rangeContext.setFrom(from);
        return new ConnectedFromRangeContext(this);
    }

    @Override
    public RangeTerminationExcludable below(Object below) {
        this.rangeContext.setTo(below);
        return new ConnectedMultiFieldsRangeQueryBuilder(this.rangeContext, this.queryCustomizer, this.fieldContexts, this.queryContext);
    }

    @Override
    public RangeTerminationExcludable above(Object above) {
        this.rangeContext.setFrom(above);
        return new ConnectedMultiFieldsRangeQueryBuilder(this.rangeContext, this.queryCustomizer, this.fieldContexts, this.queryContext);
    }

    @Override
    public RangeMatchingContext boostedTo(float boost) {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.getFieldCustomizer().boostedTo(boost);
        }
        return this;
    }

    private List<FieldContext> getCurrentFieldContexts() {
        return this.fieldContexts.subList(this.firstOfContext, this.fieldContexts.size());
    }

    @Override
    public RangeMatchingContext ignoreAnalyzer() {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.setIgnoreAnalyzer(true);
        }
        return this;
    }

    @Override
    public RangeMatchingContext ignoreFieldBridge() {
        for (FieldContext fieldContext : this.getCurrentFieldContexts()) {
            fieldContext.setIgnoreFieldBridge(true);
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectedFromRangeContext<T>
    implements RangeMatchingContext.FromRangeContext<T> {
        private ConnectedRangeMatchingContext mother;

        ConnectedFromRangeContext(ConnectedRangeMatchingContext mother) {
            this.mother = mother;
        }

        @Override
        public RangeTerminationExcludable to(T to) {
            this.mother.rangeContext.setTo(to);
            return new ConnectedMultiFieldsRangeQueryBuilder(this.mother.rangeContext, this.mother.queryCustomizer, this.mother.fieldContexts, this.mother.queryContext);
        }

        @Override
        public RangeMatchingContext.FromRangeContext<T> excludeLimit() {
            this.mother.rangeContext.setExcludeFrom(true);
            return this;
        }
    }
}

