/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacetingRequestImpl
implements FacetingRequest {
    private final String name;
    private final String fieldName;
    private FacetSortOrder sort = FacetSortOrder.COUNT_DESC;
    private boolean includeZeroCounts = true;
    private int maxNumberOfFacets = 1;

    public FacetingRequestImpl(String name, String fieldName) {
        if (name == null) {
            throw new IllegalArgumentException("The request name name cannot be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("The field name cannot be null");
        }
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public String getFacetingName() {
        return this.name;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setSort(FacetSortOrder sort) {
        this.sort = sort;
    }

    @Override
    public FacetSortOrder getSort() {
        return this.sort;
    }

    @Override
    public int getMaxNumberOfFacets() {
        return this.maxNumberOfFacets;
    }

    public void setMaxNumberOfFacets(int maxNumberOfFacets) {
        this.maxNumberOfFacets = maxNumberOfFacets;
    }

    public abstract Class<?> getFieldCacheType();

    public abstract Facet createFacet(String var1, int var2);

    @Override
    public boolean hasZeroCountsIncluded() {
        return this.includeZeroCounts;
    }

    public void setIncludeZeroCounts(boolean includeZeroCounts) {
        this.includeZeroCounts = includeZeroCounts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FacetingRequest");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append(", sort=").append((Object)this.sort);
        sb.append(", includeZeroCounts=").append(this.includeZeroCounts);
        sb.append(", maxNumberOfFacets=").append(this.maxNumberOfFacets);
        sb.append('}');
        return sb.toString();
    }
}

