/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr;

import com.bc.zarr.DataType;
import com.bc.zarr.JZarrException;
import com.bc.zarr.ZarrHeader;
import com.bc.zarr.ZarrPath;
import com.bc.zarr.storage.Store;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import ucar.ma2.Array;
import ucar.ma2.MAMath;

public final class ZarrUtils {
    private static ObjectMapper objectMapper;

    public static String toJson(Object src) throws JZarrException {
        return ZarrUtils.toJson(src, false);
    }

    public static String toJson(Object src, boolean prettyPrinting) throws JZarrException {
        try {
            return ZarrUtils.getObjectWriter(prettyPrinting).writeValueAsString(src);
        }
        catch (JsonProcessingException e) {
            throw new JZarrException("Unable to convert the source object to json.", e);
        }
    }

    public static void toJson(Object o, Writer writer) throws IOException {
        ZarrUtils.toJson(o, writer, false);
    }

    public static void toJson(Object o, Writer writer, boolean prettyPrinting) throws IOException {
        ZarrUtils.getObjectWriter(prettyPrinting).writeValue(writer, o);
    }

    public static int[][] computeChunkIndices(int[] shape, int[] chunks, int[] bufferShape, int[] to) {
        int depth = shape.length;
        int[] start = new int[depth];
        int[] end = new int[depth];
        int numChunks = 1;
        for (int i = 0; i < depth; ++i) {
            int staIdx = to[i] / chunks[i];
            int endIdx = (to[i] + bufferShape[i] - 1) / chunks[i];
            numChunks *= endIdx - staIdx + 1;
            start[i] = staIdx;
            end[i] = endIdx;
        }
        int[][] chunkIndices = new int[numChunks][];
        int[] currentIdx = Arrays.copyOf(start, depth);
        for (int i = 0; i < chunkIndices.length; ++i) {
            chunkIndices[i] = Arrays.copyOf(currentIdx, depth);
            int depthIdx = depth - 1;
            while (depthIdx >= 0) {
                if (currentIdx[depthIdx] >= end[depthIdx]) {
                    currentIdx[depthIdx] = start[depthIdx];
                    --depthIdx;
                    continue;
                }
                int n = depthIdx;
                currentIdx[n] = currentIdx[n] + 1;
                depthIdx = -1;
            }
        }
        return chunkIndices;
    }

    public static String createChunkFilename(int[] currentIdx, String separatorChar) {
        StringBuilder sb = new StringBuilder();
        for (int aCurrentIdx : currentIdx) {
            sb.append(aCurrentIdx);
            sb.append(separatorChar);
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static <T> T fromJson(Reader reader, Class<T> classOfType) throws IOException {
        ObjectMapper objectMapper = ZarrUtils.getObjectMapper();
        return (T)objectMapper.readValue(reader, classOfType);
    }

    public static long computeSize(int[] ints) {
        long count = 1L;
        for (int i : ints) {
            count *= (long)i;
        }
        return count;
    }

    public static int computeSizeInteger(int[] ints) {
        int count = 1;
        for (int i : ints) {
            count *= i;
        }
        return count;
    }

    static ObjectWriter getObjectWriter(boolean prettyPrinting) {
        if (prettyPrinting) {
            DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultPrettyPrinter.FixedSpaceIndenter.instance);
            return ZarrUtils.getObjectMapper().writer((PrettyPrinter)prettyPrinter);
        }
        return ZarrUtils.getObjectMapper().writer();
    }

    static synchronized ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            ZarrHeader.register(objectMapper);
        }
        return objectMapper;
    }

    public static void ensureFileExistAndIsReadable(Path dotZGroupPath) throws IOException {
        if (!Files.exists(dotZGroupPath, new LinkOption[0]) || Files.isDirectory(dotZGroupPath, new LinkOption[0]) || !Files.isReadable(dotZGroupPath)) {
            throw new IOException("File '" + dotZGroupPath.getFileName() + "' is not readable or missing in directory " + dotZGroupPath.getParent() + " .");
        }
    }

    public static void ensureDirectory(Path groupPath) throws IOException {
        if (groupPath == null || !Files.isDirectory(groupPath, new LinkOption[0])) {
            throw new IOException("Path '" + groupPath + "' is not a valid path or not a directory.");
        }
    }

    public static void writeAttributes(Map<String, Object> attributes, ZarrPath zarrPath, Store store) throws IOException {
        if (attributes != null && !attributes.isEmpty()) {
            ZarrPath attrPath = zarrPath.resolve(".zattrs");
            try (OutputStream os = store.getOutputStream(attrPath.storeKey);
                 OutputStreamWriter writer = new OutputStreamWriter(os);){
                ZarrUtils.toJson(attributes, writer, true);
            }
        }
    }

    public static Map<String, Object> readAttributes(ZarrPath zarrPath, Store store) throws IOException {
        ZarrPath attrPath = zarrPath.resolve(".zattrs");
        try (InputStream inputStream = store.getInputStream(attrPath.storeKey);){
            if (inputStream == null) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                return hashMap;
            }
            Map map = ZarrUtils.fromJson(new InputStreamReader(inputStream), Map.class);
            return map;
        }
    }

    public static void deleteDirectoryTreeRecursively(Path toBeDeleted) throws IOException {
        List paths = Files.walk(toBeDeleted, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        for (Path path : paths) {
            Files.delete(path);
        }
    }

    public static Object createDataBufferFilledWith(Number value, DataType dataType, int[] shape) {
        Object dataBuffer = ZarrUtils.createDataBuffer(dataType, shape);
        ucar.ma2.DataType aType = ucar.ma2.DataType.getType(dataBuffer.getClass().getComponentType(), (boolean)false);
        Array array = Array.factory((ucar.ma2.DataType)aType, (int[])shape, (Object)dataBuffer);
        MAMath.setDouble((Array)array, (double)value.doubleValue());
        return array.getStorage();
    }

    public static Object createDataBuffer(DataType dataType, int[] shape) {
        int size = ZarrUtils.computeSizeInteger(shape);
        switch (dataType) {
            case i1: 
            case u1: {
                return new byte[size];
            }
            case i2: 
            case u2: {
                return new short[size];
            }
            case i4: 
            case u4: {
                return new int[size];
            }
            case i8: {
                return new long[size];
            }
            case f4: {
                return new float[size];
            }
            case f8: {
                return new double[size];
            }
        }
        return null;
    }

    public static String normalizeStoragePath(String path) {
        String[] split;
        path = path.replace("\\", "/");
        while (path.contains("//")) {
            path = path.replace("//", "/");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        for (String s : split = path.split("/")) {
            if (!".".equals(s = s.trim()) && !"..".equals(s)) continue;
            throw new IllegalArgumentException("path containing '.' or '..' segment not allowed");
        }
        return path;
    }

    public static void consolidateMetadata(Store store) throws IOException {
        LinkedHashMap<String, HashMap> zdata = new LinkedHashMap<String, HashMap>();
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(store.getGroupKeys());
        keys.addAll(store.getArrayKeys());
        for (String key : keys) {
            String keyZgroup;
            InputStream zgroup;
            String keyZattrs;
            InputStream zattrs;
            String keyZarray;
            InputStream zarray;
            if (key == null) continue;
            if (!(key = key.trim()).equals("")) {
                key = key + "/";
            }
            if ((zarray = store.getInputStream(keyZarray = key + ".zarray")) != null) {
                zdata.put(keyZarray, ZarrUtils.fromJson(new InputStreamReader(zarray), HashMap.class));
            }
            if ((zattrs = store.getInputStream(keyZattrs = key + ".zattrs")) != null) {
                zdata.put(keyZattrs, ZarrUtils.fromJson(new InputStreamReader(zattrs), HashMap.class));
            }
            if ((zgroup = store.getInputStream(keyZgroup = key + ".zgroup")) == null) continue;
            zdata.put(keyZgroup, ZarrUtils.fromJson(new InputStreamReader(zgroup), HashMap.class));
        }
        LinkedHashMap<String, Serializable> metadata = new LinkedHashMap<String, Serializable>();
        metadata.put("metadata", zdata);
        metadata.put("zarr_consolidated_format", Integer.valueOf(1));
        try (OutputStream metaStream = store.getOutputStream(".zmetadata");){
            ZarrUtils.toJson(metadata, new OutputStreamWriter(metaStream), true);
        }
    }
}

