/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr.chunk;

import com.bc.zarr.Compressor;
import com.bc.zarr.chunk.ChunkReaderWriter;
import com.bc.zarr.chunk.ZarrInputStreamAdapter;
import com.bc.zarr.storage.Store;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import ucar.ma2.Array;
import ucar.ma2.DataType;

public class ChunkReaderWriterImpl_Integer
extends ChunkReaderWriter {
    public ChunkReaderWriterImpl_Integer(ByteOrder order, Compressor compressor, int[] chunkShape, Number fill, Store store) {
        super(order, compressor, chunkShape, fill, store);
    }

    @Override
    public Array read(String storeKey) throws IOException {
        try (InputStream is = this.store.getInputStream(storeKey);){
            if (is != null) {
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    this.compressor.uncompress(is, os);
                    int[] ints = new int[this.getSize()];
                    try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());
                         MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(bais);){
                        iis.setByteOrder(this.order);
                        iis.readFully(ints, 0, ints.length);
                    }
                    Array array = Array.factory((DataType)DataType.INT, (int[])this.chunkShape, (Object)ints);
                    return array;
                }
            }
            Array array = this.createFilled(DataType.INT);
            return array;
        }
    }

    @Override
    public void write(String storeKey, Array array) throws IOException {
        try (MemoryCacheImageOutputStream iis = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
             ZarrInputStreamAdapter is = new ZarrInputStreamAdapter(iis);
             OutputStream os = this.store.getOutputStream(storeKey);){
            int[] ints = (int[])array.get1DJavaArray(DataType.INT);
            iis.setByteOrder(this.order);
            iis.writeInts(ints, 0, ints.length);
            iis.seek(0L);
            this.compressor.compress(is, os);
        }
    }
}

