/*
 * Decompiled with CFR 0.152.
 */
package ome.model.enums;

import java.util.HashMap;
import java.util.Map;
import ome.model.units.UnitEnum;

public enum UnitsLength implements UnitEnum
{
    YOTTAMETER("Ym"),
    ZETTAMETER("Zm"),
    EXAMETER("Em"),
    PETAMETER("Pm"),
    TERAMETER("Tm"),
    GIGAMETER("Gm"),
    MEGAMETER("Mm"),
    KILOMETER("km"),
    HECTOMETER("hm"),
    DECAMETER("dam"),
    METER("m"),
    DECIMETER("dm"),
    CENTIMETER("cm"),
    MILLIMETER("mm"),
    MICROMETER("\u00b5m"),
    NANOMETER("nm"),
    PICOMETER("pm"),
    FEMTOMETER("fm"),
    ATTOMETER("am"),
    ZEPTOMETER("zm"),
    YOCTOMETER("ym"),
    ANGSTROM("\u00c5"),
    ASTRONOMICALUNIT("ua"),
    LIGHTYEAR("ly"),
    PARSEC("pc"),
    THOU("thou"),
    LINE("li"),
    INCH("in"),
    FOOT("ft"),
    YARD("yd"),
    MILE("mi"),
    POINT("pt"),
    PIXEL("pixel"),
    REFERENCEFRAME("reference frame");

    private static final Map<String, UnitsLength> bySymbol;
    protected String symbol;

    private UnitsLength(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public static UnitsLength bySymbol(String symbol) {
        return bySymbol.get(symbol);
    }

    static {
        bySymbol = new HashMap<String, UnitsLength>();
        for (UnitsLength t : UnitsLength.values()) {
            bySymbol.put(t.symbol, t);
        }
    }
}

