/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldFragList {
    List<WeightedFragInfo> fragInfos = new ArrayList<WeightedFragInfo>();

    public FieldFragList(int fragCharSize) {
    }

    public void add(int startOffset, int endOffset, List<FieldPhraseList.WeightedPhraseInfo> phraseInfoList) {
        this.fragInfos.add(new WeightedFragInfo(startOffset, endOffset, phraseInfoList));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeightedFragInfo {
        List<SubInfo> subInfos;
        float totalBoost;
        int startOffset;
        int endOffset;

        public WeightedFragInfo(int startOffset, int endOffset, List<FieldPhraseList.WeightedPhraseInfo> phraseInfoList) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.subInfos = new ArrayList<SubInfo>();
            for (FieldPhraseList.WeightedPhraseInfo phraseInfo : phraseInfoList) {
                SubInfo subInfo = new SubInfo(phraseInfo.text, phraseInfo.termsOffsets, phraseInfo.seqnum);
                this.subInfos.add(subInfo);
                this.totalBoost += phraseInfo.boost;
            }
        }

        public List<SubInfo> getSubInfos() {
            return this.subInfos;
        }

        public float getTotalBoost() {
            return this.totalBoost;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("subInfos=(");
            for (SubInfo si : this.subInfos) {
                sb.append(si.toString());
            }
            sb.append(")/").append(this.totalBoost).append('(').append(this.startOffset).append(',').append(this.endOffset).append(')');
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class SubInfo {
            final String text;
            final List<FieldPhraseList.WeightedPhraseInfo.Toffs> termsOffsets;
            int seqnum;

            SubInfo(String text, List<FieldPhraseList.WeightedPhraseInfo.Toffs> termsOffsets, int seqnum) {
                this.text = text;
                this.termsOffsets = termsOffsets;
                this.seqnum = seqnum;
            }

            public List<FieldPhraseList.WeightedPhraseInfo.Toffs> getTermsOffsets() {
                return this.termsOffsets;
            }

            public int getSeqnum() {
                return this.seqnum;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(this.text).append('(');
                for (FieldPhraseList.WeightedPhraseInfo.Toffs to : this.termsOffsets) {
                    sb.append(to.toString());
                }
                sb.append(')');
                return sb.toString();
            }
        }
    }
}

