/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class MaxFloatFunction
extends ValueSource {
    protected final ValueSource source;
    protected final float fval;

    public MaxFloatFunction(ValueSource source, float fval) {
        this.source = source;
        this.fval = fval;
    }

    public String description() {
        return "max(" + this.source.description() + "," + this.fval + ")";
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues vals = this.source.getValues(context, reader);
        return new DocValues(){

            public float floatVal(int doc) {
                float v = vals.floatVal(doc);
                return v < MaxFloatFunction.this.fval ? MaxFloatFunction.this.fval : v;
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                return "max(" + vals.toString(doc) + "," + MaxFloatFunction.this.fval + ")";
            }
        };
    }

    public void createWeight(Map context, Searcher searcher) throws IOException {
        this.source.createWeight(context, searcher);
    }

    public int hashCode() {
        int h = Float.floatToIntBits(this.fval);
        h = h >>> 2 | h << 30;
        return h + this.source.hashCode();
    }

    public boolean equals(Object o) {
        if (MaxFloatFunction.class != o.getClass()) {
            return false;
        }
        MaxFloatFunction other = (MaxFloatFunction)o;
        return this.fval == other.fval && this.source.equals(other.source);
    }
}

