/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.QueryComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.spelling.PossibilityIterator;
import org.apache.solr.spelling.RankedSpellPossibility;
import org.apache.solr.spelling.SpellCheckCollation;
import org.apache.solr.spelling.SpellCheckCorrection;
import org.apache.solr.spelling.SpellingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellCheckCollator {
    private static final Logger LOG = LoggerFactory.getLogger(SpellCheckCollator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SpellCheckCollation> collate(SpellingResult result, String originalQuery, ResponseBuilder ultimateResponse, int maxCollations, int maxTries) {
        ArrayList<SpellCheckCollation> collations = new ArrayList<SpellCheckCollation>();
        QueryComponent queryComponent = null;
        if (ultimateResponse.components != null) {
            for (SearchComponent sc : ultimateResponse.components) {
                if (!(sc instanceof QueryComponent)) continue;
                queryComponent = (QueryComponent)sc;
                break;
            }
        }
        boolean verifyCandidateWithQuery = true;
        if (maxTries < 1) {
            maxTries = 1;
            verifyCandidateWithQuery = false;
        }
        if (queryComponent == null && verifyCandidateWithQuery) {
            LOG.info("Could not find an instance of QueryComponent.  Disabling collation verification against the index.");
            maxTries = 1;
            verifyCandidateWithQuery = false;
        }
        int tryNo = 0;
        int collNo = 0;
        PossibilityIterator possibilityIter = new PossibilityIterator(result.getSuggestions());
        while (tryNo < maxTries && collNo < maxCollations && possibilityIter.hasNext()) {
            RankedSpellPossibility possibility = possibilityIter.next();
            String collationQueryStr = this.getCollation(originalQuery, possibility.getCorrections());
            int hits = 0;
            if (verifyCandidateWithQuery) {
                Object var19_23;
                ++tryNo;
                ResponseBuilder checkResponse = new ResponseBuilder();
                checkResponse.setQparser(ultimateResponse.getQparser());
                checkResponse.setFilters(ultimateResponse.getFilters());
                checkResponse.setQueryString(collationQueryStr);
                checkResponse.components = Arrays.asList(queryComponent);
                ModifiableSolrParams params = new ModifiableSolrParams(ultimateResponse.req.getParams());
                params.set("q", new String[]{collationQueryStr});
                params.remove("start");
                params.set("fl", new String[]{"id"});
                params.set("rows", new String[]{"0"});
                checkResponse.req = new LocalSolrQueryRequest(ultimateResponse.req.getCore(), (SolrParams)params);
                checkResponse.rsp = new SolrQueryResponse();
                try {
                    try {
                        queryComponent.prepare(checkResponse);
                        queryComponent.process(checkResponse);
                        hits = (Integer)checkResponse.rsp.getToLog().get("hits");
                    }
                    catch (Exception e) {
                        LOG.warn("Exception trying to re-query to check if a spell check possibility would return any hits.", (Throwable)e);
                        var19_23 = null;
                        checkResponse.req.close();
                    }
                    var19_23 = null;
                    checkResponse.req.close();
                }
                catch (Throwable throwable) {
                    var19_23 = null;
                    checkResponse.req.close();
                    throw throwable;
                }
            }
            if (hits > 0 || !verifyCandidateWithQuery) {
                ++collNo;
                SpellCheckCollation collation = new SpellCheckCollation();
                collation.setCollationQuery(collationQueryStr);
                collation.setHits(hits);
                collation.setInternalRank(possibility.getRank());
                NamedList misspellingsAndCorrections = new NamedList();
                for (SpellCheckCorrection corr : possibility.getCorrections()) {
                    misspellingsAndCorrections.add(corr.getOriginal().toString(), (Object)corr.getCorrection());
                }
                collation.setMisspellingsAndCorrections((NamedList<String>)misspellingsAndCorrections);
                collations.add(collation);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Collation: " + collationQueryStr + (verifyCandidateWithQuery ? " will return " + hits + " hits." : ""));
        }
        return collations;
    }

    private String getCollation(String origQuery, List<SpellCheckCorrection> corrections) {
        StringBuilder collation = new StringBuilder(origQuery);
        int offset = 0;
        for (SpellCheckCorrection correction : corrections) {
            Token tok = correction.getOriginal();
            if (tok.getPositionIncrement() == 0) continue;
            collation.replace(tok.startOffset() + offset, tok.endOffset() + offset, correction.getCorrection());
            offset += correction.getCorrection().length() - (tok.endOffset() - tok.startOffset());
        }
        return collation.toString();
    }
}

