/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.Colors;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.CellDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.GlassPane;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RollOverNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.RootDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.RowSelectionVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.SelectionVisitor;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourObject;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;

class BrowserControl
implements MouseListener,
ImageDisplayVisitor,
PropertyChangeListener,
MouseMotionListener {
    private static final int DIRECTION_LEFT = 0;
    private static final int DIRECTION_RIGHT = 1;
    private static final int DIRECTION_UP = 2;
    private static final int DIRECTION_DOWN = 3;
    private BrowserModel model;
    private RootDisplay view;
    private CellDisplay selectedCell;
    private boolean rightClickButton;
    private boolean rightClickPad;
    private boolean ctrl;
    private boolean leftMouseButton;
    private Point anchor = new Point();
    private Component source;
    private Rectangle selection = new Rectangle();
    private boolean shiftDown;
    private GlassPane glassPane;
    private boolean added;
    private boolean dragging;
    private KeyAdapter keyListener;

    private void handleKeySelection() {
        SelectionVisitor visitor = new SelectionVisitor(null, true);
        this.view.accept(visitor);
        this.model.setSelectedDisplays(visitor.getSelected());
    }

    private SelectionVisitor handleMultiSelection(boolean install) {
        SelectionVisitor visitor = new SelectionVisitor(this.selection, !install);
        this.view.accept(visitor);
        JLayeredPane pane = (JLayeredPane)this.view.getInternalDesktop();
        if (install) {
            if (this.glassPane == null) {
                this.glassPane = new GlassPane();
            }
            this.glassPane.setSelection(this.selection);
            if (!this.added) {
                this.glassPane.setSize(this.view.getSize());
                pane.add((Component)this.glassPane, (Object)1);
                this.added = true;
            }
        } else {
            if (this.glassPane != null) {
                pane.remove(this.glassPane);
            }
            this.added = false;
        }
        pane.repaint();
        return visitor;
    }

    private void onClick(MouseEvent me, boolean released) {
        if (me.getClickCount() == 1) {
            ImageDisplay d = this.findParentDisplay(me.getSource());
            d.moveToFront();
            this.handleSelection(d, me);
            me = SwingUtilities.convertMouseEvent((Component)me.getSource(), me, this.view);
            Point p = me.getPoint();
            this.model.setPopupPoint(p, false);
            if (me.isPopupTrigger() && !released || me.isPopupTrigger() && released && !UIUtilities.isMacOS() || UIUtilities.isMacOS() && SwingUtilities.isLeftMouseButton(me) && me.isControlDown()) {
                this.model.setPopupPoint(p, true);
            }
        } else if (!(me.getClickCount() != 2 || me.isMetaDown() || me.isControlDown() || me.isShiftDown())) {
            Object src = me.getSource();
            ImageDisplay d = this.findParentDisplay(src);
            if (d == this.view) {
                return;
            }
            if (d instanceof ImageNode && d.getTitleBar() != src && this.isSelectionValid(d)) {
                this.model.viewDisplay(d, false);
            }
        }
    }

    private void handleSelection(ImageDisplay d, MouseEvent me) {
        boolean shiftDown = me.isShiftDown();
        Point p = me.getPoint();
        ImageDisplay previousDisplay = this.model.getLastSelectedDisplay();
        if ((this.rightClickButton && !this.ctrl || this.rightClickPad) && this.model.isMultiSelection()) {
            return;
        }
        if ((this.ctrl || shiftDown) && this.leftMouseButton) {
            ImageDisplay node;
            ImageDisplay previous = this.model.getLastSelectedDisplay();
            if (previous == null) {
                this.model.setSelectedDisplay(d, true, true);
                return;
            }
            Object object = previous.getHierarchyObject();
            Class<?> ref = object.getClass();
            if (!ref.equals(d.getHierarchyObject().getClass())) {
                return;
            }
            Collection<ImageDisplay> nodes = this.model.getSelectedDisplays();
            Iterator<ImageDisplay> i = nodes.iterator();
            if (nodes.size() == 1) {
                while (i.hasNext()) {
                    node = i.next();
                    if (!node.equals(d)) continue;
                    return;
                }
            }
            boolean remove = false;
            while (i.hasNext()) {
                node = i.next();
                if (!node.equals(d)) continue;
                remove = true;
                break;
            }
            if (remove) {
                this.model.removeSelectedDisplay(d);
            } else {
                this.model.setSelectedDisplay(d, true, true);
            }
        } else if (this.isSelectionValid(d)) {
            if (d instanceof CellDisplay && !d.equals(previousDisplay)) {
                this.setSelectedCell(p, (CellDisplay)d);
            } else {
                boolean b = this.model.isMultiSelection();
                if (this.rightClickButton && b) {
                    return;
                }
                if (b || !d.equals(previousDisplay)) {
                    this.model.setSelectedDisplay(d, false, true);
                }
            }
        }
    }

    private void setSelectedCell(Point p, CellDisplay node) {
        this.selectedCell = node;
        SwingUtilities.convertPointToScreen(p, node);
        ColourPicker picker = new ColourPicker(DataBrowserAgent.getRegistry().getTaskBar().getFrame(), node.getHighlight(), true);
        picker.setColorDescription(node.getDescription());
        picker.addPropertyChangeListener(this);
        picker.setLocation(p);
        picker.setVisible(true);
    }

    private ImageDisplay findParentDisplay(Object x) {
        while (true) {
            if (x instanceof ImageDisplay) {
                return (ImageDisplay)x;
            }
            if (!(x instanceof JComponent)) break;
            x = ((JComponent)x).getParent();
        }
        return null;
    }

    private void attachListeners(ImageNode node) {
        if (node == null) {
            return;
        }
        node.addPropertyChangeListener(this);
        node.addListenerToComponents(this);
    }

    BrowserControl(BrowserModel model, RootDisplay view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        model.addPropertyChangeListener("selectedDataBrowserNodeDisplay", this);
        model.addPropertyChangeListener("rollOver", this);
        this.model = model;
        this.view = view;
        view.getInternalDesktop().addMouseMotionListener(this);
        view.getInternalDesktop().setCursor(Cursor.getDefaultCursor());
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 65: {
                        if ((!UIUtilities.isMacOS() || !e.isMetaDown()) && (UIUtilities.isMacOS() || !e.isControlDown())) break;
                        BrowserControl.this.handleKeySelection();
                        break;
                    }
                    case 38: {
                        BrowserControl.this.navigate(2, e.isShiftDown());
                        break;
                    }
                    case 40: {
                        BrowserControl.this.navigate(3, e.isShiftDown());
                        break;
                    }
                    case 37: {
                        BrowserControl.this.navigate(0, e.isShiftDown());
                        break;
                    }
                    case 39: {
                        BrowserControl.this.navigate(1, e.isShiftDown());
                    }
                }
            }
        };
    }

    public void navigate(int direction, boolean multiSel) {
        ImageDisplay current = this.model.getLastSelectedDisplay();
        if (current == null) {
            return;
        }
        Rectangle b = current.getBounds();
        int x = b.x;
        int y = b.y;
        switch (direction) {
            case 0: {
                x = b.x - (int)((double)b.width * 0.5);
                break;
            }
            case 1: {
                x = b.x + (int)((double)b.width * 1.5);
                break;
            }
            case 2: {
                y = b.y - (int)((double)b.height * 0.5);
                break;
            }
            case 3: {
                y = b.y + (int)((double)b.height * 1.5);
            }
        }
        this.model.setSelectedDisplay(new Point(x, y), multiSel);
    }

    void initialize() {
        this.model.accept(this);
    }

    boolean isSelectionValid(ImageDisplay node) {
        if (!(node instanceof ImageNode)) {
            return true;
        }
        Object ho = node.getHierarchyObject();
        if (!(ho instanceof ImageData)) {
            return true;
        }
        ImageData img = (ImageData)ho;
        try {
            img.getDefaultPixels();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void visit(ImageNode node) {
        this.attachListeners(node);
        if (node instanceof WellSampleNode) {
            WellSampleNode sample = (WellSampleNode)node;
            WellImageSet well = sample.getParentWell();
            List<WellSampleNode> samples = well.getWellSamples();
            for (WellSampleNode wsn : samples) {
                if (wsn == node) continue;
                this.attachListeners(wsn);
            }
        }
    }

    @Override
    public void visit(ImageSet node) {
        node.getTitleBar().addMouseListener(this);
        node.getInternalDesktop().addMouseListener(this);
        node.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("classifyNode".equals(name)) {
            this.model.setNodeForProperty("classifiedNode", evt.getNewValue());
        } else if ("annotateNode".equals(name)) {
            this.model.setNodeForProperty("annotatedNode", evt.getNewValue());
        } else if ("rollOver".equals(name)) {
            RollOverNode n = (RollOverNode)evt.getNewValue();
            ImageNode img = null;
            if (n != null) {
                img = n.getNode();
            }
            this.view.setTitle(this.model.currentPathString(img));
        } else if ("pinThumbnail".equals(name)) {
            ImageNode node = (ImageNode)evt.getNewValue();
            this.model.setThumbSelected(true, node);
        } else if (!"endMoving".equals(name)) {
            if ("descriptor".equals(name)) {
                CellDisplay node = (CellDisplay)evt.getNewValue();
                this.setSelectedCell(node.getLocation(), node);
            } else if ("colour".equals(name)) {
                ColourObject co = (ColourObject)evt.getNewValue();
                if (this.selectedCell == null) {
                    return;
                }
                this.selectedCell.setHighlight(co.color);
                this.selectedCell.setDescription(co.description != null ? co.description : "");
                this.model.setSelectedCell(this.selectedCell);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.anchor = me.getPoint();
        Component s = (Component)me.getSource();
        s.requestFocus();
        s.removeKeyListener(this.keyListener);
        s.addKeyListener(this.keyListener);
        this.shiftDown = me.isShiftDown();
        if (this.dragging) {
            return;
        }
        Collection<ImageDisplay> l = this.model.getSelectedDisplays();
        if (this.source == null) {
            this.source = l.size() == 0 ? (JComponent)me.getSource() : (JComponent)((List)l).get(0);
        }
        if (this.shiftDown && l.size() > 0) {
            return;
        }
        this.rightClickPad = UIUtilities.isMacOS() && SwingUtilities.isLeftMouseButton(me) && me.isControlDown();
        this.rightClickButton = SwingUtilities.isRightMouseButton(me);
        this.ctrl = me.isControlDown();
        if (UIUtilities.isMacOS()) {
            this.ctrl = me.isMetaDown();
        }
        this.leftMouseButton = SwingUtilities.isLeftMouseButton(me);
        if (!UIUtilities.isWindowsOS()) {
            this.onClick(me, false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.dragging) {
            SelectionVisitor visitor = this.handleMultiSelection(false);
            this.model.setSelectedDisplays(visitor.getSelected());
            this.dragging = false;
            return;
        }
        Collection<ImageDisplay> l = this.model.getSelectedDisplays();
        if (this.shiftDown && l.size() >= 1) {
            if (this.source == null) {
                this.source = (JComponent)((List)l).get(0);
            }
            ImageDisplay display = this.findParentDisplay((Component)me.getSource());
            Rectangle rS = display.getBounds();
            display = this.findParentDisplay(this.source);
            Rectangle rAnchor = display.getBounds();
            RowSelectionVisitor visitor = new RowSelectionVisitor(rS, rAnchor, true);
            this.view.accept(visitor);
            this.shiftDown = me.isShiftDown();
            if (!this.shiftDown) {
                this.source = null;
            }
            ArrayList<ImageDisplay> selectedDisplays = new ArrayList<ImageDisplay>();
            List<ImageNode> visibleNodes = this.model.getVisibleNodes();
            Colors colors = Colors.getInstance();
            for (ImageDisplay node : visitor.getSelected()) {
                if (visibleNodes.contains(node)) {
                    selectedDisplays.add(node);
                    continue;
                }
                node.setHighlight(colors.getDeselectedHighLight(node));
            }
            this.model.setSelectedDisplays(selectedDisplays);
            return;
        }
        this.source = null;
        this.leftMouseButton = SwingUtilities.isLeftMouseButton(me);
        if (UIUtilities.isWindowsOS()) {
            this.onClick(me, true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        boolean mo = this.model.isMouseOver();
        boolean ro = this.model.isRollOver();
        if (!mo && !ro) {
            return;
        }
        Object src = me.getSource();
        ImageDisplay d = this.findParentDisplay(src);
        if (mo) {
            if (d instanceof RootDisplay) {
                ImageDisplay lastSelected = this.model.getLastSelectedDisplay();
                if (lastSelected != null) {
                    this.view.setTitle(this.model.currentPathString(lastSelected));
                } else {
                    lastSelected = null;
                }
                this.model.setNodeForProperty("mouseOver", lastSelected);
                return;
            }
            if (!(d instanceof RootDisplay)) {
                this.view.setTitle(this.model.currentPathString(d));
            }
            this.model.setNodeForProperty("mouseOver", d);
        }
        if (!ro) {
            return;
        }
        if (d instanceof ImageNode && d.getTitleBar() != src) {
            ImageNode img = (ImageNode)d;
            RollOverNode n = new RollOverNode(img, img.getLocationOnScreen());
            this.model.setRollOverNode(n);
        } else {
            this.model.setRollOverNode(null);
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.model.setRollOverNode(null);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getSource() != this.view.getInternalDesktop()) {
            return;
        }
        this.dragging = true;
        Point p = e.getPoint();
        if (p == null) {
            p = new Point();
        }
        this.selection.width = Math.abs(p.x - this.anchor.x);
        this.selection.height = Math.abs(p.y - this.anchor.y);
        this.selection.x = this.anchor.x < p.x ? this.anchor.x : p.x;
        this.selection.y = this.anchor.y < p.y ? this.anchor.y : p.y;
        this.handleMultiSelection(true);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

