/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.util.browser.DataNode;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

class DataNodeElement {
    private static final String NO_LOCATION = "--";
    private DataNode location;
    private String name;

    DataNodeElement(DataNode location, String value) {
        this.location = location;
        if (this.location != null && this.location.isNoDataset() && this.getParent() == null) {
            this.location = null;
            value = null;
        }
        this.setName(value);
    }

    void setName(String value) {
        this.name = "";
        if (CommonsLangUtils.isBlank(value)) {
            if (this.location == null) {
                this.name = NO_LOCATION;
            } else if (this.location.getDataObject() instanceof ScreenData || this.location.isDefaultScreen()) {
                this.name = this.name + this.location.toString();
            } else {
                DataNode parent = this.location.getParent();
                if (parent != null && !parent.isDefaultNode() && !this.location.isDefaultNode()) {
                    this.name = parent.toString() + "/";
                }
                this.name = this.name + this.location.toString();
            }
        } else if (this.location == null) {
            this.name = value;
        } else {
            DataNode parent = this.location.getParent();
            if (parent != null && !parent.isDefaultNode()) {
                this.name = parent.toString() + "/";
            }
            this.name = !this.location.isDefaultNode() ? this.name + this.location.toString() : this.name + value;
        }
    }

    DataObject getParent() {
        if (this.location == null) {
            return null;
        }
        DataNode parent = this.location.getParent();
        if (this.isHCSContainer().booleanValue()) {
            DataObject object = this.location.getDataObject();
            if (this.location.isDefaultNode()) {
                return null;
            }
            return object;
        }
        if (parent == null || parent.isDefaultNode()) {
            return null;
        }
        return parent.getDataObject();
    }

    Boolean isHCSContainer() {
        if (this.location == null) {
            return null;
        }
        DataObject object = this.location.getDataObject();
        if (object == null) {
            DatasetData d = this.getLocation();
            if (d != null) {
                return false;
            }
            return null;
        }
        return object instanceof ScreenData;
    }

    DatasetData getLocation() {
        if (this.location == null) {
            return null;
        }
        if (this.location.isDefaultNode()) {
            return null;
        }
        if (this.location.getDataObject() instanceof DatasetData) {
            return (DatasetData)this.location.getDataObject();
        }
        return null;
    }

    Object getRefNode() {
        if (this.location == null) {
            return null;
        }
        return this.location.getRefNode();
    }

    public String toString() {
        return this.name;
    }
}

