/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.view.ModuleTree;

public class DynamicModuleTree
extends JPanel {
    private static String ADD_NODE_CMD = "add";
    private static String DELETE_NODE_CMD = "delete";
    public static final String RESET_TREE_CMD = "reset";
    private ModuleTree treePanel;
    private ModuleController controller = ModuleController.getInstance();

    public DynamicModuleTree(DefaultMutableTreeNode elem, ActionListener listener) {
        super(new BorderLayout());
        this.treePanel = new ModuleTree(elem, listener);
        this.add((Component)this.treePanel, "Center");
        this.add((Component)this.generateButtonPane(listener), "South");
    }

    public DynamicModuleTree(ActionListener listener) {
        this(ModuleController.getInstance().getTree(), listener);
    }

    private JPanel generateButtonPane(ActionListener l) {
        JButton resetBtn = new JButton("Reset object tree");
        resetBtn.setActionCommand(RESET_TREE_CMD);
        resetBtn.addActionListener(l);
        resetBtn.setToolTipText("Reset object tree to initial state. Initial state of a child node is inherit last state of parent node.\t\t\t\tReload user input to initial state objects.");
        JPanel btnPanel = new JPanel(new GridLayout(0, 1));
        btnPanel.add(resetBtn);
        return btnPanel;
    }

    public void addTreeSelectionListener(MDEContent mdeContent) {
        this.treePanel.addTreeSelectionListener(mdeContent);
    }

    public DefaultMutableTreeNode getLastSelectedPathComponent() {
        return this.treePanel.getLastSelectedPathComponent();
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.treePanel.getRoot();
    }

    public ModuleTree getModuleTree() {
        return this.treePanel;
    }

    public DefaultMutableTreeNode selectFirstNode() {
        if (this.getRootNode() == null || this.getRootNode().getChildCount() == 0) {
            return null;
        }
        DefaultMutableTreeNode firstNode = (DefaultMutableTreeNode)this.getRootNode().getFirstChild();
        if (firstNode != null) {
            this.getTree().getSelectionModel().setSelectionPath(new TreePath(firstNode.getPath()));
        }
        return firstNode;
    }

    public JTree getTree() {
        if (this.treePanel == null) {
            return null;
        }
        return this.treePanel.getTree();
    }
}

