/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class DocumentListenerForPercentFraction
implements DocumentListener {
    private TagData tag;
    private String error;

    public DocumentListenerForPercentFraction(TagData tag, String error) {
        this.tag = tag;
        this.error = error;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validate();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validate();
    }

    private void validate() {
        this.tag.setTagInfoError("");
        Double res = this.validateInput(this.tag, this.error);
        if (res != null && (res < 0.0 || res > 1.0)) {
            this.tag.setTagInfoError(this.error);
        }
    }

    private Double validateInput(TagData tag, String error) {
        return this.validateInput(tag, error, null);
    }

    private Double validateInput(TagData tag, String error, String pattern) {
        String text = tag.getTagValue();
        if (text.equals("")) {
            return null;
        }
        String errorString = "";
        tag.setTagInfoError("");
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            String text2 = text.replaceAll(",", ".");
            try {
                return Double.parseDouble(text2);
            }
            catch (NumberFormatException e2) {
                errorString = error;
                tag.setTagInfoError(errorString);
                return null;
            }
        }
    }
}

