/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;

public class ExportDialog
extends JDialog
implements ActionListener {
    private JButton btn_OK;
    private JButton btn_cancel;
    private JButton btn_browse_save;
    private JTextField txt_path;
    private JCheckBox ch_addPath;
    private JCheckBox ch_addUnitToKey;
    private JCheckBox ch_exportAllData;
    private JRadioButton ch_tsv;
    private JRadioButton ch_csv;
    private JRadioButton ch_txt;
    private JRadioButton ch_idr;
    private DefaultMutableTreeNode tree;
    private boolean cancel = false;
    private Boolean appendToFile;
    private File exportfile = null;

    public ExportDialog(JFrame parent) {
        super((Frame)parent, "Export to file");
        this.buildGUI();
        this.pack();
        this.setVisible(true);
    }

    private void buildGUI() {
        this.setBounds(100, 100, 500, 600);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.setModal(true);
        this.btn_OK = new JButton("OK");
        this.btn_OK.addActionListener(this);
        this.btn_cancel = new JButton("Cancel");
        this.btn_cancel.addActionListener(this);
        Box btnPane = Box.createHorizontalBox();
        btnPane.add(this.btn_cancel);
        btnPane.add(Box.createHorizontalStrut(5));
        btnPane.add(this.btn_OK);
        JPanel subPanel = new JPanel();
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Configuration:");
        subPanel.setLayout(new BoxLayout(subPanel, 1));
        subPanel.setBorder(titleBorder);
        this.ch_addPath = new JCheckBox("use tree path as addition to key");
        this.ch_addPath.setToolTipText("Set pattern of key: <objectName>#..#<objectName>|<propertyName>");
        this.ch_addPath.setSelected(true);
        subPanel.add(this.ch_addPath);
        this.ch_addUnitToKey = new JCheckBox("add unit to key");
        this.ch_addUnitToKey.setSelected(false);
        subPanel.add(this.ch_addUnitToKey);
        this.ch_exportAllData = new JCheckBox("Export all metadata");
        this.ch_exportAllData.setSelected(false);
        this.ch_exportAllData.setToolTipText("Export also metadata that available in the image container");
        subPanel.add(this.ch_exportAllData);
        JPanel subPanel_format = new JPanel();
        TitledBorder titleBorder_format = BorderFactory.createTitledBorder("Format:");
        subPanel_format.setLayout(new BoxLayout(subPanel_format, 1));
        subPanel_format.setBorder(titleBorder_format);
        this.ch_tsv = new JRadioButton("text format seperated by tabs");
        this.ch_tsv.setSelected(true);
        this.ch_csv = new JRadioButton("text format seperated by commas");
        this.ch_csv.setSelected(false);
        this.ch_txt = new JRadioButton("text format seperated by spaces");
        this.ch_txt.setSelected(false);
        this.ch_idr = new JRadioButton("IDR submission format");
        this.ch_idr.setSelected(false);
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.ch_tsv);
        btnGroup.add(this.ch_csv);
        btnGroup.add(this.ch_txt);
        btnGroup.add(this.ch_idr);
        subPanel_format.add(this.ch_tsv);
        subPanel_format.add(this.ch_csv);
        subPanel_format.add(this.ch_txt);
        subPanel_format.add(this.ch_idr);
        subPanel.add(subPanel_format);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(5, 5));
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPanel.add((Component)subPanel, "Center");
        JLabel destPath_Lbl = new JLabel("Destination");
        this.txt_path = new JTextField(50);
        this.txt_path.setEditable(false);
        this.txt_path.setToolTipText("Destination to store file");
        if (this.exportfile != null) {
            this.txt_path.setText(this.exportfile.getAbsolutePath());
        }
        this.btn_browse_save = new JButton("Browse");
        this.btn_browse_save.addActionListener(this);
        JPanel destP = new JPanel();
        destP.add(destPath_Lbl);
        destP.add(this.txt_path);
        destP.add(this.btn_browse_save);
        mainPanel.add((Component)destP, "South");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)btnPane, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btn_OK) {
            this.appendToFile = this.getWriteMode(this.exportfile);
            if (this.appendToFile == null) {
                return;
            }
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.btn_cancel) {
            this.exportfile = null;
            this.cancel = true;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.btn_browse_save) {
            int returnValSave;
            String formatExtFileName = this.getFormatExtensionName();
            JFileChooser fcSave = new JFileChooser();
            fcSave.setSelectedFile(new File(fcSave.getCurrentDirectory(), formatExtFileName));
            if (this.exportfile != null) {
                fcSave.setCurrentDirectory(new File(this.exportfile.getParent()));
            }
            if ((returnValSave = fcSave.showSaveDialog(this)) == 0) {
                this.exportfile = fcSave.getSelectedFile();
                this.txt_path.setText(this.exportfile.getAbsolutePath());
            }
        }
    }

    private Boolean getWriteMode(File outputFile) {
        Object[] options = new Object[]{"Overwrite file", "Append to file", "Cancel"};
        if (outputFile != null && outputFile.exists()) {
            int result = JOptionPane.showOptionDialog(this.btn_browse_save.getParent(), "File exists!", "File exists", 1, 3, null, options, options[0]);
            switch (result) {
                case 1: {
                    return true;
                }
                case 2: {
                    return null;
                }
            }
            return false;
        }
        return false;
    }

    private String getFormatExtensionName() {
        if (this.ch_csv.isSelected()) {
            return "metadata_export_mde.csv";
        }
        if (this.ch_tsv.isSelected()) {
            return "metadata_export_mde.tsv";
        }
        if (this.ch_txt.isSelected()) {
            return "metadata_export_mde.txt";
        }
        if (this.ch_idr.isSelected()) {
            return "idr_study.txt";
        }
        return "metadata_export_mde.txt";
    }

    public File getDestination() {
        return this.exportfile;
    }

    public boolean addPath() {
        return this.ch_addPath.isSelected();
    }

    public boolean addUnitToKey() {
        return this.ch_addUnitToKey.isSelected();
    }

    public boolean exportAll() {
        return this.ch_exportAllData.isSelected();
    }

    public String getDelimeter() {
        if (this.ch_csv.isSelected()) {
            return ",";
        }
        if (this.ch_tsv.isSelected()) {
            return "\t";
        }
        if (this.ch_txt.isSelected()) {
            return " ";
        }
        if (this.ch_idr.isSelected()) {
            return "\t";
        }
        return " ";
    }

    public int getFormatMode() {
        if (this.ch_idr.isSelected()) {
            return 1;
        }
        return 0;
    }

    public boolean getWritingMode() {
        if (this.appendToFile == null) {
            return false;
        }
        return this.appendToFile;
    }

    public Boolean isCancelled() {
        return this.cancel;
    }
}

