/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout;

import java.util.List;
import java.util.stream.Collectors;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.OntologyElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.parser.BioPortal_Parser;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.parser.OLS_Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TagDataParser {
    final String ELEM_TAGDATA = "TagData";
    final String ATTR_NAME = "Name";
    final String ATTR_DEFAULT_VAL = "DefaultValues";
    final String ATTR_VALUE = "Value";
    final String ATTR_VISIBLE = "Visible";
    final String ATTR_UNIT = "Unit";
    final String ATTR_TYPE = "Type";
    final String ELEM_ONTOLOGY = "Ontology";
    final String ATTR_RESTURL = "URL_restapi";
    final String ATTR_API_KEY = "API_key";
    final String ATTR_ONTO_ACRO = "Acronym";
    final String ATTR_ONTO_REF = "ID_href";

    public Element createXMLElem(TagData t, Document doc, String elemName, boolean saveVal) {
        if (t == null) {
            return null;
        }
        Element result = doc.createElement(elemName);
        result.setAttribute("Name", t.getTagName());
        result.setAttribute("Type", String.valueOf(t.getTagType()));
        result.setAttribute("Visible", String.valueOf(t.isVisible()));
        if (saveVal) {
            result.setAttribute("Value", t.getTagValue());
        } else {
            result.setAttribute("Value", "");
        }
        result.setAttribute("Unit", t.getTagUnitString());
        result.setAttribute("DefaultValues", t.getDefaultValuesAsString());
        return result;
    }

    public TagData parseFromConfig(Node n, boolean pre, String parent) {
        TagData t = null;
        if (n.getNodeName().equals("TagData") && n.getNodeType() == 1) {
            Element eElement = (Element)n;
            String tagName = eElement.getAttribute("Name");
            String tagVal = "";
            if (pre) {
                tagVal = eElement.getAttribute("Value");
            }
            String tagUnit = eElement.getAttribute("Unit");
            String tagVis = eElement.getAttribute("Visible");
            String defaultVal = eElement.getAttribute("DefaultValues");
            String tagType = eElement.getAttribute("Type");
            String[] defaultValList = null;
            List<OntologyElement> ontoList = null;
            if (eElement.hasChildNodes()) {
                ontoList = this.parseOntology(eElement);
                defaultValList = this.listToStringArray(ontoList);
            }
            if (defaultValList == null) {
                defaultValList = defaultVal.split(",");
            }
            boolean standardConstr = true;
            if (tagType.equals("ArrayField") && tagVal != null && tagVal.length() > 0) {
                standardConstr = false;
                String[] values = tagVal.split(",");
                t = new TagData(parent, tagName, values, false, tagType, values.length);
                if (tagUnit != null && !tagUnit.isEmpty()) {
                    t.setTagUnit(tagUnit);
                }
            }
            if (standardConstr) {
                t = new TagData(parent, tagName, tagVal, tagUnit, false, tagType, defaultValList);
            }
            t.setVisible(Boolean.parseBoolean(tagVis));
            if (ontoList != null) {
                t.setOntologyRef(ontoList);
            }
        }
        return t;
    }

    private String[] listToStringArray(List<OntologyElement> list) {
        if (list != null) {
            return list.stream().map(x -> x.getName()).collect(Collectors.toList()).toArray(new String[0]);
        }
        return null;
    }

    private List<OntologyElement> parseOntology(Element eElement) {
        List<OntologyElement> labelList = null;
        NodeList nodeList = eElement.getElementsByTagName("Ontology");
        if (nodeList != null && nodeList.getLength() > 0) {
            Node n = nodeList.item(0);
            if (n.getNodeName().equals("Ontology") && n.getNodeType() == 1) {
                eElement = (Element)n;
            }
            String ontology_RESTAPI_url = eElement.getAttribute("URL_restapi");
            String api_key = "";
            if (eElement.hasAttribute("API_key")) {
                api_key = eElement.getAttribute("API_key");
            }
            String ontologyAcronym = eElement.getAttribute("Acronym");
            String ontologyRef = eElement.getAttribute("ID_href");
            ImporterAgent.getRegistry().getLogger().debug(null, "[MDE]" + String.format("Parse Ontology: {acronym:%s,id:%s}", ontologyAcronym, ontologyRef));
            if (ontology_RESTAPI_url == null || ontology_RESTAPI_url.isEmpty() || ontologyAcronym == null || ontologyAcronym.isEmpty() || ontologyRef == null || ontologyRef.isEmpty()) {
                return null;
            }
            BioPortal_Parser oParser = new BioPortal_Parser(ontology_RESTAPI_url, api_key, ontologyAcronym);
            try {
                labelList = oParser.getSubLabels(ontologyAcronym, ontologyRef);
                if (labelList == null) {
                    OLS_Parser olsParser = new OLS_Parser(ontology_RESTAPI_url, ontologyAcronym);
                    labelList = olsParser.getSubLabels(ontologyAcronym, ontologyRef);
                }
                if (labelList == null) {
                    ImporterAgent.getRegistry().getLogger().debug(null, "[MDE] " + String.format("Ontology element at %s has no childs", ontologyRef));
                }
            }
            catch (Exception e) {
                ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] can't parse given ontology item [" + ontologyAcronym + ", " + ontologyRef + "]");
                e.printStackTrace();
            }
        }
        return labelList;
    }
}

