/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.util.HistoryItem;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPane;

class HistoryCanvas
extends TinyPane {
    private ImViewerControl controller;

    private void addDecoration() {
        IconManager icons = IconManager.getInstance();
        JButton clearButton = new JButton(icons.getIcon(56));
        clearButton.addActionListener(this.controller.getAction(ImViewerControl.CLEAR_HISTORY));
        clearButton.setToolTipText("Clear the History excepted the initial view.");
        clearButton.setContentAreaFilled(false);
        clearButton.setBorder(BorderFactory.createEmptyBorder());
        clearButton.setMargin(new Insets(0, 0, 0, 0));
        clearButton.setOpaque(false);
        clearButton.setFocusPainted(false);
        ArrayList<JButton> nodes = new ArrayList<JButton>();
        nodes.add(clearButton);
        this.setDecoration(nodes);
    }

    HistoryCanvas(ImViewerControl controller) {
        this.controller = controller;
        this.clearDefaultButtons();
        this.addDecoration();
        this.setListenToBorder(false);
        this.controller = controller;
    }

    void clearHistory(List nodes) {
        JComponent desktop = this.getInternalDesktop();
        desktop.removeAll();
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            desktop.add((HistoryItem)i.next());
        }
        Rectangle r = this.getBounds();
        Rectangle bounds = this.getContentsBounds();
        Insets insets = this.getInsets();
        int w = r.width - insets.left - insets.right;
        if (w < 0) {
            return;
        }
        Dimension d = new Dimension(w, bounds.height);
        desktop.setSize(d);
        desktop.setPreferredSize(d);
    }

    void doGridLayout(int width, List nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        HistoryItem child = null;
        Dimension maxDim = ((HistoryItem)nodes.get(0)).getPreferredSize();
        Iterator i = nodes.iterator();
        int j = 0;
        while (i.hasNext()) {
            child = (HistoryItem)i.next();
            child.setBounds(j * maxDim.width, 0, maxDim.width, maxDim.height);
            child.validate();
            ++j;
        }
        int finalWidth = nodes.size() * maxDim.width;
        if (finalWidth > width) {
            JScrollPane dskDecorator = this.getDeskDecorator();
            Dimension d = new Dimension(finalWidth, this.getPreferredSize().height);
            this.getInternalDesktop().setSize(d);
            this.getInternalDesktop().setPreferredSize(d);
            this.getInternalDesktop().validate();
            dskDecorator.getHorizontalScrollBar().setValue(finalWidth);
        }
    }
}

