/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CreateCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ImportAction
extends TreeViewerAction {
    static final String DESCRIPTION_DATASET = "Launch the Importer. Import data to Project, Datasets...";
    static final String DESCRIPTION_SCREEN = "Launch the Importer. Import data to Screen...";
    public static final String NAME = "Import...";
    private boolean noNode;

    private void setActionDescription(int browserType) {
        if (browserType == 1) {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SCREEN));
        } else {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DATASET));
        }
    }

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onBrowserSelection(Browser browser) {
        int type = TreeViewerAgent.getDefaultHierarchy();
        this.setActionDescription(type);
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        if (this.noNode) {
            this.setEnabled(true);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        this.setEnabled(false);
        if (browser == null) {
            return;
        }
        if (selectedDisplay == null) {
            this.setEnabled(true);
            return;
        }
        TreeImageDisplay[] nodes = browser.getSelectedDisplays();
        if (nodes != null && nodes.length > 1) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof ProjectData || ho instanceof ScreenData || ho instanceof DatasetData) {
            this.setEnabled(this.model.canLink(ho));
        } else if (ho instanceof ExperimenterData && browser.getBrowserType() != 6) {
            ExperimenterData exp = TreeViewerAgent.getUserDetails();
            this.setEnabled(exp.getId() == ((ExperimenterData)ho).getId());
        }
    }

    public ImportAction(TreeViewer model, boolean noNode) {
        super(model);
        this.noNode = noNode;
        this.name = NAME;
        this.setActionDescription(TreeViewerAgent.getDefaultHierarchy());
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(90));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CreateCmd cmd = new CreateCmd(this.model, 5);
        cmd.setWithParent(!this.noNode);
        cmd.execute();
    }
}

