/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.browser;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FileData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;

public class NodesFinder
implements TreeImageDisplayVisitor {
    private List<Long> ids;
    private Class<?> type;
    private Set<TreeImageDisplay> nodes;
    private Collection<DataObject> refObjects;
    private boolean byName;

    private String getNodeName(Object obj) {
        if (obj instanceof ProjectData) {
            return ((ProjectData)obj).getName();
        }
        if (obj instanceof DatasetData) {
            return ((DatasetData)obj).getName();
        }
        if (obj instanceof ImageData) {
            return ((ImageData)obj).getName();
        }
        if (obj instanceof ExperimenterData) {
            return EditorUtil.formatExperimenter((ExperimenterData)obj);
        }
        if (obj instanceof GroupData) {
            return ((GroupData)obj).getName();
        }
        if (obj instanceof TagAnnotationData) {
            return ((TagAnnotationData)obj).getTagValue();
        }
        if (obj instanceof ScreenData) {
            return ((ScreenData)obj).getName();
        }
        if (obj instanceof PlateData) {
            return ((PlateData)obj).getName();
        }
        if (obj instanceof FileAnnotationData) {
            return ((FileAnnotationData)obj).getFileName();
        }
        if (obj instanceof File) {
            return ((File)obj).getName();
        }
        if (obj instanceof FileData) {
            return ((FileData)obj).getName();
        }
        if (obj instanceof PlateAcquisitionData) {
            return ((PlateAcquisitionData)obj).getLabel();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "";
    }

    private void findNode(TreeImageDisplay node) {
        Object userObject = node.getUserObject();
        if (this.refObjects != null && this.refObjects.size() > 0) {
            if (userObject != null) {
                Iterator<DataObject> i = this.refObjects.iterator();
                Class<?> k = userObject.getClass();
                String n = this.getNodeName(userObject);
                while (i.hasNext()) {
                    DataObject object = i.next();
                    if (!object.getClass().equals(k)) continue;
                    DataObject uo = (DataObject)userObject;
                    if (this.byName) {
                        if (!n.equals(this.getNodeName(object))) continue;
                        this.nodes.add(node);
                    } else {
                        if (uo.getId() != object.getId()) continue;
                        this.nodes.add(node);
                    }
                    break;
                }
            }
        } else if (userObject != null && userObject.getClass().equals(this.type) && userObject instanceof DataObject) {
            DataObject data = (DataObject)userObject;
            if (this.ids == null) {
                this.nodes.add(node);
            } else if (this.ids.contains(data.getId())) {
                this.nodes.add(node);
            }
        }
    }

    public NodesFinder(Class<?> type) {
        this.type = type;
        this.ids = null;
        this.nodes = new HashSet<TreeImageDisplay>();
    }

    public NodesFinder(Class<?> type, List<Long> ids) {
        this.type = type;
        this.ids = ids;
        this.nodes = new HashSet<TreeImageDisplay>();
    }

    public NodesFinder(Class<?> type, long id) {
        this.type = type;
        this.ids = new ArrayList<Long>(1);
        this.ids.add(id);
        this.nodes = new HashSet<TreeImageDisplay>();
    }

    public NodesFinder(Collection<DataObject> refObjects) {
        this.type = null;
        this.refObjects = refObjects;
        this.nodes = new HashSet<TreeImageDisplay>();
    }

    public NodesFinder(DataObject refObject) {
        this.type = null;
        if (refObject == null) {
            throw new IllegalArgumentException("No object to find.");
        }
        this.byName = refObject.getId() <= 0L;
        this.refObjects = new ArrayList<DataObject>();
        this.refObjects.add(refObject);
        this.nodes = new HashSet<TreeImageDisplay>();
    }

    public Set<TreeImageDisplay> getNodes() {
        return this.nodes;
    }

    @Override
    public void visit(TreeImageNode node) {
        this.findNode(node);
    }

    @Override
    public void visit(TreeImageSet node) {
        this.findNode(node);
    }
}

