/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.browser;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FolderData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;

public class TreeViewerTranslator {
    private static TreeCheckNode transformDatasetCheckNode(DatasetData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode node = new TreeCheckNode(data, im.getIcon(45), data.getName(), true);
        return node;
    }

    private static TreeCheckNode transformImageCheckNode(ImageData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode node = new TreeCheckNode(data, im.getIcon(44), data.getName(), true);
        return node;
    }

    private static TreeImageDisplay transformDataset(DatasetData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet dataset = new TreeImageSet(data);
        Set<ImageData> images = data.getImages();
        if (images == null) {
            dataset.setNumberItems(-1L);
        } else {
            dataset.setChildrenLoaded(Boolean.TRUE);
            dataset.setNumberItems(images.size());
            for (DataObject dataObject : images) {
                ImageData child;
                if (!(dataObject instanceof ImageData) || !EditorUtil.isReadable(child = (ImageData)dataObject)) continue;
                dataset.addChildDisplay(TreeViewerTranslator.transformImage(child));
            }
        }
        TreeViewerTranslator.formatToolTipFor(dataset);
        return dataset;
    }

    private static TreeImageDisplay transformPlate(PlateData data, ScreenData screen) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet plate = new TreeImageSet(data);
        Set<PlateAcquisitionData> acquisitions = data.getPlateAcquisitions();
        if (acquisitions != null && acquisitions.size() > 0) {
            Iterator<PlateAcquisitionData> i = acquisitions.iterator();
            long id = data.getId();
            while (i.hasNext()) {
                PlateAcquisitionData pa = i.next();
                pa.setRefPlateId(id);
                plate.addChildDisplay(new TreeImageSet(pa));
            }
            plate.setChildrenLoaded(true);
        }
        TreeViewerTranslator.formatToolTipFor(plate);
        return plate;
    }

    private static TreeImageDisplay transformWell(WellData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet well = new TreeImageSet(data);
        TreeViewerTranslator.formatToolTipFor(well);
        return well;
    }

    private static TreeImageDisplay transformTag(TagAnnotationData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet tag = new TreeImageSet(data);
        TreeViewerTranslator.formatToolTipFor(tag);
        if ("openmicroscopy.org/omero/insight/tagset".equals(data.getNameSpace())) {
            Set<TagAnnotationData> tags = data.getTags();
            if (!CollectionUtils.isEmpty(tags)) {
                tag.setChildrenLoaded(true);
                Iterator<TagAnnotationData> i = tags.iterator();
                int count = 0;
                while (i.hasNext()) {
                    TagAnnotationData t = i.next();
                    if ("openmicroscopy.org/omero/insight/tagset".equals(t.getNameSpace())) continue;
                    tag.addChildDisplay(TreeViewerTranslator.transformTag(t));
                    ++count;
                }
                tag.setNumberItems(count);
                return tag;
            }
            tag.setChildrenLoaded(true);
            tag.setNumberItems(0L);
            return tag;
        }
        Set<DataObject> dataObjects = data.getDataObjects();
        if (CollectionUtils.isEmpty(dataObjects)) {
            tag.setNumberItems(-1L);
        } else {
            tag.setChildrenLoaded(true);
            tag.setNumberItems(dataObjects.size());
            for (DataObject tmp : dataObjects) {
                if (!EditorUtil.isReadable(tmp)) continue;
                if (tmp instanceof ImageData) {
                    tag.addChildDisplay(TreeViewerTranslator.transformImage((ImageData)tmp));
                    continue;
                }
                if (tmp instanceof DatasetData) {
                    tag.addChildDisplay(TreeViewerTranslator.transformDataset((DatasetData)tmp));
                    continue;
                }
                if (tmp instanceof ProjectData) {
                    ProjectData p = (ProjectData)tmp;
                    tag.addChildDisplay(TreeViewerTranslator.transformProject(p, p.getDatasets()));
                    continue;
                }
                if (tmp instanceof ScreenData) {
                    ScreenData screen = (ScreenData)tmp;
                    tag.addChildDisplay(TreeViewerTranslator.transformScreen(screen, screen.getPlates()));
                    continue;
                }
                if (!(tmp instanceof PlateData)) continue;
                PlateData plate = (PlateData)tmp;
                tag.addChildDisplay(TreeViewerTranslator.transformPlate(plate, null));
            }
        }
        return tag;
    }

    private static TreeImageDisplay transformFile(FileAnnotationData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageNode node = new TreeImageNode(data);
        TreeViewerTranslator.formatToolTipFor(node);
        return node;
    }

    private static TreeImageDisplay transformFolder(FolderData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageNode node = new TreeImageNode(data);
        return node;
    }

    private static TreeImageDisplay transformProject(ProjectData data, Set datasets) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet project = new TreeImageSet(data);
        if (datasets != null) {
            project.setChildrenLoaded(true);
            for (DatasetData child : datasets) {
                if (!EditorUtil.isReadable(child)) continue;
                project.addChildDisplay(TreeViewerTranslator.transformDataset(child));
            }
            project.setNumberItems(datasets.size());
        } else {
            project.setChildrenLoaded(Boolean.FALSE);
            project.setNumberItems(0L);
        }
        return project;
    }

    private static TreeImageDisplay transformScreen(ScreenData data, Set plates) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageSet screen = new TreeImageSet(data);
        if (plates != null) {
            screen.setChildrenLoaded(true);
            for (PlateData child : plates) {
                if (!EditorUtil.isReadable(child)) continue;
                screen.addChildDisplay(TreeViewerTranslator.transformPlate(child, data));
            }
            screen.setNumberItems(plates.size());
        } else {
            screen.setChildrenLoaded(Boolean.FALSE);
            screen.setNumberItems(0L);
        }
        return screen;
    }

    public static TreeImageDisplay transformImage(ImageData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        TreeImageNode node = new TreeImageNode(data);
        TreeViewerTranslator.formatToolTipFor(node);
        return node;
    }

    public static Set<TreeImageDisplay> transformHierarchy(Collection<Object> dataObjects) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeImageDisplay> results = new HashSet<TreeImageDisplay>(dataObjects.size());
        for (Object ho : dataObjects) {
            TreeImageDisplay child;
            if (EditorUtil.isReadable(ho)) {
                if (ho instanceof ProjectData) {
                    results.add(TreeViewerTranslator.transformProject((ProjectData)ho, ((ProjectData)ho).getDatasets()));
                } else if (ho instanceof ImageData) {
                    results.add(TreeViewerTranslator.transformImage((ImageData)ho));
                } else if (ho instanceof DatasetData) {
                    child = TreeViewerTranslator.transformDataset((DatasetData)ho);
                    results.add(child);
                } else if (ho instanceof TagAnnotationData) {
                    child = TreeViewerTranslator.transformTag((TagAnnotationData)ho);
                    results.add(child);
                } else if (ho instanceof ScreenData) {
                    results.add(TreeViewerTranslator.transformScreen((ScreenData)ho, ((ScreenData)ho).getPlates()));
                } else if (ho instanceof PlateData) {
                    results.add(TreeViewerTranslator.transformPlate((PlateData)ho, null));
                } else if (ho instanceof WellData) {
                    results.add(TreeViewerTranslator.transformWell((WellData)ho));
                } else if (ho instanceof FileAnnotationData) {
                    child = TreeViewerTranslator.transformFile((FileAnnotationData)ho);
                    results.add(child);
                } else if (ho instanceof FolderData) {
                    child = TreeViewerTranslator.transformFolder((FolderData)ho);
                    results.add(child);
                }
            } else if (ho instanceof ExperimenterData) {
                child = TreeViewerTranslator.transformExperimenter((ExperimenterData)ho);
                results.add(child);
            }
            if (!(ho instanceof GroupData)) continue;
            child = TreeViewerTranslator.transformGroup((GroupData)ho, false);
            results.add(child);
        }
        return results;
    }

    public static Set refreshHierarchy(Map nodes, Map expandedTopNodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeImageDisplay> results = new HashSet<TreeImageDisplay>(nodes.size());
        Set set = nodes.entrySet();
        Iterator i = set.iterator();
        List expanded = null;
        while (i.hasNext()) {
            TreeImageDisplay display;
            DataObject ho;
            Map.Entry entry = i.next();
            Object ob = entry.getKey();
            if (ob instanceof DataObject) {
                Set r;
                ho = (DataObject)ob;
                if (!EditorUtil.isReadable(ho)) continue;
                if (ho instanceof ProjectData) {
                    if (expandedTopNodes != null) {
                        expanded = (List)expandedTopNodes.get(ProjectData.class);
                    }
                    display = TreeViewerTranslator.transformProject((ProjectData)ho, (Set)entry.getValue());
                    if (expanded != null) {
                        display.setExpanded(expanded.contains(ho.getId()));
                    }
                    results.add(display);
                    continue;
                }
                if (ho instanceof DatasetData) {
                    if (expandedTopNodes != null) {
                        expanded = (List)expandedTopNodes.get(DatasetData.class);
                    }
                    r = (Set)entry.getValue();
                    for (DataObject element : r) {
                        display = TreeViewerTranslator.transformDataset(element);
                        if (expanded != null) {
                            display.setExpanded(expanded.contains(ho.getId()));
                        }
                        results.add(display);
                    }
                    continue;
                }
                if (ho instanceof TagAnnotationData) {
                    if (expandedTopNodes != null) {
                        expanded = (List)expandedTopNodes.get(TagAnnotationData.class);
                    }
                    r = (Set)entry.getValue();
                    for (DataObject element : r) {
                        display = TreeViewerTranslator.transformTag((TagAnnotationData)element);
                        if (expanded != null) {
                            display.setExpanded(expanded.contains(ho.getId()));
                        }
                        results.add(display);
                    }
                    continue;
                }
                if (ho instanceof ScreenData) {
                    if (expandedTopNodes != null) {
                        expanded = (List)expandedTopNodes.get(ScreenData.class);
                    }
                    display = TreeViewerTranslator.transformScreen((ScreenData)ho, ((ScreenData)ho).getPlates());
                    if (expanded != null) {
                        display.setExpanded(expanded.contains(ho.getId()));
                    }
                    results.add(display);
                    continue;
                }
                if (!(ho instanceof PlateData)) continue;
                display = TreeViewerTranslator.transformPlate((PlateData)ho, null);
                if (expanded != null) {
                    display.setExpanded(expanded.contains(ho.getId()));
                }
                results.add(display);
                continue;
            }
            if (!(ob instanceof TreeImageSet)) continue;
            display = (TreeImageSet)ob;
            Collection values = (Collection)entry.getValue();
            Iterator j = values.iterator();
            display.setExpanded(true);
            while (j.hasNext()) {
                ho = (DataObject)j.next();
                if (!EditorUtil.isReadable(ho)) continue;
                if (ho instanceof TagAnnotationData) {
                    display.addChildDisplay(TreeViewerTranslator.transformTag((TagAnnotationData)ho));
                    continue;
                }
                if (!(ho instanceof ImageData)) continue;
                display.addChildDisplay(TreeViewerTranslator.transformImage((ImageData)ho));
            }
            results.add(display);
        }
        return results;
    }

    public static TreeImageDisplay transformDataObject(DataObject object) {
        if (object == null) {
            throw new IllegalArgumentException("No object.");
        }
        if (!EditorUtil.isReadable(object)) {
            throw new IllegalArgumentException("Data object not readable.");
        }
        if (object instanceof ProjectData) {
            return TreeViewerTranslator.transformProject((ProjectData)object, ((ProjectData)object).getDatasets());
        }
        if (object instanceof DatasetData) {
            return TreeViewerTranslator.transformDataset((DatasetData)object);
        }
        if (object instanceof ImageData) {
            return TreeViewerTranslator.transformImage((ImageData)object);
        }
        if (object instanceof ScreenData) {
            return TreeViewerTranslator.transformScreen((ScreenData)object, ((ScreenData)object).getPlates());
        }
        if (object instanceof PlateData) {
            return TreeViewerTranslator.transformPlate((PlateData)object, null);
        }
        if (object instanceof TagAnnotationData) {
            return TreeViewerTranslator.transformTag((TagAnnotationData)object);
        }
        if (object instanceof FolderData) {
            return TreeViewerTranslator.transformFolder((FolderData)object);
        }
        throw new IllegalArgumentException("Data Type not supported.");
    }

    public static Set transformDataObjectsCheckNode(Set dataObjects) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeCheckNode> results = new HashSet<TreeCheckNode>(dataObjects.size());
        for (DataObject ho : dataObjects) {
            if (!(ho instanceof DatasetData)) continue;
            results.add(TreeViewerTranslator.transformDatasetCheckNode((DatasetData)ho));
        }
        return results;
    }

    public static Set transformIntoCheckNodes(Set paths) {
        if (paths == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeCheckNode> results = new HashSet<TreeCheckNode>();
        for (DataObject ho : paths) {
            if (ho instanceof DatasetData) {
                results.add(TreeViewerTranslator.transformDatasetCheckNode((DatasetData)ho));
                continue;
            }
            if (!(ho instanceof ImageData)) continue;
            results.add(TreeViewerTranslator.transformImageCheckNode((ImageData)ho));
        }
        return results;
    }

    public static boolean isVisible(DataObject data, ExperimenterData loggedUser) {
        if (data == null) {
            return false;
        }
        return data instanceof ExperimenterData || data instanceof GroupData;
    }

    public static Map<Integer, Set> refreshFolderHierarchy(Map nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashMap<Integer, Set> r = new HashMap<Integer, Set>(nodes.size());
        Set set = nodes.entrySet();
        for (Map.Entry entry : set) {
            HashSet<TreeImageDisplay> converted;
            Collection results;
            TreeImageDisplay node = (TreeImageDisplay)entry.getKey();
            if (node instanceof TreeImageTimeSet) {
                results = (Collection)entry.getValue();
                converted = new HashSet<TreeImageDisplay>(results.size());
                for (DataObject ho : results) {
                    if (!EditorUtil.isReadable(ho)) continue;
                    converted.add(TreeViewerTranslator.transformImage((ImageData)ho));
                }
                r.put(((TreeImageTimeSet)node).getIndex(), converted);
                continue;
            }
            if (!(node instanceof TreeFileSet)) continue;
            results = (Collection)entry.getValue();
            converted = new HashSet(results.size());
            for (DataObject ho : results) {
                if (!EditorUtil.isReadable(ho)) continue;
                converted.add(TreeViewerTranslator.transformFile((FileAnnotationData)ho));
            }
            r.put(((TreeFileSet)node).getType(), converted);
        }
        return r;
    }

    public static Timestamp getAcquisitionTime(ImageData image) {
        if (image == null) {
            return null;
        }
        Timestamp date = null;
        try {
            date = image.getAcquisitionDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static Set transformGroups(Collection groups) {
        HashSet<TreeImageSet> nodes = new HashSet<TreeImageSet>();
        if (groups == null) {
            return nodes;
        }
        for (GroupData g : groups) {
            TreeImageSet n = TreeViewerTranslator.transformGroup(g);
            if (n == null) continue;
            nodes.add(n);
        }
        return nodes;
    }

    public static TreeImageSet transformGroup(GroupData group) {
        return TreeViewerTranslator.transformGroup(group, true);
    }

    public static TreeImageSet transformGroup(GroupData group, boolean withExperimenters) {
        if (group == null) {
            return null;
        }
        TreeImageSet n = new TreeImageSet(group);
        Set<ExperimenterData> l = group.getExperimenters();
        if (withExperimenters && CollectionUtils.isNotEmpty(l)) {
            n.setChildrenLoaded(true);
            Iterator j = l.iterator();
            while (j.hasNext()) {
                n.addChildDisplay(new TreeImageNode(j.next()));
            }
            n.setNumberItems(l.size());
        } else {
            n.setNumberItems(0L);
        }
        TreeViewerTranslator.formatToolTipFor(n);
        return n;
    }

    public static TreeImageNode transformExperimenter(ExperimenterData exp) {
        TreeImageNode node = new TreeImageNode(exp);
        node.setToolTip("Login Name: " + exp.getUserName());
        return node;
    }

    public static Set transformExperimenters(Collection list) {
        HashSet<TreeImageNode> nodes = new HashSet<TreeImageNode>();
        if (list == null) {
            return nodes;
        }
        for (Object ho : list) {
            if (!(ho instanceof ExperimenterData)) continue;
            nodes.add(TreeViewerTranslator.transformExperimenter((ExperimenterData)ho));
        }
        return nodes;
    }

    public static void formatToolTipFor(TreeImageDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        Object uo = node.getUserObject();
        List<String> l = null;
        String s = "";
        if (uo instanceof ImageData) {
            l = EditorUtil.formatObjectTooltip((ImageData)uo);
            s = UIUtilities.formatString(((ImageData)uo).getName(), -1);
        } else if (uo instanceof GroupData) {
            GroupData group = (GroupData)uo;
            switch (group.getPermissions().getPermissionsLevel()) {
                case 0: {
                    node.setToolTip("Private Group");
                    break;
                }
                case 1: {
                    node.setToolTip("Collaborators can only read your data.");
                    break;
                }
                case 2: {
                    node.setToolTip("Collaborators can read and annotate your data.");
                    break;
                }
                case 3: {
                    node.setToolTip("Collaborators can read, annotate, delete, etc., your data.");
                    break;
                }
                case 4: {
                    node.setToolTip("Public");
                    break;
                }
                case 5: {
                    node.setToolTip("Public");
                }
            }
            return;
        }
        if (CollectionUtils.isEmpty(l)) {
            node.setToolTip(s);
        } else {
            ArrayList<String> ll = new ArrayList<String>();
            ll.add(s);
            ll.addAll(l);
            node.setToolTip(UIUtilities.formatToolTipText(ll));
        }
    }
}

