/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FancyTextField
extends JTextField {
    public static final String EDIT_PROPERTY = "EDIT_PROPERTY";
    public static final String SUBMIT_PROPERTY = "SUBMIT_PROPERTY";
    private final String DEFAULT_FILTER_TEXT;

    public FancyTextField() {
        this.DEFAULT_FILTER_TEXT = "";
        this.init();
    }

    public FancyTextField(int columns) {
        super(columns);
        this.DEFAULT_FILTER_TEXT = "";
        this.init();
    }

    public FancyTextField(String text, int columns) {
        super(text, columns);
        this.DEFAULT_FILTER_TEXT = text;
        this.init();
    }

    public FancyTextField(String text) {
        super(text);
        this.DEFAULT_FILTER_TEXT = text;
        this.init();
    }

    private void init() {
        this.setText(this.DEFAULT_FILTER_TEXT);
        final Font defaultFont = this.getFont();
        final Font italicFont = this.getFont().deriveFont(2);
        this.setFont(italicFont);
        this.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (FancyTextField.this.getText().trim().equals("")) {
                    FancyTextField.this.setText(FancyTextField.this.DEFAULT_FILTER_TEXT);
                    FancyTextField.this.setFont(italicFont);
                    FancyTextField.this.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (FancyTextField.this.getText().equals(FancyTextField.this.DEFAULT_FILTER_TEXT)) {
                    FancyTextField.this.setText("");
                } else {
                    FancyTextField.this.selectAll();
                }
                FancyTextField.this.setFont(defaultFont);
                FancyTextField.this.setForeground(Color.BLACK);
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!FancyTextField.this.getText().equals(FancyTextField.this.DEFAULT_FILTER_TEXT)) {
                    FancyTextField.this.firePropertyChange(FancyTextField.EDIT_PROPERTY, null, FancyTextField.this.getText());
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!FancyTextField.this.getText().equals(FancyTextField.this.DEFAULT_FILTER_TEXT)) {
                    FancyTextField.this.firePropertyChange(FancyTextField.EDIT_PROPERTY, null, FancyTextField.this.getText());
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!FancyTextField.this.getText().equals(FancyTextField.this.DEFAULT_FILTER_TEXT)) {
                    FancyTextField.this.firePropertyChange(FancyTextField.EDIT_PROPERTY, null, FancyTextField.this.getText());
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!FancyTextField.this.getText().equals(FancyTextField.this.DEFAULT_FILTER_TEXT)) {
                    switch (e.getKeyCode()) {
                        case 10: {
                            FancyTextField.this.firePropertyChange(FancyTextField.SUBMIT_PROPERTY, null, FancyTextField.this.getText());
                        }
                    }
                }
            }
        });
    }
}

