/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractProjectAction;

public class ProjectPropertyAction
extends AbstractProjectAction {
    private String propertyName;
    private Class[] parameterClass;
    private Object propertyValue;
    private String setterName;
    private String getterName;
    private PropertyChangeListener projectListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == ProjectPropertyAction.this.propertyName) {
                ProjectPropertyAction.this.updateSelectedState();
            }
        }
    };

    public ProjectPropertyAction(Application app, String propertyName, Object propertyValue) {
        this(app, propertyName, propertyValue.getClass(), propertyValue);
    }

    public ProjectPropertyAction(Application app, String propertyName, Class propertyClass, Object propertyValue) {
        super(app);
        this.propertyName = propertyName;
        this.parameterClass = new Class[]{propertyClass};
        this.propertyValue = propertyValue;
        this.setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        this.getterName = (propertyClass == Boolean.TYPE || propertyClass == Boolean.class ? "is" : "get") + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        this.updateSelectedState();
    }

    public void actionPerformed(ActionEvent evt) {
        Project p = this.getCurrentProject();
        try {
            p.getClass().getMethod(this.setterName, this.parameterClass).invoke((Object)p, this.propertyValue);
        }
        catch (Throwable e) {
            InternalError error = new InternalError("Method invocation failed");
            error.initCause(e);
            throw error;
        }
    }

    protected void installProjectListeners(Project p) {
        super.installProjectListeners(p);
        p.addPropertyChangeListener(this.projectListener);
        this.updateSelectedState();
    }

    protected void uninstallProjectListeners(Project p) {
        super.uninstallProjectListeners(p);
        p.removePropertyChangeListener(this.projectListener);
    }

    private void updateSelectedState() {
        boolean isSelected = false;
        Project p = this.getCurrentProject();
        if (p != null) {
            try {
                Object value = p.getClass().getMethod(this.getterName, null).invoke((Object)p, new Object[0]);
                isSelected = value == this.propertyValue || value != null && this.propertyValue != null && value.equals(this.propertyValue);
            }
            catch (Throwable e) {
                InternalError error = new InternalError("Method invocation failed");
                error.initCause(e);
                throw error;
            }
        }
        this.putValue("selected", isSelected);
    }
}

