/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDoubleAttributeSlider
extends JSlider {
    private double scaleFactor = 1.0;
    private DrawingEditor editor;
    private AttributeKey<Double> attributeKey;
    private boolean isMultipleValues;
    protected ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
    private int isUpdatingSlider = 0;
    private LinkedList<Object> attributeRestoreData = new LinkedList();
    private PropertyChangeListener viewEventHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "enabled") {
                JDoubleAttributeSlider.this.updateEnabledState();
            }
        }
    };
    private EditorEventHandler eventHandler = new EditorEventHandler();
    private ChangeHandler changeHandler = new ChangeHandler();

    public JDoubleAttributeSlider() {
        this(null, null);
    }

    public JDoubleAttributeSlider(int orientation, int min, int max, int value) {
        super(orientation, min, max, value);
        this.getModel().addChangeListener(this.changeHandler);
    }

    public JDoubleAttributeSlider(DrawingEditor editor, AttributeKey<Double> attributeKey) {
        this.initComponents();
        this.attributeKey = attributeKey;
        this.setEditor(editor);
        this.setModel(new DefaultBoundedRangeModel());
    }

    public void setAttributeKey(AttributeKey<Double> newValue) {
        this.attributeKey = newValue;
    }

    public void setEditor(DrawingEditor editor) {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
            if (this.getView() != null) {
                this.getView().removeFigureSelectionListener(this.eventHandler);
            }
        }
        this.editor = editor;
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(this.eventHandler);
            if (this.getView() != null) {
                this.getView().addFigureSelectionListener(this.eventHandler);
            }
            this.updateEnabledState();
            this.updateSlider();
        }
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    protected DrawingView getView() {
        return this.editor == null ? null : this.editor.getActiveView();
    }

    @Override
    public void setModel(BoundedRangeModel brm) {
        BoundedRangeModel model = this.getModel();
        if (model != null) {
            model.removeChangeListener(this.changeHandler);
        }
        super.setModel(brm);
        if (brm != null) {
            brm.addChangeListener(this.changeHandler);
        }
    }

    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled() && this.getView().getSelectionCount() > 0);
        } else {
            this.setEnabled(false);
        }
    }

    public void setScaleFactor(double newValue) {
        this.scaleFactor = newValue;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    protected void updateSlider() {
        if (this.isUpdatingSlider++ == 0) {
            if (this.getView() == null || this.attributeKey == null) {
                this.setValue(0);
            } else {
                Double sliderValue = null;
                boolean isFirst = true;
                this.isMultipleValues = false;
                for (Figure f : this.getView().getSelectedFigures()) {
                    if (isFirst) {
                        isFirst = false;
                        sliderValue = this.attributeKey.get(f);
                        continue;
                    }
                    Double figureValue = this.attributeKey.get(f);
                    if (figureValue == sliderValue || figureValue != null && sliderValue != null && figureValue.equals(sliderValue)) continue;
                    sliderValue = null;
                    this.isMultipleValues = true;
                }
                if (sliderValue != null) {
                    this.setValue((int)(sliderValue * this.scaleFactor));
                }
            }
            this.repaint();
        }
        --this.isUpdatingSlider;
    }

    private void updateFigures() {
        if (this.isUpdatingSlider++ == 0) {
            double value = (double)this.getValue() / this.scaleFactor;
            if (this.getView() != null && this.attributeKey != null) {
                if (this.attributeRestoreData.isEmpty()) {
                    for (Figure f : this.getView().getSelectedFigures()) {
                        this.attributeRestoreData.add(f.getAttributesRestoreData());
                        this.attributeKey.set(f, (Double)value);
                    }
                } else {
                    for (Figure f : this.getView().getSelectedFigures()) {
                        this.attributeKey.set(f, (Double)value);
                    }
                }
            }
            if (this.editor != null) {
                this.editor.setDefaultAttribute(this.attributeKey, value);
            }
            if (!this.getModel().getValueIsAdjusting()) {
                final LinkedList<Figure> editedFigures = new LinkedList<Figure>(this.getView().getSelectedFigures());
                final LinkedList<Object> editUndoData = new LinkedList<Object>(this.attributeRestoreData);
                final double editRedoValue = value;
                AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                    public String getPresentationName() {
                        return JDoubleAttributeSlider.this.labels.getString(JDoubleAttributeSlider.this.attributeKey.getKey());
                    }

                    public void undo() throws CannotRedoException {
                        super.undo();
                        Iterator di = editUndoData.iterator();
                        for (Figure f : editedFigures) {
                            f.willChange();
                            f.restoreAttributesTo(di.next());
                            f.changed();
                        }
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        for (Figure f : editedFigures) {
                            f.willChange();
                            JDoubleAttributeSlider.this.attributeKey.basicSet(f, editRedoValue);
                            f.changed();
                        }
                    }
                };
                this.getView().getDrawing().fireUndoableEditHappened(edit);
            }
        }
        --this.isUpdatingSlider;
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
            if (this.editor.getActiveView() != null) {
                this.editor.getActiveView().removeFigureSelectionListener(this.eventHandler);
            }
        }
        this.editor = null;
    }

    private void initComponents() {
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        public void stateChanged(ChangeEvent evt) {
            JDoubleAttributeSlider.this.updateFigures();
        }
    }

    private class EditorEventHandler
    implements PropertyChangeListener,
    FigureSelectionListener {
        private EditorEventHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "activeView") {
                DrawingView view;
                if (evt.getOldValue() != null) {
                    view = (DrawingView)evt.getOldValue();
                    view.removeFigureSelectionListener(this);
                    view.removePropertyChangeListener(JDoubleAttributeSlider.this.viewEventHandler);
                }
                if (evt.getNewValue() != null) {
                    view = (DrawingView)evt.getNewValue();
                    view.addFigureSelectionListener(this);
                    view.addPropertyChangeListener(JDoubleAttributeSlider.this.viewEventHandler);
                }
                JDoubleAttributeSlider.this.updateEnabledState();
                JDoubleAttributeSlider.this.updateSlider();
            } else if (name.equals(JDoubleAttributeSlider.this.attributeKey.getKey())) {
                JDoubleAttributeSlider.this.updateSlider();
            }
        }

        public void selectionChanged(FigureSelectionEvent evt) {
            JDoubleAttributeSlider.this.updateEnabledState();
            JDoubleAttributeSlider.this.updateSlider();
        }
    }
}

