/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractAttributedCompositeFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.geom.Shapes;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.samples.svg.figures.SVGPathOutlineHandle;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGPathFigure
extends AbstractAttributedCompositeFigure
implements SVGFigure {
    private GeneralPath cachedPath;
    private Rectangle2D.Double cachedDrawingArea;
    private static final boolean DEBUG = false;

    public SVGPathFigure() {
        this.add(new SVGBezierFigure());
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    public void draw(Graphics2D g) {
        double opacity = SVGAttributeKeys.OPACITY.get(this);
        if ((opacity = Math.min(Math.max(0.0, opacity), 1.0)) != 0.0) {
            if (opacity != 1.0) {
                Rectangle2D.Double drawingArea = this.getDrawingArea();
                Rectangle clipBounds = g.getClipBounds();
                if (clipBounds != null) {
                    Rectangle2D.intersect(drawingArea, clipBounds, drawingArea);
                }
                if (!drawingArea.isEmpty()) {
                    BufferedImage buf = new BufferedImage(Math.max(1, (int)((2.0 + drawingArea.width) * g.getTransform().getScaleX())), Math.max(1, (int)((2.0 + drawingArea.height) * g.getTransform().getScaleY())), 2);
                    Graphics2D gr = buf.createGraphics();
                    gr.scale(g.getTransform().getScaleX(), g.getTransform().getScaleY());
                    gr.translate((int)(-drawingArea.x), (int)(-drawingArea.y));
                    gr.setRenderingHints(g.getRenderingHints());
                    this.drawFigure(gr);
                    gr.dispose();
                    Composite savedComposite = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, (float)opacity));
                    g.drawImage(buf, (int)drawingArea.x, (int)drawingArea.y, 2 + (int)drawingArea.width, 2 + (int)drawingArea.height, null);
                    g.setComposite(savedComposite);
                }
            } else {
                this.drawFigure(g);
            }
        }
    }

    @Override
    public void drawFigure(Graphics2D g) {
        Paint paint;
        AffineTransform savedTransform = null;
        if (AttributeKeys.TRANSFORM.get(this) != null) {
            savedTransform = g.getTransform();
            g.transform(AttributeKeys.TRANSFORM.get(this));
        }
        if ((paint = SVGAttributeKeys.getFillPaint(this)) != null) {
            g.setPaint(paint);
            this.drawFill(g);
        }
        if ((paint = SVGAttributeKeys.getStrokePaint(this)) != null) {
            g.setPaint(paint);
            g.setStroke(SVGAttributeKeys.getStroke(this));
            this.drawStroke(g);
        }
        if (AttributeKeys.TRANSFORM.get(this) != null) {
            g.setTransform(savedTransform);
        }
    }

    @Override
    public void drawFill(Graphics2D g) {
        g.fill(this.getPath());
    }

    @Override
    public void drawStroke(Graphics2D g) {
        g.draw(this.getPath());
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedPath = null;
        this.cachedDrawingArea = null;
    }

    protected GeneralPath getPath() {
        if (this.cachedPath == null) {
            this.cachedPath = new GeneralPath();
            this.cachedPath.setWindingRule(AttributeKeys.WINDING_RULE.get(this) == AttributeKeys.WindingRule.EVEN_ODD ? 0 : 1);
            for (Figure child : this.getChildren()) {
                SVGBezierFigure b = (SVGBezierFigure)child;
                this.cachedPath.append(b.getBezierPath(), false);
            }
        }
        return this.cachedPath;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            Rectangle2D rx;
            double strokeTotalWidth = AttributeKeys.getStrokeTotalWidth(this);
            double width = strokeTotalWidth / 2.0;
            if (AttributeKeys.STROKE_JOIN.get(this) == 0) {
                width *= AttributeKeys.STROKE_MITER_LIMIT.get(this).doubleValue();
            } else if (AttributeKeys.STROKE_CAP.get(this) != 0) {
                width += strokeTotalWidth * 2.0;
            }
            GeneralPath gp = this.getPath();
            Rectangle2D strokeRect = new Rectangle2D.Double(0.0, 0.0, width, width);
            if (AttributeKeys.TRANSFORM.get(this) != null) {
                gp = (GeneralPath)gp.clone();
                gp.transform(AttributeKeys.TRANSFORM.get(this));
                strokeRect = AttributeKeys.TRANSFORM.get(this).createTransformedShape(strokeRect).getBounds2D();
            }
            Rectangle2D.Double r = (rx = gp.getBounds2D()) instanceof Rectangle2D.Double ? (Rectangle2D.Double)rx : new Rectangle2D.Double(rx.getX(), rx.getY(), rx.getWidth(), rx.getHeight());
            Geom.grow(r, ((RectangularShape)strokeRect).getWidth(), ((RectangularShape)strokeRect).getHeight());
            this.cachedDrawingArea = r;
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public final void write(DOMOutput out) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableOutput to write this Figure.");
    }

    @Override
    public final void read(DOMInput in) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableInput to read this Figure.");
    }

    @Override
    public boolean contains(Point2D.Double p) {
        this.getPath();
        if (AttributeKeys.TRANSFORM.get(this) != null) {
            try {
                p = (Point2D.Double)AttributeKeys.TRANSFORM.get(this).inverseTransform(p, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        boolean isClosed = AttributeKeys.CLOSED.get(this.getChild(0));
        double tolerance = Math.max(2.0, AttributeKeys.getStrokeTotalWidth(this) / 2.0);
        if (isClosed || AttributeKeys.FILL_COLOR.get(this) != null) {
            if (this.getPath().contains(p)) {
                return true;
            }
            double grow = AttributeKeys.getPerpendicularHitGrowth(this) * 2.0;
            GrowStroke gs = new GrowStroke((float)grow, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT.get(this)));
            if (gs.createStrokedShape(this.getPath()).contains(p)) {
                return true;
            }
            if (isClosed) {
                return false;
            }
        }
        return !isClosed && Shapes.outlineContains(this.getPath(), p, tolerance);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (this.getChildCount() == 1 && this.getChild(0).getNodeCount() <= 2) {
            SVGBezierFigure b = this.getChild(0);
            b.setBounds(anchor, lead);
            this.invalidate();
        } else {
            super.setBounds(anchor, lead);
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        if (AttributeKeys.TRANSFORM.get(this) != null || (tx.getType() & 1) != tx.getType()) {
            if (AttributeKeys.TRANSFORM.get(this) == null) {
                AttributeKeys.TRANSFORM.basicSetClone(this, tx);
            } else {
                AffineTransform t = AttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                AttributeKeys.TRANSFORM.basicSet(this, t);
            }
        } else {
            Gradient g;
            for (Figure f : this.getChildren()) {
                f.transform(tx);
            }
            if (SVGAttributeKeys.FILL_GRADIENT.get(this) != null && !SVGAttributeKeys.FILL_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                g.transform(tx);
                SVGAttributeKeys.FILL_GRADIENT.basicSet(this, g);
            }
            if (SVGAttributeKeys.STROKE_GRADIENT.get(this) != null && !SVGAttributeKeys.STROKE_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                g.transform(tx);
                SVGAttributeKeys.STROKE_GRADIENT.basicSet(this, g);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        this.invalidate();
        Object[] restoreData = (Object[])geometry;
        ArrayList paths = (ArrayList)restoreData[0];
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).setBezierPath((BezierPath)paths.get(i));
        }
        AttributeKeys.TRANSFORM.basicSetClone(this, (AffineTransform)restoreData[1]);
        SVGAttributeKeys.FILL_GRADIENT.basicSetClone(this, (Gradient)restoreData[2]);
        SVGAttributeKeys.STROKE_GRADIENT.basicSetClone(this, (Gradient)restoreData[3]);
    }

    @Override
    public Object getTransformRestoreData() {
        ArrayList<BezierPath> paths = new ArrayList<BezierPath>(this.getChildCount());
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            paths.add(this.getChild(i).getBezierPath());
        }
        return new Object[]{paths, AttributeKeys.TRANSFORM.getClone(this), SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public void setAttribute(AttributeKey key, Object newValue) {
        super.setAttribute(key, newValue);
        this.invalidate();
    }

    @Override
    protected void setAttributeOnChildren(AttributeKey key, Object newValue) {
    }

    @Override
    public boolean isEmpty() {
        for (Figure child : this.getChildren()) {
            SVGBezierFigure b = (SVGBezierFigure)child;
            if (b.getNodeCount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case 0: {
                handles.add(new SVGPathOutlineHandle(this));
                for (Figure child : this.getChildren()) {
                    handles.addAll(((SVGBezierFigure)child).createHandles(this, detailLevel));
                }
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        final ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels");
        LinkedList<Action> actions = new LinkedList<Action>();
        if (AttributeKeys.TRANSFORM.get(this) != null) {
            actions.add(new AbstractAction(labels.getString("removeTransform")){

                public void actionPerformed(ActionEvent evt) {
                    ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels");
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.fireUndoableEditHappened(AttributeKeys.TRANSFORM.setUndoable(SVGPathFigure.this, null, labels));
                    SVGPathFigure.this.changed();
                }
            });
            actions.add(new AbstractAction(labels.getString("flattenTransform")){

                public void actionPerformed(ActionEvent evt) {
                    final Object restoreData = SVGPathFigure.this.getTransformRestoreData();
                    AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                        public String getPresentationName() {
                            return labels.getString("flattenTransform");
                        }

                        public void undo() throws CannotUndoException {
                            super.undo();
                            SVGPathFigure.this.willChange();
                            SVGPathFigure.this.restoreTransformTo(restoreData);
                            SVGPathFigure.this.changed();
                        }

                        public void redo() throws CannotRedoException {
                            super.redo();
                            SVGPathFigure.this.willChange();
                            SVGPathFigure.this.restoreTransformTo(restoreData);
                            SVGPathFigure.this.flattenTransform();
                            SVGPathFigure.this.changed();
                        }
                    };
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.flattenTransform();
                    SVGPathFigure.this.changed();
                    SVGPathFigure.this.fireUndoableEditHappened(edit);
                }
            });
        }
        actions.add(new AbstractAction(labels.getString("closePath")){

            public void actionPerformed(ActionEvent evt) {
                for (Figure child : SVGPathFigure.this.getChildren()) {
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.getDrawing().fireUndoableEditHappened(AttributeKeys.CLOSED.setUndoable(child, true, labels));
                    SVGPathFigure.this.changed();
                }
            }
        });
        actions.add(new AbstractAction(labels.getString("openPath")){

            public void actionPerformed(ActionEvent evt) {
                for (Figure child : SVGPathFigure.this.getChildren()) {
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.getDrawing().fireUndoableEditHappened(AttributeKeys.CLOSED.setUndoable(child, false, labels));
                    SVGPathFigure.this.changed();
                }
            }
        });
        actions.add(new AbstractAction(labels.getString("windingEvenOdd")){

            public void actionPerformed(ActionEvent evt) {
                SVGPathFigure.this.willChange();
                SVGPathFigure.this.getDrawing().fireUndoableEditHappened(AttributeKeys.WINDING_RULE.setUndoable(SVGPathFigure.this, AttributeKeys.WindingRule.EVEN_ODD, labels));
                SVGPathFigure.this.changed();
            }
        });
        actions.add(new AbstractAction(labels.getString("windingNonZero")){

            public void actionPerformed(ActionEvent evt) {
                AttributeKeys.WINDING_RULE.set(SVGPathFigure.this, AttributeKeys.WindingRule.NON_ZERO);
                SVGPathFigure.this.getDrawing().fireUndoableEditHappened(AttributeKeys.WINDING_RULE.setUndoable(SVGPathFigure.this, AttributeKeys.WindingRule.EVEN_ODD, labels));
            }
        });
        return actions;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return null;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        if (evt.getClickCount() == 2 && view.getHandleDetailLevel() % 2 == 0) {
            for (Figure child : this.getChildren()) {
                SVGBezierFigure bf = (SVGBezierFigure)child;
                int index = bf.getBezierPath().findSegment(p, (float)(5.0 / view.getScaleFactor()));
                if (index == -1) continue;
                bf.handleMouseClick(p, evt, view);
                evt.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(int index, Figure figure) {
        super.add(index, (SVGBezierFigure)figure);
    }

    @Override
    public SVGBezierFigure getChild(int index) {
        return (SVGBezierFigure)super.getChild(index);
    }

    @Override
    public SVGPathFigure clone() {
        SVGPathFigure that = (SVGPathFigure)super.clone();
        return that;
    }

    public void flattenTransform() {
        this.willChange();
        AffineTransform tx = AttributeKeys.TRANSFORM.get(this);
        if (tx != null) {
            for (Figure child : this.getChildren()) {
                ((SVGBezierFigure)child).transform(tx);
                ((SVGBezierFigure)child).flattenTransform();
            }
        }
        AttributeKeys.TRANSFORM.basicSet(this, null);
        this.changed();
    }
}

