/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.io.File;

public class TIFFFilter {
    public static final String MIMETYPE = "image/tiff";
    public static final String TIFF = "tiff";
    public static final String TIF = "tif";
    public static final String TF_2 = "tf2";
    public static final String TF_8 = "tf8";
    public static final String BTF = "btf";
    public static final String[] extensions = new String[5];
    private static final String description;

    public String getMIMEType() {
        return MIMETYPE;
    }

    public String getExtension() {
        return TIFF;
    }

    public String getDescription() {
        return description;
    }

    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    private boolean isSupported(String name, String[] extensions) {
        if (name == null || extensions == null) {
            return false;
        }
        String value = name.toLowerCase();
        for (int i = 0; i < extensions.length; ++i) {
            if (!value.endsWith("." + extensions[i])) continue;
            return true;
        }
        return false;
    }

    static {
        TIFFFilter.extensions[0] = TIFF;
        TIFFFilter.extensions[1] = TIF;
        TIFFFilter.extensions[2] = TF_2;
        TIFFFilter.extensions[3] = TF_8;
        TIFFFilter.extensions[4] = BTF;
        StringBuffer s = new StringBuffer();
        s.append("Tagged Image File Format (");
        for (int i = 0; i < extensions.length; ++i) {
            s.append("*." + extensions[i]);
            if (i >= extensions.length - 1) continue;
            s.append(", ");
        }
        s.append(")");
        description = s.toString();
    }
}

