/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j.spi;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.ini4j.Config;
import org.ini4j.IniHandler;
import org.ini4j.spi.EscapeTool;
import org.ini4j.spi.ServiceFinder;

public class IniFormatter
implements IniHandler {
    private static final char OPERATOR = '=';
    private static final char SPACE = ' ';
    private Config _config = Config.getGlobal();
    private PrintWriter _output;

    public static IniFormatter newInstance(Writer out) {
        IniFormatter instance = IniFormatter.newInstance();
        instance.setOutput(new PrintWriter(out));
        return instance;
    }

    public static IniFormatter newInstance(OutputStream out) {
        return IniFormatter.newInstance(new OutputStreamWriter(out));
    }

    public static IniFormatter newInstance(Writer out, Config config) {
        IniFormatter instance = IniFormatter.newInstance(out);
        instance.setConfig(config);
        return instance;
    }

    public static IniFormatter newInstance(OutputStream out, Config config) {
        return IniFormatter.newInstance(new OutputStreamWriter(out), config);
    }

    public Config getConfig() {
        return this._config;
    }

    public void endIni() {
        this.getOutput().flush();
    }

    public void endSection() {
        this.getOutput().println();
    }

    public void handleOption(String optionName, String optionValue) {
        if (this.getConfig().isStrictOperator()) {
            if (this.getConfig().isEmptyOption() || optionValue != null) {
                this.getOutput().print(this.escape(optionName));
                this.getOutput().print('=');
            }
            if (optionValue != null) {
                this.getOutput().print(this.escape(optionValue));
            }
            if (this.getConfig().isEmptyOption() || optionValue != null) {
                this.getOutput().println();
            }
        } else {
            String value;
            String string = value = optionValue == null && this.getConfig().isEmptyOption() ? "" : optionValue;
            if (value != null) {
                this.getOutput().print(this.escape(optionName));
                this.getOutput().print(' ');
                this.getOutput().print('=');
                this.getOutput().print(' ');
                this.getOutput().println(this.escape(value));
            }
        }
    }

    public void startIni() {
    }

    public void startSection(String sectionName) {
        this.getOutput().print('[');
        this.getOutput().print(this.escape(sectionName));
        this.getOutput().println(']');
    }

    protected static IniFormatter newInstance() {
        return ServiceFinder.findService(IniFormatter.class);
    }

    protected void setConfig(Config value) {
        this._config = value;
    }

    protected PrintWriter getOutput() {
        return this._output;
    }

    protected void setOutput(PrintWriter value) {
        this._output = value;
    }

    protected String escape(String input) {
        return this.getConfig().isEscape() ? EscapeTool.getInstance().escape(input) : input;
    }
}

