/*
 * Decompiled with CFR 0.152.
 */
package ome.model.enums;

import java.util.HashMap;
import java.util.Map;
import ome.model.units.UnitEnum;

public enum UnitsFrequency implements UnitEnum
{
    YOTTAHERTZ("YHz"),
    ZETTAHERTZ("ZHz"),
    EXAHERTZ("EHz"),
    PETAHERTZ("PHz"),
    TERAHERTZ("THz"),
    GIGAHERTZ("GHz"),
    MEGAHERTZ("MHz"),
    KILOHERTZ("kHz"),
    HECTOHERTZ("hHz"),
    DECAHERTZ("daHz"),
    HERTZ("Hz"),
    DECIHERTZ("dHz"),
    CENTIHERTZ("cHz"),
    MILLIHERTZ("mHz"),
    MICROHERTZ("\u00b5Hz"),
    NANOHERTZ("nHz"),
    PICOHERTZ("pHz"),
    FEMTOHERTZ("fHz"),
    ATTOHERTZ("aHz"),
    ZEPTOHERTZ("zHz"),
    YOCTOHERTZ("yHz");

    private static final Map<String, UnitsFrequency> bySymbol;
    protected String symbol;

    private UnitsFrequency(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public static UnitsFrequency bySymbol(String symbol) {
        return bySymbol.get(symbol);
    }

    static {
        bySymbol = new HashMap<String, UnitsFrequency>();
        for (UnitsFrequency t : UnitsFrequency.values()) {
            bySymbol.put(t.symbol, t);
        }
    }
}

