/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hpsf;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import loci.common.RandomAccessInputStream;
import loci.poi.hpsf.ClassID;
import loci.poi.hpsf.HPSFRuntimeException;
import loci.poi.hpsf.IllegalPropertySetDataException;
import loci.poi.hpsf.MutableSection;
import loci.poi.hpsf.NoFormatIDException;
import loci.poi.hpsf.PropertySet;
import loci.poi.hpsf.Section;
import loci.poi.hpsf.TypeWriter;
import loci.poi.hpsf.WritingNotSupportedException;
import loci.poi.poifs.filesystem.DirectoryEntry;
import loci.poi.poifs.filesystem.Entry;
import loci.poi.util.LittleEndian;

public class MutablePropertySet
extends PropertySet {
    private final int OFFSET_HEADER = BYTE_ORDER_ASSERTION.length + FORMAT_ASSERTION.length + 4 + 16 + 4;

    public MutablePropertySet() {
        this.byteOrder = LittleEndian.getUShort(BYTE_ORDER_ASSERTION);
        this.format = LittleEndian.getUShort(FORMAT_ASSERTION);
        this.osVersion = 133636;
        this.classID = new ClassID();
        this.sections = new LinkedList();
        this.sections.add(new MutableSection());
    }

    public MutablePropertySet(PropertySet ps) {
        this.byteOrder = ps.getByteOrder();
        this.format = ps.getFormat();
        this.osVersion = ps.getOSVersion();
        this.setClassID(ps.getClassID());
        this.clearSections();
        Iterator i = ps.getSections().iterator();
        while (i.hasNext()) {
            MutableSection s = new MutableSection((Section)i.next());
            this.addSection(s);
        }
    }

    public void setByteOrder(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public void setOSVersion(int osVersion) {
        this.osVersion = osVersion;
    }

    public void setClassID(ClassID classID) {
        this.classID = classID;
    }

    public void clearSections() {
        this.sections = null;
    }

    public void addSection(Section section) {
        if (this.sections == null) {
            this.sections = new LinkedList();
        }
        this.sections.add(section);
    }

    public void write(OutputStream out) throws WritingNotSupportedException, IOException {
        MutableSection s;
        int nrSections = this.sections.size();
        int length = 0;
        length += TypeWriter.writeToStream(out, (short)this.getByteOrder());
        length += TypeWriter.writeToStream(out, (short)this.getFormat());
        length += TypeWriter.writeToStream(out, this.getOSVersion());
        length += TypeWriter.writeToStream(out, this.getClassID());
        length += TypeWriter.writeToStream(out, nrSections);
        int offset = this.OFFSET_HEADER;
        int sectionsBegin = offset += nrSections * 20;
        ListIterator i = this.sections.listIterator();
        while (i.hasNext()) {
            s = (MutableSection)i.next();
            ClassID formatID = s.getFormatID();
            if (formatID == null) {
                throw new NoFormatIDException();
            }
            length += TypeWriter.writeToStream(out, s.getFormatID());
            length += TypeWriter.writeUIntToStream(out, offset);
            try {
                offset += s.getSize();
            }
            catch (HPSFRuntimeException ex) {
                Throwable cause = ex.getReason();
                if (cause instanceof UnsupportedEncodingException) {
                    throw new IllegalPropertySetDataException(cause);
                }
                throw ex;
            }
        }
        offset = sectionsBegin;
        i = this.sections.listIterator();
        while (i.hasNext()) {
            s = (MutableSection)i.next();
            offset += s.write(out);
        }
    }

    public RandomAccessInputStream toInputStream() throws IOException, WritingNotSupportedException {
        ByteArrayOutputStream psStream = new ByteArrayOutputStream();
        this.write(psStream);
        psStream.close();
        byte[] streamData = psStream.toByteArray();
        return new RandomAccessInputStream(streamData);
    }

    public void write(DirectoryEntry dir, String name) throws WritingNotSupportedException, IOException {
        try {
            Entry e = dir.getEntry(name);
            e.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        dir.createDocument(name, this.toInputStream());
    }
}

