/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.utilities;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.base.utilities.ResourceUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class NativeLibraryUtilities {
    private static final String JNI_LIB_PREFIX = NativeLibraryUtilities.getJNILibPrefixForSystem();
    private static final String JNI_LIB_EXTENSION = NativeLibraryUtilities.getJNILibExtensionForSystem();

    private static String getJNILibPrefixForSystem() {
        return OSUtilities.isWindows() ? "" : "lib";
    }

    private static String getJNILibExtensionForSystem() {
        if (OSUtilities.isMacOS()) {
            return "jnilib";
        }
        if (OSUtilities.isWindows()) {
            return "dll";
        }
        return "so";
    }

    public static boolean loadNativeLibrary(String libraryName) {
        boolean verbose = Boolean.getBoolean("native.libpath.verbose");
        try {
            String linkLibNameOrNull = System.getProperty("native.libpath." + libraryName);
            if (linkLibNameOrNull != null) {
                return NativeLibraryUtilities.loadLib(libraryName, NativeLibraryUtilities.toRealPath(linkLibNameOrNull, verbose), verbose);
            }
            String linkLibPathOrNull = System.getProperty("native.libpath");
            if (linkLibPathOrNull != null) {
                linkLibNameOrNull = NativeLibraryUtilities.getLibPath(linkLibPathOrNull, libraryName);
                return NativeLibraryUtilities.loadLib(libraryName, NativeLibraryUtilities.toRealPath(linkLibNameOrNull, verbose), verbose);
            }
            linkLibNameOrNull = System.getProperty("native.caching.libpath." + libraryName);
            if (linkLibNameOrNull != null) {
                Path libraryPath = NativeLibraryUtilities.toRealPath(linkLibNameOrNull, verbose);
                NativeLibraryUtilities.tryCheckPerformUpdate(libraryName, libraryPath, verbose);
                return NativeLibraryUtilities.loadLib(libraryName, libraryPath, verbose);
            }
            linkLibPathOrNull = System.getProperty("native.caching.libpath");
            if (linkLibPathOrNull != null) {
                linkLibNameOrNull = NativeLibraryUtilities.getLibPath(linkLibPathOrNull, libraryName);
                Path libraryPath = NativeLibraryUtilities.toRealPath(linkLibNameOrNull, verbose);
                NativeLibraryUtilities.tryCheckPerformUpdate(libraryName, libraryPath, verbose);
                return NativeLibraryUtilities.loadLib(libraryName, libraryPath, verbose);
            }
            linkLibNameOrNull = NativeLibraryUtilities.tryCopyNativeLibraryToTempFile(libraryName, verbose);
            if (linkLibNameOrNull != null) {
                return NativeLibraryUtilities.loadLib(libraryName, NativeLibraryUtilities.toRealPath(linkLibNameOrNull, verbose), verbose);
            }
            return NativeLibraryUtilities.loadSystemLibrary(libraryName);
        }
        catch (Exception e) {
            if (verbose) {
                System.err.printf("[native.libpath] FAILURE to load native library '%s'.\n", libraryName);
                e.printStackTrace();
            }
            return false;
        }
    }

    private static Path toRealPath(String filePath, boolean verbose) throws IOException {
        Path p = Paths.get(filePath, new String[0]).toAbsolutePath();
        if (Files.exists(p, new LinkOption[0])) {
            return p.toRealPath(new LinkOption[0]);
        }
        NativeLibraryUtilities.checkCreateMissingPathElement(p, verbose);
        Path parent = p.getParent();
        if (Files.exists(parent, new LinkOption[0]) && Files.isDirectory(parent, new LinkOption[0])) {
            return Paths.get(parent.toRealPath(new LinkOption[0]).toString(), p.getFileName().toString());
        }
        if (verbose) {
            System.err.printf("[native.libpath] Creating missing path elements on '%s'\n", parent);
        }
        return Paths.get(Files.createDirectories(parent, new FileAttribute[0]).toString(), p.getFileName().toString());
    }

    private static void checkCreateMissingPathElement(Path p, boolean verbose) throws IOException {
        LinkedList<Path> pathList = new LinkedList<Path>();
        Path pp = p;
        while ((pp = pp.getParent()).getNameCount() > 0) {
            pathList.add(pp);
        }
        Iterator it = pathList.descendingIterator();
        while (it.hasNext()) {
            pp = (Path)it.next();
            if (Files.exists(pp, new LinkOption[0]) || !Files.isSymbolicLink(pp)) continue;
            Path resolved = Files.readSymbolicLink(pp);
            if (verbose) {
                System.err.printf("[native.libpath] Creating directory on resolved symbolic link '%s'\n", resolved);
            }
            Files.createDirectory(resolved, new FileAttribute[0]);
            break;
        }
    }

    private static boolean tryCheckPerformUpdate(String libraryName, Path linkLibPath, boolean verbose) {
        try {
            NativeLibraryUtilities.checkPerformUpdate(libraryName, linkLibPath, verbose);
            return true;
        }
        catch (Exception ex) {
            if (verbose) {
                System.err.printf("[native.libpath] FAILURE trying to check on whether to perform an update on library '%s' (path '%s').\n", libraryName, linkLibPath);
                ex.printStackTrace();
            }
            return false;
        }
    }

    private static void checkPerformUpdate(String libraryName, Path linkLibPath, boolean verbose) throws Exception {
        boolean exists = Files.exists(linkLibPath, new LinkOption[0]);
        boolean canWrite = Files.isWritable(exists ? linkLibPath : linkLibPath.getParent());
        if (!canWrite) {
            if (verbose) {
                System.err.printf("[native.libpath] Skipping update check as '%s' is not writeable.\n", linkLibPath);
            }
            return;
        }
        String libPathInJarfile = NativeLibraryUtilities.getLibPath("/native", libraryName);
        if (exists) {
            if (NativeLibraryUtilities.needsUpdate(libraryName, libPathInJarfile, linkLibPath, verbose)) {
                NativeLibraryUtilities.performUpdate(libraryName, libPathInJarfile, linkLibPath, verbose);
            }
        } else {
            NativeLibraryUtilities.performUpdate(libraryName, libPathInJarfile, linkLibPath, verbose);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean needsUpdate(String libName, String libPathInJarfile, Path linkLibPath, boolean verbose) throws Exception {
        URI uri;
        URL url = ResourceUtilities.class.getResource(libPathInJarfile);
        URI uRI = uri = url != null ? url.toURI() : null;
        if (uri == null) {
            throw new IllegalArgumentException("Resource '" + libPathInJarfile + "' cannot be resolved to an URI.");
        }
        String[] array = uri.toString().split("!");
        if (array.length != 2) throw new IllegalArgumentException("URI " + uri.toString() + " cannot be resolved to resource in jar file.");
        if (!array[0].startsWith("jar:file:")) throw new IllegalArgumentException("URI " + uri.toString() + " cannot be resolved to resource in jar file.");
        String jarFileName = array[0].substring("jar:file:".length());
        String jarResourceName = array[1].substring(1);
        Throwable throwable = null;
        Object var10_11 = null;
        try {
            boolean needsUpdate;
            ZipFile zipFile = new ZipFile(jarFileName);
            try {
                ZipEntry entry;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                do {
                    if (entries.hasMoreElements()) continue;
                    throw new NoSuchFileException("Resource '" + jarResourceName + "' not in jar file '" + jarFileName + "'");
                } while (!jarResourceName.equals((entry = entries.nextElement()).getName()));
                long size = entry.getSize();
                long crc32 = entry.getCrc();
                long[] fileStats = NativeLibraryUtilities.getSizeAnCrc32ForPath(linkLibPath);
                needsUpdate = size != fileStats[0] || crc32 != fileStats[1];
                if (!verbose) return needsUpdate;
                if (needsUpdate) {
                    System.err.printf("[native.libpath] Native library '%s' needs update: jar resource '%s' (size=%d, crc32=%h) changed compared to file '%s' (size=%d, crc32=%h).\n", libName, entry.getName(), size, crc32, linkLibPath, fileStats[0], fileStats[1]);
                    return needsUpdate;
                }
                System.err.printf("[native.libpath] Native library '%s' unchanged (file '%s', jar resource '%s').\n", libName, linkLibPath, entry.getName());
                return needsUpdate;
            }
            finally {
                if (zipFile == null) return needsUpdate;
                zipFile.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static void performUpdate(String libName, String libPathInJarfile, Path linkLibPath, boolean verbose) throws IOException {
        if (verbose) {
            System.err.printf("[native.libpath] Updating library '%s': refresh file '%s' from jar resource '%s'.\n", libName, linkLibPath, libPathInJarfile);
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(linkLibPath.toFile(), "rw");){
            randomAccessFile.getChannel().lock(0L, 1L, false);
            ResourceUtilities.tryCopyResourceToFile(libPathInJarfile, linkLibPath, randomAccessFile, verbose, "[native.libpath] ");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static long[] getSizeAnCrc32ForPath(Path linkLibPath) throws IOException {
        return new long[]{Files.size(linkLibPath), NativeLibraryUtilities.crc32(linkLibPath)};
    }

    private static long crc32(Path path) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream in = new FileInputStream(path.toFile());){
            int bytesRead;
            CRC32 crcMaker = new CRC32();
            byte[] buffer = new byte[16384];
            while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                crcMaker.update(buffer, 0, bytesRead);
            }
            return crcMaker.getValue();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean loadLib(String libName, Path libPath, boolean verbose) {
        File linkLib;
        if (verbose) {
            System.err.printf("[native.libpath] Loading native library '%s' from file '%s'.\n", libName, libPath);
        }
        if ((linkLib = libPath.toFile()).exists() && linkLib.canRead() && linkLib.isFile()) {
            block17: {
                String linkLibNameAbsolute = linkLib.getAbsolutePath();
                Throwable throwable = null;
                Object var6_8 = null;
                RandomAccessFile randomAccessFile = new RandomAccessFile(linkLib, "r");
                try {
                    randomAccessFile.getChannel().lock(0L, 1L, true);
                    System.load(linkLibNameAbsolute);
                    if (randomAccessFile == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        catch (Throwable err) {
                            if (verbose) {
                                System.err.printf("[native.libpath] FAILURE loading native library '%s'.\n", linkLibNameAbsolute);
                                err.printStackTrace();
                            }
                            return false;
                        }
                    }
                }
                randomAccessFile.close();
            }
            return true;
        }
        if (verbose) {
            System.err.printf("[native.libpath] FAILURE as native library '%s' does not exist or is not readable.\n", linkLib.getAbsolutePath());
        }
        return false;
    }

    private static boolean loadSystemLibrary(String libName) {
        try {
            System.loadLibrary(libName);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String tryCopyNativeLibraryToTempFile(String libraryName, boolean verbose) {
        return ResourceUtilities.tryCopyResourceToTempFile(NativeLibraryUtilities.getLibPath("/native", libraryName), libraryName, ".so", true, verbose, "[native.libpath] ");
    }

    private static String getLibPath(String prefix, String libraryName) {
        return String.format("%s/%s/%s/%s%s.%s", prefix, libraryName, OSUtilities.getCompatibleComputerPlatform(), JNI_LIB_PREFIX, libraryName, JNI_LIB_EXTENSION);
    }
}

