/*
 * Decompiled with CFR 0.152.
 */
package ome.logic;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import ome.annotations.RolesAllowed;
import ome.api.IContainer;
import ome.api.IQuery;
import ome.api.ServiceInterface;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.logic.AbstractLevel2Service;
import ome.model.ILink;
import ome.model.IObject;
import ome.model.containers.Dataset;
import ome.model.containers.Folder;
import ome.model.containers.Project;
import ome.model.core.Image;
import ome.model.fs.Fileset;
import ome.model.screen.Plate;
import ome.model.screen.Screen;
import ome.model.screen.Well;
import ome.parameters.Parameters;
import ome.services.query.HierarchyNavigator;
import ome.services.query.PojosFindHierarchiesQueryDefinition;
import ome.services.query.PojosGetImagesByOptionsQueryDefinition;
import ome.services.query.PojosGetImagesQueryDefinition;
import ome.services.query.PojosGetUserImagesQueryDefinition;
import ome.services.query.PojosLoadHierarchyQueryDefinition;
import ome.services.query.Query;
import ome.tools.HierarchyTransformations;
import ome.tools.lsid.LsidUtils;
import ome.util.CBlock;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PojosImpl
extends AbstractLevel2Service
implements IContainer {
    static final String loadCountsImages = "select img from Image img left outer join fetch img.annotationLinksCountPerOwner iac where img in (:list)";
    static final String loadCountsDatasets = "select d from Dataset d left outer join fetch d.annotationLinksCountPerOwner left outer join fetch d.imageLinksCountPerOwner where d in (:list)";
    static final String loadCountsPlates = "select p from Plate p left outer join fetch p.annotationLinksCountPerOwner where p in (:list)";
    static final Map<Class, String> paginationQueries = new HashMap<Class, String>();
    static final String alphaNumeric = "^\\w+$";
    static final String alphaNumericDotted = "^\\w[.\\w]+$";

    public final Class<? extends ServiceInterface> getServiceInterface() {
        return IContainer.class;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Set loadContainerHierarchy(Class rootNodeType, Set rootNodeIds, Parameters options) {
        options = new Parameters(options);
        if (null == rootNodeIds && !options.isExperimenter() && !options.isGroup()) {
            throw new ApiUsageException("Set of ids for loadContainerHierarchy() may not be null if experimenter and group options are null.");
        }
        if (!(Project.class.equals((Object)rootNodeType) || Dataset.class.equals((Object)rootNodeType) || Screen.class.equals((Object)rootNodeType) || Plate.class.equals((Object)rootNodeType))) {
            throw new ApiUsageException("Class parameter for loadContainerIHierarchy() must be in {Project,Dataset, Screen, Plate}, not " + rootNodeType);
        }
        Query q = this.getQueryFactory().lookup(PojosLoadHierarchyQueryDefinition.class.getName(), options.addClass(rootNodeType).addIds((Collection)rootNodeIds));
        List l = (List)this.iQuery.execute(q);
        if (Project.class.equals((Object)rootNodeType)) {
            Project p;
            HashSet datasets = new HashSet();
            for (IObject o : l) {
                p = (Project)o;
                datasets.addAll(p.linkedDatasetList());
            }
            if (options.isOrphan() && CollectionUtils.isEmpty((Collection)rootNodeIds)) {
                Iterator i = datasets.iterator();
                HashSet<Long> linked = new HashSet<Long>();
                while (i.hasNext()) {
                    linked.add(((Dataset)i.next()).getId());
                }
                q = this.getQueryFactory().lookup(PojosLoadHierarchyQueryDefinition.class.getName(), options.addClass(Dataset.class).addIds((Collection)rootNodeIds));
                List list = (List)this.iQuery.execute(q);
                Iterator j = list.iterator();
                HashMap<Long, Dataset> notLinked = new HashMap<Long, Dataset>();
                while (j.hasNext()) {
                    Dataset d = (Dataset)j.next();
                    Long id = d.getId();
                    if (linked.contains(id)) continue;
                    notLinked.put(id, d);
                }
                StringBuffer sb = new StringBuffer();
                sb.append("select this from Project this ");
                sb.append("left outer join fetch this.datasetLinks pdl ");
                sb.append("left outer join fetch pdl.child ds ");
                sb.append("where ds in (:list)");
                if (notLinked.size() > 0) {
                    ArrayList nl = new ArrayList();
                    nl.addAll(notLinked.values());
                    List projects = this.iQuery.findAllByQuery(sb.toString(), new Parameters().addList("list", nl));
                    if (projects.isEmpty()) {
                        datasets.addAll(nl);
                        l.addAll(nl);
                    } else {
                        for (IObject o : projects) {
                            p = (Project)o;
                            List ll = p.linkedDatasetList();
                            for (Dataset data : ll) {
                                if (!notLinked.containsKey(data.getId())) continue;
                                notLinked.remove(data.getId());
                            }
                        }
                        if (notLinked.size() > 0) {
                            nl = new ArrayList();
                            nl.addAll(notLinked.values());
                            datasets.addAll(nl);
                            l.addAll(nl);
                        }
                    }
                }
            }
            if (datasets.size() > 0) {
                this.iQuery.findAllByQuery(loadCountsDatasets, new Parameters().addSet("list", datasets));
            }
        } else if (Dataset.class.isAssignableFrom(rootNodeType)) {
            Dataset d;
            HashSet images = new HashSet();
            for (Object o : l) {
                d = (Dataset)o;
                images.addAll(d.linkedImageList());
            }
            if (images.size() > 0) {
                this.iQuery.findAllByQuery(loadCountsImages, new Parameters().addSet("list", images));
            }
            if (!options.isLeaves()) {
                EvictBlock evict = new EvictBlock();
                for (IObject o : l) {
                    d = (Dataset)o;
                    evict.call((IObject)d);
                    d.putAt("ome.model.containers.Dataset_imageLinks", null);
                }
            }
        } else if (Screen.class.isAssignableFrom(rootNodeType)) {
            Screen p;
            HashSet plates = new HashSet();
            for (IObject o : l) {
                p = (Screen)o;
                plates.addAll(p.linkedPlateList());
            }
            if (options.isOrphan() && CollectionUtils.isEmpty((Collection)rootNodeIds)) {
                Iterator i = plates.iterator();
                HashSet<Long> linked = new HashSet<Long>();
                while (i.hasNext()) {
                    linked.add(((Plate)i.next()).getId());
                }
                q = this.getQueryFactory().lookup(PojosLoadHierarchyQueryDefinition.class.getName(), options.addClass(Plate.class).addIds((Collection)rootNodeIds));
                List list = (List)this.iQuery.execute(q);
                Iterator j = list.iterator();
                HashMap<Long, Plate> notLinked = new HashMap<Long, Plate>();
                while (j.hasNext()) {
                    Plate pp = (Plate)j.next();
                    Long id = pp.getId();
                    if (linked.contains(id)) continue;
                    notLinked.put(id, pp);
                }
                StringBuffer sb = new StringBuffer();
                sb.append("select this from Screen this ");
                sb.append("left outer join fetch this.plateLinks pdl ");
                sb.append("left outer join fetch pdl.child ds ");
                sb.append("where ds in (:list)");
                if (notLinked.size() > 0) {
                    ArrayList nl = new ArrayList();
                    nl.addAll(notLinked.values());
                    List screens = this.iQuery.findAllByQuery(sb.toString(), new Parameters().addList("list", nl));
                    if (screens.isEmpty()) {
                        plates.addAll(nl);
                        l.addAll(nl);
                    } else {
                        for (IObject o : screens) {
                            p = (Screen)o;
                            List ll = p.linkedPlateList();
                            for (Plate data : ll) {
                                if (!notLinked.containsKey(data.getId())) continue;
                                notLinked.remove(data.getId());
                            }
                        }
                        if (notLinked.size() > 0) {
                            nl = new ArrayList();
                            nl.addAll(notLinked.values());
                            plates.addAll(nl);
                            l.addAll(nl);
                        }
                    }
                }
            }
            if (plates.size() > 0) {
                this.iQuery.findAllByQuery(loadCountsPlates, new Parameters().addSet("list", plates));
            }
        }
        return new HashSet(l);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Set findContainerHierarchies(Class rootNodeType, Set imageIds, Parameters options) {
        options = new Parameters(options);
        if (!Project.class.equals((Object)rootNodeType)) {
            throw new ApiUsageException("Class parameter for findContainerHierarchies() must be in {Project}, not " + rootNodeType);
        }
        Query q = this.getQueryFactory().lookup(PojosFindHierarchiesQueryDefinition.class.getName(), options.addClass(rootNodeType).addIds((Collection)imageIds));
        List l = (List)this.iQuery.execute(q);
        if (Project.class.equals((Object)rootNodeType)) {
            if (imageIds.size() == 0) {
                return new HashSet();
            }
            return HierarchyTransformations.invertPDI(new HashSet<Image>(l), new EvictBlock());
        }
        throw new InternalException("This can't be reached.");
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Set getImages(Class rootNodeType, final Set rootNodeIds, Parameters options) {
        if (rootNodeIds.size() == 0) {
            return new HashSet();
        }
        final Parameters view = options = new Parameters(options);
        Class<Image> effType = rootNodeType;
        HashSet effIds = rootNodeIds;
        if (options.isPagination()) {
            final String query = paginationQueries.get(rootNodeType);
            if (query == null) {
                throw new ApiUsageException(rootNodeType.getName() + " does not support pagination yet.");
            }
            effType = Image.class;
            effIds = new HashSet((List)this.iQuery.execute(new HibernateCallback(){

                public Object doInHibernate(Session s) throws HibernateException, SQLException {
                    org.hibernate.Query q = s.createQuery(query);
                    q.setParameterList("ids", (Collection)rootNodeIds);
                    if (view.getLimit() != null) {
                        q.setMaxResults(view.getLimit().intValue());
                    } else {
                        q.setMaxResults(Integer.MAX_VALUE);
                    }
                    if (view.getOffset() != null) {
                        q.setFirstResult(view.getOffset().intValue());
                    } else {
                        q.setFirstResult(0);
                    }
                    return q.list();
                }
            }));
            if (effIds == null || effIds.size() == 0) {
                return new HashSet();
            }
            options = options.page(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        }
        Query q = this.getQueryFactory().lookup(PojosGetImagesQueryDefinition.class.getName(), options.addIds((Collection)effIds).addClass(effType));
        List l = (List)this.iQuery.execute(q);
        return new HashSet(l);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Set getImagesByOptions(Parameters options) {
        if ((options = new Parameters(options)).getStartTime() == null && options.getEndTime() == null) {
            throw new ApiUsageException("start or end time option is required for getImagesByOptions().");
        }
        Query q = this.getQueryFactory().lookup(PojosGetImagesByOptionsQueryDefinition.class.getName(), options);
        List l = (List)this.iQuery.execute(q);
        return new HashSet(l);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Map<Long, Map<Boolean, List<Long>>> getImagesBySplitFilesets(Map<Class<? extends IObject>, List<Long>> included, Parameters options) {
        HashSet<Long> folderIds = new HashSet<Long>();
        HashSet<Long> projectIds = new HashSet<Long>();
        HashSet<Long> datasetIds = new HashSet<Long>();
        HashSet<Long> screenIds = new HashSet<Long>();
        HashSet<Long> plateIds = new HashSet<Long>();
        HashSet<Long> wellIds = new HashSet<Long>();
        HashSet<Long> filesetIds = new HashSet<Long>();
        HashSet<Long> imageIds = new HashSet<Long>();
        for (Map.Entry<Class<? extends IObject>, List<Long>> typeAndIds : included.entrySet()) {
            Class<? extends IObject> type = typeAndIds.getKey();
            List<Long> ids = typeAndIds.getValue();
            if (Folder.class.isAssignableFrom(type)) {
                folderIds.addAll(ids);
                continue;
            }
            if (Project.class.isAssignableFrom(type)) {
                projectIds.addAll(ids);
                continue;
            }
            if (Dataset.class.isAssignableFrom(type)) {
                datasetIds.addAll(ids);
                continue;
            }
            if (Screen.class.isAssignableFrom(type)) {
                screenIds.addAll(ids);
                continue;
            }
            if (Plate.class.isAssignableFrom(type)) {
                plateIds.addAll(ids);
                continue;
            }
            if (Well.class.isAssignableFrom(type)) {
                wellIds.addAll(ids);
                continue;
            }
            if (Image.class.isAssignableFrom(type)) {
                imageIds.addAll(ids);
                continue;
            }
            if (!Fileset.class.isAssignableFrom(type)) continue;
            filesetIds.addAll(ids);
        }
        HierarchyNavigatorPlain hierarchyNavigator = new HierarchyNavigatorPlain(this.iQuery);
        hierarchyNavigator.noteLookups("Project", "Dataset", projectIds, datasetIds);
        hierarchyNavigator.noteLookups("Dataset", "Image", datasetIds, imageIds);
        hierarchyNavigator.noteLookups("Screen", "Plate", screenIds, plateIds);
        hierarchyNavigator.noteLookups("Plate", "Well", plateIds, wellIds);
        hierarchyNavigator.noteLookups("Well", "Image", wellIds, imageIds);
        hierarchyNavigator.noteLookups("Fileset", "Image", filesetIds, imageIds);
        HashSet<Long> oldFolderIds = folderIds;
        HashSet<Long> newFolderIds = new HashSet<Long>();
        while (true) {
            hierarchyNavigator.noteLookups("Folder", "Folder", oldFolderIds, newFolderIds);
            if (newFolderIds.isEmpty()) break;
            folderIds.addAll(newFolderIds);
            oldFolderIds = newFolderIds;
            newFolderIds = new HashSet();
        }
        hierarchyNavigator.noteLookups("Folder", "Image", folderIds, imageIds);
        HashSet<Long> filesetIdsRequired = new HashSet<Long>();
        hierarchyNavigator.noteLookups("Image", "Fileset", imageIds, filesetIdsRequired);
        HashMap<Long, Map<Boolean, List<Long>>> imagesBySplitFilesets = new HashMap<Long, Map<Boolean, List<Long>>>();
        Sets.SetView filesetIdsMissing = Sets.difference(filesetIdsRequired, filesetIds);
        hierarchyNavigator.prepareLookups("Image", "Fileset", (Collection<Long>)filesetIdsMissing);
        Iterator iterator = filesetIdsMissing.iterator();
        while (iterator.hasNext()) {
            Sets.SetView includedImageIds;
            long filesetIdMissing = (Long)iterator.next();
            ImmutableSet<Long> imageIdsRequiredUnordered = hierarchyNavigator.doLookup("Image", "Fileset", filesetIdMissing);
            TreeSet<Long> imageIdsRequired = new TreeSet<Long>((Collection<Long>)imageIdsRequiredUnordered);
            Sets.SetView excludedImageIds = Sets.difference(imageIdsRequired, (Set)(includedImageIds = Sets.intersection(imageIdsRequired, imageIds)));
            if (excludedImageIds.isEmpty()) continue;
            HashMap partitionedImages = new HashMap(2);
            partitionedImages.put(true, new ArrayList(includedImageIds));
            partitionedImages.put(false, new ArrayList(excludedImageIds));
            imagesBySplitFilesets.put(filesetIdMissing, partitionedImages);
        }
        return imagesBySplitFilesets;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Set getUserImages(Parameters options) {
        if (!(options = new Parameters(options)).isExperimenter() && !options.isGroup()) {
            throw new ApiUsageException("experimenter or group option is required for getUserImages().");
        }
        Query q = this.getQueryFactory().lookup(PojosGetUserImagesQueryDefinition.class.getName(), options);
        List l = (List)this.iQuery.execute(q);
        return new HashSet(l);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Map getCollectionCount(String type, String property, Set ids, Parameters options) {
        String parsedProperty = LsidUtils.parseField(property);
        this.checkType(type);
        this.checkProperty(type, parsedProperty);
        HashMap<Long, Integer> results = new HashMap<Long, Integer>();
        String query = "select size(table." + parsedProperty + ") from " + type + " table where table.id = :id";
        for (Long id : ids) {
            Query q = this.getQueryFactory().lookup(query, new Parameters().addId(id));
            Integer count = (Integer)((List)this.iQuery.execute(q)).get(0);
            results.put(id, count);
        }
        return results;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public Collection retrieveCollection(IObject arg0, String arg1, Parameters arg2) {
        IObject context = this.iQuery.get(arg0.getClass(), arg0.getId());
        Collection c = (Collection)context.retrieve(arg1);
        this.iQuery.initialize(c);
        return c;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public IObject createDataObject(IObject arg0, Parameters arg1) {
        return this.iUpdate.saveAndReturnObject(arg0);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public IObject[] createDataObjects(IObject[] arg0, Parameters arg1) {
        return this.iUpdate.saveAndReturnArray(arg0);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void unlink(ILink[] arg0, Parameters arg1) {
        this.deleteDataObjects((IObject[])arg0, arg1);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public ILink[] link(ILink[] arg0, Parameters arg1) {
        IObject[] retVal = this.iUpdate.saveAndReturnArray((IObject[])arg0);
        ILink[] links = new ILink[retVal.length];
        System.arraycopy(retVal, 0, links, 0, retVal.length);
        return links;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public IObject updateDataObject(IObject arg0, Parameters arg1) {
        return this.iUpdate.saveAndReturnObject(arg0);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public IObject[] updateDataObjects(IObject[] arg0, Parameters arg1) {
        return this.iUpdate.saveAndReturnArray(arg0);
    }

    private void deleteDataObject(IObject row, Parameters options) {
        this.iUpdate.deleteObject(row);
    }

    private void deleteDataObjects(IObject[] rows, Parameters options) {
        for (IObject object : rows) {
            this.deleteDataObject(object, options);
        }
    }

    protected void checkType(String type) {
        if (!type.matches(alphaNumericDotted)) {
            throw new ApiUsageException("Type argument to getCollectionCount may ONLY be alpha-numeric with dots (^\\w[.\\w]+$)");
        }
        if (!this.iQuery.checkType(type)) {
            throw new ApiUsageException(type + " is an unknown type.");
        }
    }

    protected void checkProperty(String type, String property) {
        if (!property.matches(alphaNumeric)) {
            throw new ApiUsageException("Property argument to getCollectionCount may ONLY be alpha-numeric (^\\w+$)");
        }
        if (!this.iQuery.checkProperty(type, property)) {
            throw new ApiUsageException(type + "." + property + " is an unknown property on type " + type);
        }
    }

    static {
        paginationQueries.put(Dataset.class, "select link.child.id from DatasetImageLink  link where link.parent.id in (:ids)order by link.child.id");
        paginationQueries.put(Project.class, "select distinct dil.child.id from ProjectDatasetLink pdl join pdl.child ds join ds.imageLinks as dil where pdl.parent.id in (:ids) order by dil.child.id");
    }

    class EvictBlock<E extends IObject>
    implements CBlock {
        EvictBlock() {
        }

        public E call(IObject object) {
            PojosImpl.this.iQuery.evict(object);
            return (E)object;
        }
    }

    private static class HierarchyNavigatorPlain
    extends HierarchyNavigator {
        HierarchyNavigatorPlain(IQuery iQuery) {
            super(iQuery);
        }

        @Override
        public void prepareLookups(String toType, String fromType, Collection<Long> fromIds) {
            super.prepareLookups(toType, fromType, fromIds);
        }

        @Override
        public ImmutableSet<Long> doLookup(String toType, String fromType, Long fromId) {
            return super.doLookup(toType, fromType, fromId);
        }

        public void noteLookups(String fromType, String toType, Collection<Long> fromIds, Collection<Long> toIdsAccumulator) {
            super.prepareLookups(toType, fromType, fromIds);
            for (Long fromId : fromIds) {
                toIdsAccumulator.addAll((Collection<Long>)super.doLookup(toType, fromType, fromId));
            }
        }
    }
}

