/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;

public abstract class AbstractProjectAction
extends AbstractAction {
    private Application app;
    private String propertyName;
    private PropertyChangeListener applicationListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "currentProject") {
                AbstractProjectAction.this.updateProject((Project)evt.getOldValue(), (Project)evt.getNewValue());
            }
        }
    };
    private PropertyChangeListener projectListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "enabled") {
                AbstractProjectAction.this.updateEnabled((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            } else if (name == AbstractProjectAction.this.propertyName) {
                AbstractProjectAction.this.updateProperty();
            }
        }
    };

    public AbstractProjectAction(Application app) {
        this.app = app;
        this.enabled = true;
        if (app != null) {
            app.addPropertyChangeListener(this.applicationListener);
            this.updateProject(null, app.getCurrentProject());
        }
    }

    protected void updateProject(Project oldValue, Project newValue) {
        if (oldValue != null) {
            this.uninstallProjectListeners(oldValue);
        }
        if (newValue != null) {
            this.installProjectListeners(newValue);
        }
        this.firePropertyChange("project", oldValue, newValue);
        this.updateEnabled(oldValue != null && oldValue.isEnabled(), newValue != null && newValue.isEnabled());
        this.updateProperty();
    }

    protected void setPropertyName(String name) {
        this.propertyName = name;
        if (name != null) {
            this.updateProperty();
        }
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected void updateProperty() {
    }

    protected void installProjectListeners(Project p) {
        p.addPropertyChangeListener(this.projectListener);
    }

    protected void uninstallProjectListeners(Project p) {
        p.removePropertyChangeListener(this.projectListener);
    }

    protected void updateEnabled(boolean oldValue, boolean newValue) {
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    public Application getApplication() {
        return this.app;
    }

    public Project getCurrentProject() {
        return this.app.getCurrentProject();
    }

    public boolean isEnabled() {
        return this.getCurrentProject() != null && this.getCurrentProject().isEnabled() && this.enabled;
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        boolean projIsEnabled = this.getCurrentProject() != null && this.getCurrentProject().isEnabled();
        this.firePropertyChange("enabled", oldValue && projIsEnabled, newValue && projIsEnabled);
    }
}

