/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractProjectAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractSaveBeforeAction
extends AbstractProjectAction {
    private Component oldFocusOwner;

    public AbstractSaveBeforeAction(Application app) {
        super(app);
    }

    public void actionPerformed(ActionEvent evt) {
        final Project p = this.getCurrentProject();
        if (p.isEnabled()) {
            final ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
            Window wAncestor = SwingUtilities.getWindowAncestor(p.getComponent());
            this.oldFocusOwner = wAncestor == null ? null : wAncestor.getFocusOwner();
            p.setEnabled(false);
            if (p.hasUnsavedChanges()) {
                JOptionPane pane = new JOptionPane("<html>" + UIManager.getString("OptionPane.css") + labels.getString("saveBeforeMessage"), 2);
                Object[] options = new Object[]{labels.getString("save"), labels.getString("cancel"), labels.getString("dontSave")};
                pane.setOptions(options);
                pane.setInitialValue(options[0]);
                pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
                JSheet.showSheet(pane, p.getComponent(), new SheetListener(){

                    public void optionSelected(SheetEvent evt) {
                        Object value = evt.getValue();
                        if (value == null || value.equals(labels.getString("cancel"))) {
                            p.setEnabled(true);
                        } else if (value.equals(labels.getString("dontSave"))) {
                            AbstractSaveBeforeAction.this.doIt(p);
                            p.setEnabled(true);
                        } else if (value.equals(labels.getString("save"))) {
                            AbstractSaveBeforeAction.this.saveChanges(p);
                        }
                    }
                });
            } else {
                this.doIt(p);
                p.setEnabled(true);
                if (this.oldFocusOwner != null) {
                    this.oldFocusOwner.requestFocus();
                }
            }
        }
    }

    protected void saveChanges(final Project p) {
        if (p.getFile() == null) {
            JFileChooser fileChooser = p.getSaveChooser();
            JSheet.showSaveSheet(fileChooser, p.getComponent(), new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getFileFilter() instanceof ExtensionFileFilter ? ((ExtensionFileFilter)evt.getFileChooser().getFileFilter()).makeAcceptable(evt.getFileChooser().getSelectedFile()) : evt.getFileChooser().getSelectedFile();
                        AbstractSaveBeforeAction.this.saveToFile(p, file);
                    } else {
                        p.setEnabled(true);
                        if (AbstractSaveBeforeAction.this.oldFocusOwner != null) {
                            AbstractSaveBeforeAction.this.oldFocusOwner.requestFocus();
                        }
                    }
                }
            });
        } else {
            this.saveToFile(p, p.getFile());
        }
    }

    protected void saveToFile(final Project p, final File file) {
        p.execute(new Worker(){

            public Object construct() {
                try {
                    p.write(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            public void finished(Object value) {
                AbstractSaveBeforeAction.this.fileSaved(p, file, value);
            }
        });
    }

    protected void fileSaved(Project p, File file, Object value) {
        if (value == null) {
            p.setFile(file);
            p.markChangesAsSaved();
            this.doIt(p);
        } else {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
            JSheet.showMessageSheet((Component)p.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + labels.getFormatted("couldntSave", file, value)), 0);
        }
        p.setEnabled(true);
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
    }

    protected abstract void doIt(Project var1);
}

