/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ChopRectangleConnector;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Geom;

public class ChopEllipseConnector
extends ChopRectangleConnector {
    public ChopEllipseConnector() {
    }

    public ChopEllipseConnector(Figure owner) {
        super(owner);
    }

    private Color getStrokeColor(Figure f) {
        return (Color)f.getAttribute(AttributeKeys.STROKE_COLOR);
    }

    private float getStrokeWidth(Figure f) {
        Float w = (Float)f.getAttribute(AttributeKeys.STROKE_WIDTH);
        return w == null ? 1.0f : w.floatValue();
    }

    protected Point2D.Double chop(Figure target, Point2D.Double from) {
        target = this.getConnectorTarget(target);
        Rectangle2D.Double r = target.getBounds();
        if (this.getStrokeColor(target) != null) {
            double grow;
            switch (AttributeKeys.STROKE_PLACEMENT.get(target)) {
                default: {
                    grow = AttributeKeys.getStrokeTotalWidth(target) / 2.0;
                    break;
                }
                case OUTSIDE: {
                    grow = AttributeKeys.getStrokeTotalWidth(target);
                    break;
                }
                case INSIDE: {
                    grow = 0.0;
                }
            }
            Geom.grow(r, grow, grow);
        }
        double angle = Geom.pointToAngle(r, from);
        return Geom.ovalAngleToPoint(r, angle);
    }
}

