/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FloatingTextArea;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.geom.Insets2D;

public class TextAreaTool
extends CreationTool
implements ActionListener {
    private FloatingTextArea textArea;
    private TextHolderFigure typingTarget;
    private Color rubberbandColor = null;

    public TextAreaTool(TextHolderFigure prototype) {
        super(prototype);
    }

    public TextAreaTool(TextHolderFigure prototype, Map attributes) {
        super(prototype, (Map<AttributeKey, Object>)attributes);
    }

    public void setRubberbandColor(Color c) {
        this.rubberbandColor = c;
    }

    public void deactivate(DrawingEditor editor) {
        this.endEdit();
        super.deactivate(editor);
    }

    public void mousePressed(MouseEvent e) {
        TextHolderFigure textHolder = null;
        Figure pressedFigure = this.getDrawing().findFigureInside(this.getView().viewToDrawing(new Point(e.getX(), e.getY())));
        if (pressedFigure instanceof TextHolderFigure && !(textHolder = (TextHolderFigure)pressedFigure).isEditable()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.createdFigure = null;
            this.beginEdit(textHolder);
            return;
        }
        if (this.typingTarget != null) {
            this.endEdit();
            this.fireToolDone();
        } else {
            super.mousePressed(e);
        }
    }

    protected void creationFinished(Figure createdFigure) {
        this.beginEdit((TextHolderFigure)createdFigure);
    }

    public void draw(Graphics2D g) {
        if (this.createdFigure != null && this.rubberbandColor != null) {
            g.setColor(this.rubberbandColor);
            g.draw(this.getView().drawingToView(this.createdFigure.getBounds()));
        }
    }

    protected void beginEdit(TextHolderFigure textHolder) {
        if (this.textArea == null) {
            this.textArea = new FloatingTextArea();
        }
        if (textHolder != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textArea.createOverlay(this.getView(), textHolder);
        this.textArea.setBounds(this.getFieldBounds(textHolder), textHolder.getText());
        this.textArea.requestFocus();
        this.typingTarget = textHolder;
    }

    private Rectangle2D.Double getFieldBounds(TextHolderFigure figure) {
        Rectangle2D.Double r = figure.getDrawingArea();
        Insets2D.Double insets = figure.getInsets();
        insets.subtractTo(r);
        r.x -= 1.0;
        r.y -= 2.0;
        r.width += 18.0;
        r.height += 4.0;
        return r;
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            this.typingTarget.willChange();
            if (this.textArea.getText().length() > 0) {
                this.typingTarget.setText(this.textArea.getText());
            } else if (this.createdFigure != null) {
                this.getDrawing().remove(this.getAddedFigure());
            } else {
                this.typingTarget.setText("");
            }
            this.typingTarget.changed();
            this.typingTarget = null;
            this.textArea.endOverlay();
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.endEdit();
        this.fireToolDone();
    }
}

