/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.Arrays;
import java.util.List;
import omero.gateway.model.TableDataColumn;
import org.apache.commons.collections.CollectionUtils;

public class TableData {
    private TableDataColumn[] columns;
    private Object[][] data;
    private long offset = 0L;
    private long originalFileId = -1L;
    private long numberOfRows = 0L;

    public TableData(List<TableDataColumn> columns, List<List<Object>> data) {
        if (CollectionUtils.isNotEmpty(columns)) {
            this.columns = new TableDataColumn[columns.size()];
            this.columns = columns.toArray(this.columns);
        } else {
            this.columns = new TableDataColumn[0];
        }
        if (CollectionUtils.isNotEmpty(data)) {
            int nRows = data.get(0).size();
            this.data = new Object[data.size()][nRows];
            for (int i = 0; i < data.size(); ++i) {
                List<Object> columnData = data.get(i);
                for (int j = 0; j < columnData.size(); ++j) {
                    this.data[i][j] = columnData.get(j);
                }
            }
        } else {
            this.data = new Object[0][0];
        }
    }

    public TableData(TableDataColumn[] columns, Object[][] data) {
        this.columns = columns != null ? columns : new TableDataColumn[]{};
        this.data = data != null ? data : new Object[0][0];
    }

    public TableDataColumn[] getColumns() {
        return this.columns;
    }

    public Object[][] getData() {
        return this.data;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getOriginalFileId() {
        return this.originalFileId;
    }

    public void setOriginalFileId(long originalFileId) {
        this.originalFileId = originalFileId;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public boolean isEmpty() {
        return this.data == null || this.data.length == 0 || this.data[0].length == 0;
    }

    public boolean isCompleted() {
        if (this.isEmpty()) {
            return true;
        }
        return this.offset + (long)this.data[0].length == this.numberOfRows;
    }

    public void setCompleted() {
        this.numberOfRows = this.isEmpty() ? 0L : this.offset + (long)this.data[0].length;
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setNumberOfRows(long numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 + (int)this.offset;
        result = 31 * result + (int)this.numberOfRows;
        result = 31 * result + (int)this.originalFileId;
        result = 31 * result + Arrays.hashCode(this.columns);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableData other = (TableData)obj;
        if (this.originalFileId != other.getOriginalFileId()) {
            return false;
        }
        if (this.offset != other.getOffset()) {
            return false;
        }
        if (this.numberOfRows != other.numberOfRows) {
            return false;
        }
        if (Arrays.hashCode(this.columns) != Arrays.hashCode(other.columns)) {
            return false;
        }
        return this.objectArrayHashCode(this.data, this.columns) == this.objectArrayHashCode(other.data, other.columns);
    }

    private int objectArrayHashCode(Object[][] objects, TableDataColumn[] columns) {
        int prime = 31;
        int result = 1;
        for (int i = 0; i < objects.length; ++i) {
            Object[] col = objects[i];
            for (int j = 0; j < col.length; ++j) {
                Object castedObject = columns[i].getType().cast(col[j]);
                result = columns[i].getType().isArray() ? 31 * result + Arrays.hashCode((Object[])castedObject) : 31 * result + castedObject.hashCode();
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                sb.append(this.columns[i]);
                sb.append('\t');
            }
            sb.append('\n');
        }
        if (this.isEmpty()) {
            return sb.toString();
        }
        int nRows = 0;
        if (this.data[0] != null) {
            nRows = this.data[0].length;
        }
        for (int r = 0; r < nRows; ++r) {
            for (int c = 0; c < this.data.length; ++c) {
                sb.append(this.data[c][r]);
                sb.append('\t');
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

