/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.layout;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.LayoutUtils;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;

class SquaryLayout
implements Layout {
    static final String DESCRIPTION = "Recursively lays out all nodes in a container display in a square grid. The size of each cell in the grid is that of the largest child in the container.";
    private ViewerSorter sorter;
    private Set oldNodes;
    private int itemsPerRow;

    private void visitContainerNode(ImageSet node) {
        Dimension d;
        if (node.getChildrenDisplay().size() == 0) {
            LayoutUtils.noChildLayout(node);
            return;
        }
        Object[] children = this.sorter.sortAsArray(node.getChildrenDisplay());
        int maxY = 0;
        int x = 0;
        int y = 0;
        Dimension dd = node.getPreferredSize();
        for (int i = 0; i < children.length; ++i) {
            ImageDisplay child = (ImageDisplay)children[i];
            d = child.getPreferredSize();
            d = new Dimension(dd.width, d.height);
            child.setBounds(x, y, d.width, d.height);
            child.setCollapsed(false);
            x = 0;
            y = maxY == 0 ? (y += d.height) : (y += maxY);
            maxY = 0;
        }
        Rectangle bounds = node.getContentsBounds();
        d = bounds.getSize();
        node.getInternalDesktop().setSize(d);
        node.getInternalDesktop().setPreferredSize(d);
        node.setCollapsed(false);
    }

    SquaryLayout(ViewerSorter sorter, int itemsPerRow) {
        this.sorter = sorter;
        this.itemsPerRow = itemsPerRow;
    }

    @Override
    public void visit(ImageSet node) {
        if (CollectionUtils.isEmpty((Collection)this.oldNodes)) {
            node.restoreDisplay();
            if (node.isSingleViewMode()) {
                return;
            }
            if (node.getChildrenDisplay().size() == 0) {
                LayoutUtils.noChildLayout(node);
                return;
            }
            if (node.containsImages()) {
                LayoutUtils.doSquareGridLayout(node, this.sorter, this.itemsPerRow);
            } else {
                this.visitContainerNode(node);
            }
        }
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getIndex() {
        return 1;
    }

    @Override
    public void visit(ImageNode node) {
    }

    @Override
    public void doLayout() {
    }

    @Override
    public void setOldNodes(Set oldNodes) {
        this.oldNodes = oldNodes;
    }

    @Override
    public void setImagesPerRow(int number) {
        this.itemsPerRow = number;
    }

    @Override
    public int getImagesPerRow() {
        return this.itemsPerRow;
    }
}

