/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import omero.gateway.model.GroupData;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchPanel;
import org.openmicroscopy.shoola.agents.treeviewer.view.SearchEvent;
import org.openmicroscopy.shoola.util.ui.SeparatorPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.GroupContext;
import org.openmicroscopy.shoola.util.ui.search.SearchContext;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;

public class SearchComponent
extends JPanel
implements ActionListener {
    public static final String UNTAGGED_TEXT = "Untagged";
    public static final String TAGGED_TEXT = "Tagged";
    public static final String COMMENTED_TEXT = "Commented";
    public static final String UNCOMMENTED_TEXT = "Uncommented";
    public static final String UNRATED = "Unrated";
    public static final String NAME_TEXT = "Name";
    public static final String NAME_DESCRIPTION = "Description";
    public static final String NAME_TAGS = "Tags";
    public static final String NAME_COMMENTS = "Comments";
    public static final String NAME_ROIS = "ROIs";
    public static final String NAME_URL = "URL";
    public static final String NAME_ATTACHMENT = "Attachments";
    public static final String NAME_ANNOTATION = "Annotations";
    public static final String NAME_RATE = "Rate";
    public static final String NAME_TIME = "Time";
    public static final String NAME_CUSTOMIZED = "Custom";
    public static final String HAS_ROIS_TEXT = "Has ROIs";
    public static final String NO_ROIS_TEXT = "No ROIs";
    public static final String SEARCH_PROPERTY = "search";
    public static final String CANCEL_SEARCH_PROPERTY = "cancelSearch";
    public static final String NODES_EXPANDED_PROPERTY = "nodesExpanded";
    public static final int CANCEL = 0;
    public static final int SEARCH = 1;
    public static final int COLLAPSE = 2;
    public static final int HELP = 3;
    static final int DATE = 4;
    static final int RESET_DATE = 7;
    static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    protected SearchPanel uiDelegate;
    private JButton searchButton;
    private JXBusyLabel busyLabel;
    private JLabel progressLabel;
    private List<SearchObject> nodes;
    private List<SearchObject> types;
    private SearchContext searchContext;
    private JComponent resultPane;
    protected Collection<GroupData> groups;
    protected List<GroupContext> groupsContext;

    private void initComponents() {
        this.uiDelegate = new SearchPanel(this);
        this.searchButton = new JButton("Search");
        this.searchButton.setToolTipText("Search");
        this.searchButton.setActionCommand("1");
        this.searchButton.addActionListener(this);
        this.searchButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.busyLabel = new JXBusyLabel();
        this.busyLabel.setEnabled(false);
        this.progressLabel = new JLabel("");
        this.progressLabel.setEnabled(false);
        this.progressLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setBorder(null);
        bar.add(this.searchButton);
        JPanel p = UIUtilities.buildComponentPanel(bar);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        return p;
    }

    private JPanel buildStatusBar() {
        JPanel bar = new JPanel();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.progressLabel);
        JPanel p = UIUtilities.buildComponentPanelCenter((JComponent)this.busyLabel);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.add(p);
        return bar;
    }

    private void buildGUI(boolean showControl) {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        double[][] size = new double[][]{{-2.0}, {-2.0, -2.0, -2.0, -2.0, -2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        int i = 0;
        String key = "0, ";
        this.add((Component)this.uiDelegate, key + i);
        ++i;
        if (showControl) {
            this.add((Component)this.buildToolBar(), key + i);
        }
        this.add((Component)this.buildStatusBar(), key + ++i);
        this.resultPane = new JPanel();
        this.resultPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.resultPane.setLayout(new BoxLayout(this.resultPane, 1));
        SeparatorPane sep = new SeparatorPane();
        sep.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add((Component)sep, key + ++i);
        this.add((Component)this.resultPane, key + ++i);
    }

    private void cancel() {
        this.firePropertyChange(CANCEL_SEARCH_PROPERTY, (Object)false, (Object)true);
        this.setSearchEnabled(-1);
    }

    private void setDefaultContext() {
        this.nodes = new ArrayList<SearchObject>();
        SearchObject node = new SearchObject(9, null, NAME_TEXT);
        this.nodes.add(node);
        node = new SearchObject(12, null, NAME_DESCRIPTION);
        this.nodes.add(node);
        node = new SearchObject(14, null, NAME_ANNOTATION);
        this.nodes.add(node);
        this.types = new ArrayList<SearchObject>();
        node = new SearchObject(0, null, "Images");
        this.types.add(node);
        node = new SearchObject(1, null, "Datasets");
        this.types.add(node);
        node = new SearchObject(2, null, "Projects");
        this.types.add(node);
        node = new SearchObject(4, null, "Plates");
        this.types.add(node);
        node = new SearchObject(3, null, "Screens");
        this.types.add(node);
    }

    public SearchComponent(SearchContext context) {
        this.searchContext = context;
    }

    public SearchComponent() {
        this((SearchContext)null);
    }

    public void initialize(Collection<GroupData> groups) {
        this.initialize(true, groups);
    }

    public void initialize(boolean showControl, Collection<GroupData> groups) {
        this.setDefaultContext();
        if (groups == null) {
            throw new IllegalArgumentException("No groups specified.");
        }
        this.groups = groups;
        this.initComponents();
        this.buildGUI(showControl);
    }

    protected List<String> getTerms() {
        String[] terms = this.uiDelegate.getQueryTerms();
        ArrayList<String> l = new ArrayList<String>();
        if (terms != null) {
            for (int i = 0; i < terms.length; ++i) {
                l.add(terms[i]);
            }
        }
        return l;
    }

    protected void setTerms(List<String> terms) {
        this.uiDelegate.setTerms(terms);
    }

    SearchContext getSearchContext() {
        return this.searchContext;
    }

    List<SearchObject> getNodes() {
        return this.nodes;
    }

    List<SearchObject> getTypes() {
        return this.types;
    }

    void notifyNodeExpanded() {
        this.firePropertyChange(NODES_EXPANDED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    void search() {
        List<Integer> scope = this.uiDelegate.getScope();
        String query = this.uiDelegate.getQuery();
        if (query.trim().equals("*")) {
            String msg = "Wildcard searches (*) must contain more than a single wildcard.";
            DataBrowserAgent.getRegistry().getUserNotifier().notifyWarning("Cannot perform search", msg);
            return;
        }
        SearchContext ctx = new SearchContext(query, scope);
        Timestamp start = this.uiDelegate.getFromDate();
        Timestamp end = this.uiDelegate.getToDate();
        if (start != null && end != null) {
            if (start.after(end)) {
                ctx.setTime(end, start);
            } else {
                ctx.setTime(start, end);
            }
        } else if (start != null) {
            ctx.setTime(start, null);
        } else if (end != null) {
            ctx.setTime(null, end);
        }
        ctx.setTimeType(this.uiDelegate.getDateType().equals("Acquisition date") ? 1 : 0);
        ctx.setSelectedOwner(this.uiDelegate.getUserId());
        ctx.setSelectedGroup(this.uiDelegate.getGroupId());
        ctx.setType(this.uiDelegate.getType());
        this.firePropertyChange(SEARCH_PROPERTY, null, ctx);
    }

    List<GroupContext> getGroups() {
        if (this.groupsContext != null && this.groupsContext.size() > 0) {
            return this.groupsContext;
        }
        Iterator<GroupData> i = this.groups.iterator();
        this.groupsContext = new ArrayList<GroupContext>();
        while (i.hasNext()) {
            GroupData g = i.next();
            GroupContext gc = new GroupContext(g);
            this.groupsContext.add(gc);
        }
        return this.groupsContext;
    }

    public void setSearchEnabled(int resultSize) {
        if (resultSize == -1) {
            this.setSearchEnabled("Searching...", false);
        } else {
            this.setSearchEnabled(resultSize + " results found", false);
        }
    }

    public void setSearchEnabled(String text, boolean b) {
        SwingUtilities.invokeLater(() -> {
            this.searchButton.setEnabled(!b);
            this.busyLabel.setEnabled(b);
            this.busyLabel.setBusy(b);
            this.progressLabel.setText(text);
        });
    }

    public void displayResult(JComponent result) {
        this.remove(this.resultPane);
        if (result != null) {
            this.resultPane = result;
            this.resultPane.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.add((Component)this.resultPane, "0, 4");
        }
        this.repaint();
    }

    public void addResult(JComponent result, boolean clear) {
        if (clear) {
            this.resultPane.removeAll();
        }
        if (result == null) {
            return;
        }
        this.resultPane.add(result);
        this.resultPane.add(new JSeparator());
        result.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.search();
                break;
            }
            case 3: {
                String url = (String)DataBrowserAgent.getRegistry().lookup("HelpOnLineSearch");
                this.help(url);
                break;
            }
            case 7: {
                this.uiDelegate.resetDate();
            }
        }
    }

    protected void help(String url) {
    }

    public void handleSearchEvent(SearchEvent evt) {
        this.uiDelegate.reset();
        this.uiDelegate.setTerms(Collections.singletonList(evt.getQuery()));
        this.search();
    }
}

