/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import loci.common.services.ServiceFactory;
import loci.formats.ImageReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.OME;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.actions.ImporterAction;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEHelper;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleList;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleTreeElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.view.ModuleTree;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.HardwareConfigurator;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.EditorFileBrowser;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.ExceptionDialog;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.ExportDialog;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.FNode;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.ImportUserData;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.MapAnnotationObject;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.NodeContainer;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TemplateDialog;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout.ExportAsTemplateFile;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout.ExportToTextFormat;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout.ImportFromTemplateFile;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MetaDataDialog
extends ClosableTabbedPaneComponent
implements ActionListener,
TreeSelectionListener,
TreeExpansionListener,
ListSelectionListener,
ItemListener {
    private static final String OMERO_MICROSCOPE = "omeroMicroscope";
    private static final String OMERO_TEMPLATE = "omeroTemplate";
    private static final String TITLE = "Specify Metadata";
    private JFrame owner;
    private Importer importer;
    private int type;
    private JButton cancelImportButton;
    private JButton importButton;
    private JButton resetFileDataButton;
    private JPopupMenu popupMenu;
    private JButton btn_menu;
    private JComboBox<String> mics;
    private JCheckBox filterCB;
    private EditorFileBrowser fileTree;
    private JPanel metaPanel;
    public static final int DIR = 0;
    public static final int FILE = 1;
    private int lastSelectionType;
    private FNode lastNode;
    private boolean holdData;
    private FileFilter fileFilter;
    private boolean disableItemListener;
    private boolean disableTreeListener;
    public static final String CANCEL_SELECTION_PROPERTY = "cancelSelection";
    public static final String REFRESH_MIC_CONTENT = "refreshMicContent";
    private static final int CMD_IMPORT = 1;
    private static final int CMD_CLOSE = 2;
    private static final int CMD_RESET = 6;
    private static final int CHOOSE_MIC = 13;
    private static final int SAVE_TEMPLATE = 14;
    private static final int LOAD_TEMPLATE = 15;
    private static final int CMD_HARDCONF = 16;
    private static final int EXPORT_DATA = 17;
    private static final int MENU = 18;
    private ModuleController controller;
    private ModuleList fileInstrumentList;
    private File tempFile;
    private String mdeConfigPath;

    public MetaDataDialog(JFrame owner, FileFilter[] filters, int type, ImporterAction importerAction, Importer importer, JButton importBtn, JButton cancelImportBtn, String microscope, String mdeConfigPath) {
        super(1, TITLE, TITLE);
        this.owner = owner;
        this.type = type;
        this.importer = importer;
        this.mdeConfigPath = mdeConfigPath + File.separator + "mdeConfiguration.xml";
        ImporterAgent.getRegistry().getLogger().info((Object)this, "MetadataDialog: Use mdeConfiguration file at " + this.mdeConfigPath);
        this.addImportButtonLink(importBtn);
        this.addCancelImportButtonLink(cancelImportBtn);
        this.setClosable(false);
        this.setCloseVisible(false);
        microscope = this.getMicroscopeName();
        this.controller = ModuleController.getInstance();
        if (this.controller.getMicIndex(microscope) == -1) {
            microscope = "Universal";
            this.controller.setCurrentMicName(microscope);
        }
        this.controller.initMDEConfiguration(microscope, this.mdeConfigPath);
        if (this.getTemplateName() != null) {
            this.tempFile = new File(this.getTemplateName());
        }
        this.initMDE(microscope);
    }

    private void initMDE(String microscope) {
        if (microscope == null || microscope.isEmpty()) {
            this.initComponents(null);
        } else {
            this.initComponents(microscope);
        }
        this.buildGUI();
    }

    public String getMDEConfigPath() {
        return this.mdeConfigPath;
    }

    private void initComponents(String microscope) {
        this.holdData = false;
        this.disableTreeListener = false;
        this.resetFileDataButton = new JButton("Clear Input");
        this.resetFileDataButton.setBackground(UIUtilities.BACKGROUND);
        this.resetFileDataButton.setToolTipText("Reset metadata. Show only metadata of selected image file.");
        this.resetFileDataButton.setActionCommand("6");
        this.resetFileDataButton.addActionListener(this);
        this.resetFileDataButton.setEnabled(false);
        this.btn_menu = new JButton("Menu...");
        this.btn_menu.setBackground(UIUtilities.BACKGROUND);
        this.btn_menu.setActionCommand("18");
        this.btn_menu.addActionListener(this);
        this.btn_menu.setEnabled(true);
        this.initWorkstationList(microscope);
        this.metaPanel = new JPanel(new BorderLayout());
        this.initFileTree();
        this.lastSelectionType = 0;
    }

    private void initWorkstationList(String microscope) {
        if (this.mics == null) {
            this.mics = new JComboBox<String>(this.controller.getMicNames());
            this.mics.setActionCommand("13");
            this.mics.addActionListener(this);
        } else {
            this.mics.removeActionListener(this);
            this.mics.removeAllItems();
            for (String s : this.controller.getMicNames()) {
                this.mics.addItem(s);
            }
            this.mics.addActionListener(this);
        }
        int indexMic = this.controller.getMicIndex(microscope);
        if (indexMic != -1) {
            this.mics.setSelectedIndex(indexMic);
        } else {
            this.mics.setSelectedIndex(0);
        }
    }

    private void initFileTree() {
        FNode rootNode = new FNode("ImportQueue");
        this.fileTree = new EditorFileBrowser(rootNode);
        this.fileTree.addTreeSelectionListener(this);
        this.fileTree.addTreeExpansionListener(this);
    }

    private JPanel buildFileView() {
        JPanel fileView = new JPanel();
        fileView.setLayout(new BorderLayout(0, 0));
        JScrollPane treeView = new JScrollPane(this.fileTree);
        fileView.add(treeView);
        return fileView;
    }

    private JPanel buildToolbar_right() {
        JPanel bar = new JPanel(new FlowLayout(2));
        bar.add(this.resetFileDataButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.cancelImportButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.importButton);
        bar.add(Box.createHorizontalStrut(10));
        return bar;
    }

    private JPanel buildToolbar() {
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        JPanel barR = new JPanel(new FlowLayout(2));
        barR.add(new JLabel("Setup:"));
        barR.add(Box.createHorizontalStrut(2));
        barR.add(this.mics);
        JPanel barT = this.buildMenu();
        JButton btnHardwConf = new JButton("Configuration...");
        btnHardwConf.setActionCommand("16");
        btnHardwConf.addActionListener(this);
        btnHardwConf.setEnabled(false);
        this.filterCB = new JCheckBox("show only required");
        this.filterCB.setSelected(false);
        this.filterCB.setToolTipText("Show only objects with required tag input");
        bar.add(barR);
        bar.add(new JSeparator(1));
        bar.add(btnHardwConf);
        bar.add(new JSeparator(1));
        bar.add(new JSeparator(1));
        bar.add(this.filterCB);
        bar.add(barT);
        bar.add(new JSeparator(1));
        bar.add(this.buildToolbar_right());
        return bar;
    }

    private JPanel buildMenu() {
        JMenu template = new JMenu("Metadata Templates");
        JMenuItem template_save = new JMenuItem("Save...");
        template_save.setActionCommand("14");
        template_save.addActionListener(this);
        JMenuItem template_load = new JMenuItem("Load...");
        template_load.setActionCommand("15");
        template_load.addActionListener(this);
        template.add(template_save);
        template.add(template_load);
        JMenu export = new JMenu("Metadata Export");
        JMenuItem export_txt_format = new JMenuItem("To txt format...");
        export_txt_format.setActionCommand("17");
        export_txt_format.addActionListener(this);
        export.add(export_txt_format);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(template);
        this.popupMenu.add(export);
        JPanel bar = new JPanel(new FlowLayout(2));
        bar.add(this.btn_menu);
        return bar;
    }

    private void showPopupMenu(ActionEvent ae) {
        Component eventSource = (Component)ae.getSource();
        Point pt = eventSource.getLocationOnScreen();
        this.popupMenu.show(this, 0, 0);
        this.popupMenu.setLocation(pt.x, pt.y + eventSource.getHeight());
    }

    private void buildGUI() {
        this.removeAll();
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane(1, this.buildFileView(), this.metaPanel);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(150);
        this.add((Component)splitPane, "Center");
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.buildToolbar());
        controls.add(new JSeparator());
        controls.add(bar);
        this.add((Component)controls, "South");
        this.revalidate();
        this.repaint();
    }

    private DefaultMutableTreeNode loadDataForSelection(FNode node, boolean reload) {
        String file = null;
        if (node == null || (file = this.fileTree.getSelectedFilePath(node)) == null) {
            return null;
        }
        DefaultMutableTreeNode pTree = null;
        HashMap<String, List<TagData>> parentinput = null;
        if (node.getContainer() == null || node.getContainer().getTreeNode() == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Object tree available for selected node: NO");
            FNode pNode = this.getNextParentWithAvailableTree(node);
            if (pNode != null && pNode.getContainer() != null) {
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Parent: " + pNode.getAbsolutePath());
                pTree = pNode.getContainer().getTreeNode();
                parentinput = pNode.getInput();
            }
            try {
                if (file.equals("")) {
                    this.loadDataForDirectory(node);
                }
                this.loadDataForFile(node);
            }
            catch (Exception e) {
                this.resetFileTreeAtError("Metadata Error!", "Can't load metadata of " + file, e);
                return pTree;
            }
        } else {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Object tree available for selected node: YES");
        }
        node.setAnnotation(parentinput);
        return pTree;
    }

    private FNode getNextParentWithAvailableTree(FNode node) {
        FNode pNode = null;
        if (node != null) {
            if ((FNode)node.getParent() != null && ((FNode)node.getParent()).getContainer() != null && ((FNode)node.getParent()).getContainer().getTreeNode() != null) {
                pNode = (FNode)node.getParent();
            }
            if (pNode == null) {
                pNode = this.getNextParentWithAvailableTree((FNode)node.getParent());
            }
        }
        return pNode;
    }

    private void loadDataForFile(FNode node) throws Exception {
        this.lastSelectionType = 1;
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Load data for: FILE");
        NodeContainer cont = new NodeContainer(this.fileTree.getSelectedFilePath(node), null, false);
        node.setContainer(cont);
    }

    private void loadDataForDirectory(FNode node) throws Exception {
        this.lastSelectionType = 0;
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Load data for: DIR");
        if (node != null && !node.isLeaf() && node.getContainer() == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Create container for node " + node.getAbsolutePath());
            NodeContainer cont = new NodeContainer(this.fileTree.getSelectedFilePath(node), null, true);
            node.setContainer(cont);
        }
    }

    private void deselectNodeAction(FNode node) {
        if (node != null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Deselect node: " + node.getAbsolutePath());
            if (this.getCurrentModuleTree() != null) {
                DefaultMutableTreeNode contentTree = this.getCurrentModuleTree().getRoot();
                HashMap<String, List<TagData>> input = MDEHelper.getInput(contentTree);
                if (node.getContainer() != null) {
                    ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] save object tree and instruments");
                    node.getContainer().setTreeNode(contentTree);
                    node.getContainer().setInstruments(this.fileInstrumentList);
                } else {
                    try {
                        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] create new NodeContainer ");
                        NodeContainer cont = new NodeContainer(node.getAbsolutePath(), contentTree, !node.isLeaf());
                        cont.setInstruments(this.fileInstrumentList);
                        node.setContainer(cont);
                    }
                    catch (Exception e) {
                        String s = "[MDE] Can't create new NodeContainer for saving content for " + node.getAbsolutePath();
                        LogMessage msg = new LogMessage();
                        msg.print(s);
                        msg.print((Throwable)e);
                        ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
                    }
                }
                if (!node.isLeaf()) {
                    this.saveInputToChilds(node, input, this.getCurrentModuleTree().changeTreeStructure());
                }
                MDEHelper.resetInput(contentTree);
                this.getCurrentModuleTree().setChangeTreeStructure(false);
                node.setAnnotation(input);
            }
            this.lastNode = node;
        }
    }

    private void saveInputToChilds(FNode node, HashMap<String, List<TagData>> input, boolean treeChanges) {
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                FNode child = (FNode)node.getChildAt(i);
                if (child.getContainer() != null && child.getContainer().getTreeNode() != null) {
                    List<String> leafPath;
                    DefaultMutableTreeNode childTree = child.getContainer().getTreeNode();
                    if (input != null && !input.isEmpty()) {
                        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] update child: " + child.getAbsolutePath());
                        MDEHelper.replaceData(childTree, input, treeChanges);
                        child.setAnnotation(input);
                    }
                    if (treeChanges && node.getContainer() != null && (leafPath = MDEHelper.getAdditionalLeafsInTree(node.getContainer().getTreeNode(), childTree)) != null && !leafPath.isEmpty()) {
                        MDEHelper.insertObjects(leafPath, childTree);
                    }
                }
                if (child.isLeaf()) continue;
                this.saveInputToChilds(child, input, treeChanges);
            }
        }
    }

    private void updateObjectTree(FNode node) {
        if (node == null || node.getContainer() == null) {
            return;
        }
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] update object tree");
        DefaultMutableTreeNode tree = node.getContainer().getTreeNode();
        if (tree != null) {
            HashMap<String, List<TagData>> cinput = MDEHelper.getInput(tree);
            ModuleTree newTree = this.getCurrentModuleTree();
            newTree.customizeTree(this.controller.getCurrentMicName());
            node.getContainer().setTreeNode(newTree.getRoot());
            MDEHelper.addData(newTree.getRoot(), cinput);
        }
    }

    private void updateObjectTreeByTree(FNode node, DefaultMutableTreeNode newTreeRoot) {
        if (node == null) {
            return;
        }
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] update object tree by tree");
        DefaultMutableTreeNode tree = node.getContainer().getTreeNode();
        if (tree != null) {
            HashMap<String, List<TagData>> cinput = MDEHelper.getInput(tree);
            node.getContainer().setTreeNode(newTreeRoot);
            MDEHelper.addData(node.getContainer().getTreeNode(), cinput);
        }
    }

    private void updateObjectTreeByData(FNode node, DefaultMutableTreeNode newTreeRoot, List<String> filter) {
        if (node == null || newTreeRoot == null) {
            return;
        }
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] update object tree by data");
        DefaultMutableTreeNode tree = this.getCurrentModuleTreeRoot();
        if (tree != null) {
            Enumeration<TreeNode> e = newTreeRoot.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                if (n.getUserObject() == null || ((ModuleTreeElement)n.getUserObject()).getData() == null || !filter.contains(((ModuleTreeElement)n.getUserObject()).getType())) continue;
                ((ModuleTreeElement)n.getUserObject()).getData().setAllDataChanged();
            }
            HashMap<String, List<TagData>> cinput = MDEHelper.getInput(newTreeRoot);
            if (cinput == null) {
                return;
            }
            MDEHelper.addData(tree, cinput);
            if (node.getContainer() != null) {
                node.getContainer().setTreeNode(tree);
            }
        } else {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] update object tree by data: no current tree available");
        }
    }

    private void resetObjectTree() {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] reset object tree");
        ModuleTree treePanel = this.getCurrentModuleTree();
        DefaultMutableTreeNode initRoot = this.getInitialFileObjectRootNode();
        if (initRoot == null) {
            initRoot = this.controller.getTree();
        }
        if (treePanel != null) {
            FNode node = (FNode)this.fileTree.getLastSelectedPathComponent();
            HashMap<String, List<TagData>> minput = node.getInput();
            HashMap<String, List<TagData>> cinput = MDEHelper.getInput(treePanel.getRoot());
            if (minput != null) {
                if (cinput == null) {
                    cinput = new HashMap();
                }
                for (Map.Entry<String, List<TagData>> entry : minput.entrySet()) {
                    cinput.put(entry.getKey(), MDEHelper.cloneTagList(entry.getValue()));
                }
            }
            node.reset();
            this.selectNodeAction(node);
            ModuleTree newTree = this.getCurrentModuleTree();
            MDEHelper.addData(newTree.getRoot(), cinput);
        }
    }

    private void removeObject() {
        TreePath selectedNode;
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] PRESS DELETE object tree");
        ModuleTree treePanel = this.getCurrentModuleTree();
        if (treePanel != null && (selectedNode = treePanel.getTree().getSelectionPath()) != null) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)selectedNode.getLastPathComponent();
            ModuleTreeElement cElem = (ModuleTreeElement)current.getUserObject();
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] delete node : " + cElem.toString());
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)current.getParent();
            if (parent != null) {
                List<String> oldTreePaths = MDEHelper.getAllLeafPaths(treePanel.getRoot(), "");
                treePanel.removeNodeFromParent(current);
                if (this.lastSelectionType == 0) {
                    List<String> newTreePaths = MDEHelper.getAllLeafPaths(treePanel.getRoot(), "");
                    List<String> deleteNodes = MDEHelper.getAdditionalLeafPaths(oldTreePaths, newTreePaths);
                    this.resetObjectTreeOfChilds((FNode)this.fileTree.getLastSelectedPathComponent(), deleteNodes);
                }
                ((FNode)this.fileTree.getLastSelectedPathComponent()).getContainer().setTreeNode(treePanel.getRoot());
            }
        }
    }

    private void resetObjectTreeOfChilds(FNode node, List<String> deleteObjectPaths) {
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                FNode child = (FNode)node.getChildAt(i);
                if (child.getContainer() != null && child.getContainer().getTreeNode() != null && deleteObjectPaths != null && !deleteObjectPaths.isEmpty()) {
                    MDEHelper.deleteObjects(deleteObjectPaths, child.getContainer().getTreeNode());
                }
                if (child.isLeaf()) continue;
                this.resetObjectTreeOfChilds(child, deleteObjectPaths);
            }
        }
    }

    private ImportUserData getImportData() {
        ImportUserData data = null;
        try {
            FNode node = (FNode)this.fileTree.getLastSelectedPathComponent();
            if (node == null) {
                return null;
            }
            while (!node.hasImportData()) {
                node = (FNode)node.getParent();
            }
            data = node.getImportData();
        }
        catch (Exception e) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] issue on get import data");
            return null;
        }
        return data;
    }

    public void refreshFileView(List<ImportableFile> files, FileFilter fileFilter) {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] refresh file view");
        this.fileFilter = fileFilter;
        this.fileTree.setFileFilter(fileFilter);
        this.metaPanel.removeAll();
        this.fileTree.createNodes(files, this.holdData);
        this.disableTreeListener = false;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if ("reset".equals(evt.getActionCommand())) {
            this.resetObjectTree();
        } else if ("delete".equals(evt.getActionCommand())) {
            this.removeObject();
        } else {
            int commandId = Integer.parseInt(evt.getActionCommand());
            switch (commandId) {
                case 2: {
                    ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] -- close");
                    this.firePropertyChange(CANCEL_SELECTION_PROPERTY, (Object)false, (Object)true);
                    break;
                }
                case 13: {
                    if (this.mics.getSelectedIndex() == -1) break;
                    String newSelection = this.controller.getMicNames()[this.mics.getSelectedIndex()];
                    ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] load setup: " + newSelection);
                    this.setMicroscopeName(newSelection);
                    this.controller.setCurrentMicName(newSelection);
                    if (this.fileTree != null) {
                        this.deselectNodeAction((FNode)this.fileTree.getLastSelectedPathComponent());
                        this.updateObjectConf((FNode)this.fileTree.getLastSelectedPathComponent());
                        FNode thisNode = (FNode)this.fileTree.getLastSelectedPathComponent();
                        DefaultMutableTreeNode pTree = this.loadDataForSelection(thisNode, true);
                        this.updateObjectTree(thisNode);
                        if (thisNode != null) {
                            this.showMDE(thisNode.getContainer(), pTree);
                        }
                    }
                    String newTitle = this.controller.getCurrentMicName();
                    this.firePropertyChange("refreshDialogTitle", null, newTitle);
                    break;
                }
                case 6: {
                    ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] clear input");
                    FNode selection = (FNode)this.fileTree.getLastSelectedPathComponent();
                    if (selection == null) break;
                    selection.reset();
                    try {
                        if (!selection.isLeaf()) {
                            this.loadDataForDirectory(selection);
                        } else {
                            this.loadDataForFile(selection);
                        }
                    }
                    catch (Exception e) {
                        String s = "[MDE] An error occurred when loading the file: ";
                        LogMessage msg = new LogMessage();
                        msg.print(s);
                        msg.print((Throwable)e);
                        ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
                    }
                    this.showMDE(selection.getContainer(), null);
                    break;
                }
                case 17: {
                    this.export();
                    break;
                }
                case 14: {
                    DefaultMutableTreeNode root = this.getCurrentModuleTreeRoot();
                    TemplateDialog jsonDialog = new TemplateDialog(new JFrame(), this.tempFile, false, root);
                    if (jsonDialog.isCancelled().booleanValue()) break;
                    List<String> selectedModules = jsonDialog.getSelectionSave();
                    this.tempFile = jsonDialog.getDestination();
                    this.setTemplateName(this.tempFile);
                    if (selectedModules != null && this.tempFile != null) {
                        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Save to tempfile: " + this.tempFile.getAbsolutePath());
                        ExportAsTemplateFile exporter = new ExportAsTemplateFile(this.tempFile.getAbsolutePath());
                        exporter.export(root, selectedModules);
                        break;
                    }
                    ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] WARN: Export template failed !");
                    break;
                }
                case 15: {
                    DefaultMutableTreeNode thisroot = this.getCurrentModuleTreeRoot();
                    TemplateDialog openF = new TemplateDialog(new JFrame(), this.tempFile, true, thisroot);
                    if (openF.isCancelled().booleanValue()) break;
                    this.tempFile = openF.getDestination();
                    if (this.tempFile == null) {
                        return;
                    }
                    ImportFromTemplateFile tempImporter = new ImportFromTemplateFile(this.tempFile.getAbsolutePath());
                    List<String> availableTypelist = tempImporter.createTypeList();
                    List<String> selectedModulesO = openF.getSelectionLoad(availableTypelist);
                    Boolean loadTreeStructure = openF.loadTreeStructure();
                    this.setTemplateName(this.tempFile);
                    FNode thisNode = (FNode)this.fileTree.getLastSelectedPathComponent();
                    this.deselectNodeAction(thisNode);
                    tempImporter.parseTemplateFile(selectedModulesO);
                    ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Load from tempfile: " + this.tempFile.getAbsolutePath());
                    DefaultMutableTreeNode newTree = tempImporter.getTempObjTree();
                    if (loadTreeStructure.booleanValue()) {
                        this.updateObjectTreeByTree(thisNode, newTree);
                    } else {
                        this.updateObjectTreeByData(thisNode, newTree, selectedModulesO);
                    }
                    this.updateObjectConf(thisNode);
                    if (thisNode == null) break;
                    this.showMDE(thisNode.getContainer(), null);
                    break;
                }
                case 16: {
                    HardwareConfigurator conf = new HardwareConfigurator(this);
                    break;
                }
                case 18: {
                    this.showPopupMenu(evt);
                }
            }
        }
    }

    private void export() {
        block5: {
            ExportDialog exportDialog = new ExportDialog(ImporterAgent.getRegistry().getTaskBar().getFrame());
            File exportFile = exportDialog.getDestination();
            boolean addPath = exportDialog.addPath();
            boolean addUnitToKey = exportDialog.addUnitToKey();
            boolean exportAll = exportDialog.exportAll();
            String delimeter = exportDialog.getDelimeter();
            int mode = exportDialog.getFormatMode();
            boolean appendToFile = exportDialog.getWritingMode();
            if (exportFile != null) {
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Export to: " + exportFile.getAbsolutePath());
                ExportToTextFormat exporter = new ExportToTextFormat(exportFile.getAbsolutePath(), delimeter, appendToFile, mode);
                try {
                    if (exportAll) {
                        exporter.exportAll(this.getCurrentModuleTreeRoot(), addPath, addUnitToKey);
                        break block5;
                    }
                    exporter.export(this.getCurrentModuleTreeRoot(), addPath, addUnitToKey);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, e.getMessage());
                    LogMessage msg = new LogMessage();
                    msg.print("[MDE] WARN: Export failed !");
                    msg.print((Throwable)e);
                    ImporterAgent.getRegistry().getLogger().debug((Object)this, msg);
                }
            } else {
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] WARN: Export failed !");
            }
        }
    }

    private void updateObjectConf(FNode fnode) {
        DefaultMutableTreeNode treeNode;
        if (fnode == null) {
            return;
        }
        if (fnode.getContainer() != null && (treeNode = fnode.getContainer().getTreeNode()) != null) {
            Enumeration<TreeNode> e = treeNode.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                ModuleContent content = this.controller.getContentOfType(((ModuleTreeElement)node.getUserObject()).getType());
                if (content == null) continue;
                ((ModuleTreeElement)node.getUserObject()).setProperties(content.getProperties());
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] TreeselectEvent: valueChanged");
        if (!this.disableTreeListener) {
            FNode selectedNode = null;
            FNode lastSelectedNode = null;
            TreePath[] paths = e.getPaths();
            for (int i = 0; i < paths.length; ++i) {
                if (e.isAddedPath(i)) {
                    selectedNode = (FNode)paths[i].getLastPathComponent();
                    continue;
                }
                lastSelectedNode = (FNode)paths[i].getLastPathComponent();
            }
            this.deselectNodeAction(lastSelectedNode);
            this.selectNodeAction(selectedNode);
        }
    }

    private void selectNodeAction(FNode selectedNode) {
        if (selectedNode != null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] Select node: " + selectedNode.getAbsolutePath());
            this.resetFileDataButton.setEnabled(true);
            DefaultMutableTreeNode pTree = this.loadDataForSelection(selectedNode, false);
            this.updateObjectConf(selectedNode);
            this.showMDE(selectedNode.getContainer(), pTree);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent arg0) {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent arg0) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            // empty if block
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] item state change");
        if (!this.disableItemListener) {
            FNode node = (FNode)this.fileTree.getLastSelectedPathComponent();
            String file = this.fileTree.getSelectedFilePath(node);
            if (node == null || file == null) {
                return;
            }
            DefaultMutableTreeNode pTree = null;
            if (node.getParent() != null && ((FNode)node.getParent()).getContainer() != null) {
                pTree = ((FNode)node.getParent()).getContainer().getTreeNode();
            }
            try {
                if (file.equals("")) {
                    this.loadDataForDirectory(node);
                } else {
                    this.loadDataForFile(node);
                }
            }
            catch (Exception ex) {
                ImporterAgent.getRegistry().getLogger().error((Object)this, "[MDE] can't read METADATA of selection " + node.getAbsolutePath());
                this.resetFileTreeAtError("Metadata Error!", "Can't read given metadata of " + file, ex);
                return;
            }
            this.showMDE(node.getContainer(), pTree);
        }
    }

    private void showMDE(NodeContainer container, DefaultMutableTreeNode pTree) {
        this.metaPanel.removeAll();
        if (container == null) {
            return;
        }
        MDEContent content = null;
        DefaultMutableTreeNode objectTree = container.getTreeNode();
        if (objectTree == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] initial content load: Yes ");
            if (pTree == null) {
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] initial load: use setup object tree ");
                objectTree = this.controller.getTree();
            } else {
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] initial load: use parent object tree ");
                objectTree = ModuleTree.cloneTreeNode(pTree);
            }
            content = !container.isDir() ? new MDEContent(this.createMetadataReader(container.getNodeObject()), objectTree, this.controller, this) : new MDEContent(objectTree, this.controller, container.isDir(), null, this);
        } else {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] initial content load: No ");
            content = new MDEContent(objectTree, this.controller, container.isDir(), container.getInstruments(), this);
        }
        this.fileInstrumentList = content.getInstrumentList();
        this.metaPanel.add((Component)content, "Center");
        this.filterCB.addItemListener(content);
        this.revalidate();
        this.repaint();
    }

    private ModuleTree getCurrentModuleTree() {
        if (this.metaPanel == null) {
            return null;
        }
        for (Component c : this.metaPanel.getComponents()) {
            if (!(c instanceof MDEContent)) continue;
            return ((MDEContent)c).getModuleTree();
        }
        return null;
    }

    private DefaultMutableTreeNode getCurrentModuleTreeRoot() {
        ModuleTree cTree = this.getCurrentModuleTree();
        if (cTree != null) {
            return cTree.getRoot();
        }
        return null;
    }

    private DefaultMutableTreeNode getInitialFileObjectRootNode() {
        if (this.metaPanel == null) {
            return null;
        }
        for (Component c : this.metaPanel.getComponents()) {
            if (!(c instanceof MDEContent)) continue;
            return ((MDEContent)c).getInitialFileObjectRootNode();
        }
        return null;
    }

    private void resetFileTreeAtError(String error1, String error2, Exception e) {
        ExceptionDialog ld = new ExceptionDialog(error1, error2, e, this.getClass().getSimpleName());
        ld.setVisible(true);
        this.fileTree.setSelectionPath(this.fileTree.getSelectionPath().getParentPath());
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void addImportButtonLink(JButton importButton) {
        this.importButton = importButton;
    }

    private void addCancelImportButtonLink(JButton cancelImportBtn) {
        this.cancelImportButton = cancelImportBtn;
    }

    public void saveChanges(String text) {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] PRESS import: save changes");
        this.deselectNodeAction((FNode)this.fileTree.getLastSelectedPathComponent());
        this.saveMapAnnotations();
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] clean up");
        this.initMDE(this.getMicName());
    }

    private void saveMapAnnotations() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.fileTree.getModel();
        FNode root = (FNode)treeModel.getRoot();
        this.saveMapAnnotationForLeafs(root, null);
    }

    private void saveMapAnnotationForLeafs(FNode node, MapAnnotationObject parentMap) {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "-- save map annotation: " + node.getAbsolutePath());
        MapAnnotationObject maps = node.getMapAnnotation();
        if (maps == null && parentMap != null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "\t => use parent mapAnnotation");
            maps = new MapAnnotationObject(parentMap);
        }
        if (node.isLeaf()) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "-- LEAF NODE MAP");
            if (maps != null) {
                maps.setFileName(node.getAbsolutePath());
                this.firePropertyChange("addMapAnnotation", null, maps);
            } else {
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "\t mapAnnotation is null");
            }
        } else {
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                this.saveMapAnnotationForLeafs((FNode)children.nextElement(), maps);
            }
        }
    }

    public void setMicroscopeName(String name) {
        if (name == null) {
            return;
        }
        Preferences prefs = Preferences.userNodeForPackage(MetaDataDialog.class);
        prefs.put(OMERO_MICROSCOPE, name);
    }

    private String getMicroscopeName() {
        Preferences prefs = Preferences.userNodeForPackage(MetaDataDialog.class);
        return prefs.get(OMERO_MICROSCOPE, null);
    }

    public String getMicName() {
        return this.controller.getCurrentMicName();
    }

    public String getMicDesc() {
        return "\t (no filter for objects; no predefinitions)";
    }

    private OME createMetadataReader(String fName) {
        Cursor cursor;
        OME ome;
        block3: {
            ImageReader reader = new ImageReader();
            ome = null;
            cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                ServiceFactory factory = new ServiceFactory();
                OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
                OMEXMLMetadata metadata = service.createOMEXMLMetadata();
                reader.setMetadataStore((MetadataStore)metadata);
                reader.setId(fName);
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] -- use READER: " + reader.getReader().getClass().getName());
                ImporterAgent.getRegistry().getLogger().debug((Object)this, "-- Use Reader: " + reader.getReader().getClass().getSimpleName());
                String xml = service.getOMEXML((MetadataRetrieve)metadata);
                ome = (OME)service.createOMEXMLRoot(xml);
            }
            catch (Exception e) {
                ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] file format of " + fName + "not readable by bio-formats!");
                if (cursor == null) break block3;
                this.setCursor(cursor);
            }
        }
        if (cursor != null) {
            this.setCursor(cursor);
        }
        return ome;
    }

    public void setTemplateName(File file) {
        if (file == null) {
            return;
        }
        String name = file.getAbsolutePath();
        Preferences prefs = Preferences.userNodeForPackage(MetaDataDialog.class);
        prefs.put(OMERO_TEMPLATE, name);
    }

    private String getTemplateName() {
        Preferences prefs = Preferences.userNodeForPackage(MetaDataDialog.class);
        return prefs.get(OMERO_TEMPLATE, null);
    }

    public void reloadView() {
        this.initWorkstationList(this.controller.getCurrentMicName());
    }
}

